/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.project.ant.UserQuestionHandler;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.UserQuestionException;
import org.openide.util.Utilities;

final class ProjectProperties {
    private final AntProjectHelper helper;
    private final Map<String, PP> properties = new HashMap<String, PP>();
    private PropertyProvider stockPropertyPreprovider = null;
    private PropertyEvaluator standardPropertyEvaluator = null;

    public ProjectProperties(AntProjectHelper antProjectHelper) {
        this.helper = antProjectHelper;
    }

    public EditableProperties getProperties(String string) {
        EditableProperties editableProperties = this.getPP(string).getEditablePropertiesOrNull();
        if (editableProperties != null) {
            return editableProperties.cloneProperties();
        }
        return new EditableProperties(true);
    }

    public boolean putProperties(String string, EditableProperties editableProperties) {
        return this.getPP(string).put(editableProperties);
    }

    public FileLock write(String string) throws IOException {
        assert (this.properties.containsKey(string));
        return this.getPP(string).write();
    }

    public PropertyProvider getPropertyProvider(String string) {
        return this.getPP(string);
    }

    private PP getPP(String string) {
        PP pP = this.properties.get(string);
        if (pP == null) {
            pP = new PP(string, this.helper);
            this.properties.put(string, pP);
        }
        return pP;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertyProvider getStockPropertyPreprovider() {
        if (this.stockPropertyPreprovider == null) {
            Map map;
            Properties properties = System.getProperties();
            Serializable serializable = properties;
            synchronized (serializable) {
                map = NbCollections.checkedMapByCopy((Map)properties, String.class, String.class, (boolean)false);
            }
            map.put("basedir", FileUtil.toFile((FileObject)this.helper.getProjectDirectory()).getAbsolutePath());
            serializable = InstalledFileLocator.getDefault().locate("ant/lib/ant.jar", "org.apache.tools.ant.module", false);
            if (serializable != null) {
                File file = ((File)serializable).getParentFile().getParentFile();
                map.put("ant.home", file.getAbsolutePath());
                map.put("ant.core.lib", ((File)serializable).getAbsolutePath());
            }
            this.stockPropertyPreprovider = PropertyUtils.fixedPropertyProvider(map);
        }
        return this.stockPropertyPreprovider;
    }

    public PropertyEvaluator getStandardPropertyEvaluator() {
        if (this.standardPropertyEvaluator == null) {
            PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator(this.getStockPropertyPreprovider(), this.getPropertyProvider("nbproject/private/private.properties"));
            PropertyProvider propertyProvider = PropertyUtils.userPropertiesProvider(propertyEvaluator, "user.properties.file", FileUtil.toFile((FileObject)this.helper.getProjectDirectory()));
            this.standardPropertyEvaluator = PropertyUtils.sequentialPropertyEvaluator(this.getStockPropertyPreprovider(), this.getPropertyProvider("nbproject/private/private.properties"), this.helper.getProjectLibrariesPropertyProvider(), propertyProvider, this.getPropertyProvider("nbproject/project.properties"));
        }
        return this.standardPropertyEvaluator;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class PP
    implements PropertyProvider,
    FileChangeListener {
        private static final RequestProcessor RP = new RequestProcessor("ProjectProperties.PP.RP");
        private final String path;
        private final AntProjectHelper helper;
        private EditableProperties properties = null;
        private boolean loaded = false;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private boolean writing = false;

        public PP(String string, AntProjectHelper antProjectHelper) {
            this.path = string;
            this.helper = antProjectHelper;
            FileUtil.addFileChangeListener((FileChangeListener)this, (File)new File(FileUtil.toFile((FileObject)this.dir()), string.replace('/', File.separatorChar)));
        }

        private FileObject dir() {
            return this.helper.getProjectDirectory();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public EditableProperties getEditablePropertiesOrNull() {
            if (!this.loaded) {
                this.properties = null;
                FileObject fileObject = this.dir().getFileObject(this.path);
                if (fileObject != null) {
                    try {
                        EditableProperties editableProperties;
                        InputStream inputStream = fileObject.getInputStream();
                        try {
                            editableProperties = new EditableProperties(true);
                            editableProperties.load(inputStream);
                        }
                        finally {
                            inputStream.close();
                        }
                        this.properties = editableProperties;
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify(1, (Throwable)iOException);
                    }
                }
                this.loaded = true;
            }
            return this.properties;
        }

        public boolean put(EditableProperties editableProperties) {
            boolean bl;
            this.loaded = true;
            boolean bl2 = bl = !Utilities.compareObjects((Object)editableProperties, (Object)this.properties);
            if (bl) {
                this.properties = editableProperties != null ? editableProperties.cloneProperties() : null;
                this.fireChange();
            }
            return bl;
        }

        public FileLock write() throws IOException {
            assert (this.loaded);
            final FileObject fileObject = this.dir().getFileObject(this.path);
            assert (!this.writing);
            final FileLock[] fileLockArray = new FileLock[1];
            this.writing = true;
            try {
                if (this.properties != null) {
                    this.dir().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() throws IOException {
                            FileObject fileObject2;
                            if (fileObject == null) {
                                fileObject2 = FileUtil.createData((FileObject)PP.this.dir(), (String)PP.this.path);
                                assert (fileObject2 != null) : "FU.cD must not return null; called on " + PP.access$000(PP.this) + " + " + PP.access$100(PP.this);
                            } else {
                                fileObject2 = fileObject;
                            }
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            PP.this.properties.store(byteArrayOutputStream);
                            final byte[] byArray = byteArrayOutputStream.toByteArray();
                            try {
                                fileLockArray[0] = fileObject2.lock();
                                OutputStream outputStream = fileObject2.getOutputStream(fileLockArray[0]);
                                try {
                                    outputStream.write(byArray);
                                }
                                finally {
                                    outputStream.close();
                                }
                            }
                            catch (UserQuestionException userQuestionException) {
                                PP.this.helper.needPendingHook();
                                UserQuestionHandler.handle(userQuestionException, new UserQuestionHandler.Callback(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void accepted() {
                                        assert (!PP.this.writing);
                                        PP.this.writing = true;
                                        try {
                                            FileLock fileLock = fileObject2.lock();
                                            try {
                                                OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                                                try {
                                                    outputStream.write(byArray);
                                                }
                                                finally {
                                                    outputStream.close();
                                                }
                                            }
                                            finally {
                                                fileLock.releaseLock();
                                            }
                                            PP.this.helper.maybeCallPendingHook();
                                        }
                                        catch (IOException iOException) {
                                            ErrorManager.getDefault().notify((Throwable)iOException);
                                            this.reload();
                                        }
                                        finally {
                                            PP.this.writing = false;
                                        }
                                    }

                                    public void denied() {
                                        this.reload();
                                    }

                                    public void error(IOException iOException) {
                                        ErrorManager.getDefault().notify((Throwable)iOException);
                                        this.reload();
                                    }

                                    private void reload() {
                                        PP.this.helper.cancelPendingHook();
                                        PP.this.diskChange();
                                    }
                                });
                            }
                        }
                    });
                } else if (fileObject != null) {
                    fileObject.delete();
                }
            }
            catch (IOException iOException) {
                if (fileLockArray[0] != null) {
                    fileLockArray[0].releaseLock();
                }
                throw iOException;
            }
            finally {
                this.writing = false;
            }
            return fileLockArray[0];
        }

        @Override
        public Map<String, String> getProperties() {
            EditableProperties editableProperties = this.getEditablePropertiesOrNull();
            if (editableProperties != null) {
                return Collections.unmodifiableMap(editableProperties);
            }
            return Collections.emptyMap();
        }

        @Override
        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        @Override
        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        private void fireChange() {
            if (!this.cs.hasListeners()) {
                return;
            }
            Mutex.Action<Void> action = new Mutex.Action<Void>(){

                public Void run() {
                    PP.this.cs.fireChange();
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess((Mutex.Action)action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RP.post(new Runnable((Mutex.Action)action){
                    final /* synthetic */ Mutex.Action val$action;
                    {
                        this.val$action = action;
                    }

                    public void run() {
                        ProjectManager.mutex().readAccess(this.val$action);
                    }
                });
            }
        }

        private void diskChange() {
            if (!this.writing) {
                this.loaded = false;
            }
            this.fireChange();
            if (!this.writing) {
                this.helper.fireExternalChange(this.path);
            }
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.diskChange();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.diskChange();
        }

        public void fileChanged(FileEvent fileEvent) {
            this.diskChange();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.diskChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            this.diskChange();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.diskChange();
        }
    }
}

