/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.FilterPropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.openide.ErrorManager;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbCollections;
import org.openide.util.RequestProcessor;
import org.openide.util.TopologicalSortException;
import org.openide.util.Union2;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyUtils {
    private static Map<File, Reference<PropertyProvider>> globalPropertyProviders = new HashMap<File, Reference<PropertyProvider>>();
    private static final Pattern RELATIVE_SLASH_SEPARATED_PATH = Pattern.compile("[^:/\\\\.][^:/\\\\]*(/[^:/\\\\.][^:/\\\\]*)*");
    private static final Pattern VALID_PROPERTY_NAME = Pattern.compile("[-._a-zA-Z0-9]+");

    private PropertyUtils() {
    }

    static File userBuildProperties() {
        String string = System.getProperty("netbeans.user");
        if (string != null) {
            return FileUtil.normalizeFile((File)new File(string, "build.properties"));
        }
        return null;
    }

    public static EditableProperties getGlobalProperties() {
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public EditableProperties run() {
                File file = PropertyUtils.userBuildProperties();
                if (file != null && file.isFile() && file.canRead()) {
                    EditableProperties editableProperties;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        EditableProperties editableProperties2 = new EditableProperties(true);
                        editableProperties2.load(fileInputStream);
                        editableProperties = editableProperties2;
                    }
                    catch (Throwable throwable) {
                        try {
                            ((InputStream)fileInputStream).close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(PropertyUtils.class.getName()).log(Level.INFO, null, iOException);
                        }
                    }
                    ((InputStream)fileInputStream).close();
                    return editableProperties;
                }
                return new EditableProperties(true);
            }
        });
    }

    public static void putGlobalProperties(final EditableProperties editableProperties) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Void run() throws IOException {
                    block15: {
                        File file = PropertyUtils.userBuildProperties();
                        if (file != null) {
                            FileObject fileObject = FileUtil.toFileObject((File)file);
                            if (fileObject == null) {
                                if (!file.exists()) {
                                    file.getParentFile().mkdirs();
                                    new FileOutputStream(file).close();
                                    assert (file.isFile()) : "Did not actually make " + file;
                                }
                                if ((fileObject = FileUtil.toFileObject((File)file)) == null) {
                                    ErrorManager.getDefault().log(16, "Warning - cannot properly write to " + file + "; might be because your user directory is on a Windows UNC path (issue #46813)? If so, try using mapped drive letters.");
                                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                                    try {
                                        editableProperties.store(fileOutputStream);
                                    }
                                    finally {
                                        ((OutputStream)fileOutputStream).close();
                                    }
                                    return null;
                                }
                            }
                            FileLock fileLock = fileObject.lock();
                            try {
                                OutputStream outputStream = fileObject.getOutputStream(fileLock);
                                try {
                                    editableProperties.store(outputStream);
                                    break block15;
                                }
                                finally {
                                    outputStream.close();
                                }
                            }
                            finally {
                                fileLock.releaseLock();
                            }
                        }
                        throw new IOException("Do not know where to store build.properties; must set netbeans.user!");
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static synchronized PropertyProvider globalPropertyProvider() {
        File file = PropertyUtils.userBuildProperties();
        if (file != null) {
            PropertyProvider propertyProvider;
            Reference<PropertyProvider> reference = globalPropertyProviders.get(file);
            if (reference != null && (propertyProvider = reference.get()) != null) {
                return propertyProvider;
            }
            propertyProvider = PropertyUtils.propertiesFilePropertyProvider(file);
            globalPropertyProviders.put(file, new SoftReference<PropertyProvider>(propertyProvider));
            return propertyProvider;
        }
        return PropertyUtils.fixedPropertyProvider(Collections.<String, String>emptyMap());
    }

    public static PropertyProvider propertiesFilePropertyProvider(File file) {
        assert (file != null);
        return new FilePropertyProvider(file);
    }

    private static Map<String, String> evaluateAll(Map<String, String> map, List<Map<String, String>> list) {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        for (Map<String, String> map2 : list) {
            Object object;
            String string;
            Object object22;
            Map.Entry<String, String> entry2;
            HashMap hashMap2 = new HashMap();
            for (Map.Entry<String, String> entry2 : map2.entrySet()) {
                object22 = entry2.getKey();
                if (hashMap.containsKey(object22)) continue;
                string = (String)entry2.getValue();
                object = PropertyUtils.substitute(string, hashMap, map2.keySet());
                if (object.hasFirst()) {
                    hashMap.put((String)object22, (String)object.first());
                    continue;
                }
                hashMap2.put(object22, object.second());
            }
            HashSet hashSet = new HashSet(hashMap2.keySet());
            for (Object object22 : hashMap2.values()) {
                hashSet.addAll(object22);
            }
            try {
                entry2 = Utilities.topologicalSort((Collection)hashSet, hashMap2);
            }
            catch (TopologicalSortException topologicalSortException) {
                return null;
            }
            Collections.reverse(entry2);
            object22 = entry2.iterator();
            while (object22.hasNext()) {
                string = (String)object22.next();
                if (hashMap.containsKey(string)) continue;
                object = map2.get(string);
                hashMap.put(string, (String)PropertyUtils.substitute(object, hashMap, map2.keySet()).first());
            }
        }
        return hashMap;
    }

    private static Union2<String, Set<String>> substitute(String string, Map<String, String> map, Set<String> set) {
        assert (string != null) : "null rawval passed in";
        if (string.indexOf(36) == -1) {
            return Union2.createFirst((Object)string);
        }
        int n = 0;
        StringBuffer stringBuffer = new StringBuffer();
        HashSet<String> hashSet = new HashSet<String>();
        while (true) {
            int n2;
            if ((n2 = string.indexOf(36, n)) == -1 || n2 == string.length() - 1) {
                if (hashSet.isEmpty()) {
                    stringBuffer.append(string.substring(n));
                    return Union2.createFirst((Object)stringBuffer.toString());
                }
                return Union2.createSecond(hashSet);
            }
            char c = string.charAt(n2 + 1);
            if (c == '$') {
                if (hashSet.isEmpty()) {
                    stringBuffer.append('$');
                }
                n += 2;
                continue;
            }
            if (c == '{') {
                int n3 = string.indexOf(125, n2 + 2);
                if (n3 != -1) {
                    String string2 = string.substring(n2 + 2, n3);
                    if (map.containsKey(string2)) {
                        if (hashSet.isEmpty()) {
                            stringBuffer.append(string.substring(n, n2));
                            stringBuffer.append(map.get(string2));
                        }
                        n = n3 + 1;
                        continue;
                    }
                    if (set.contains(string2)) {
                        hashSet.add(string2);
                        n = n3 + 1;
                        continue;
                    }
                    if (hashSet.isEmpty()) {
                        stringBuffer.append(string.substring(n, n3 + 1));
                    }
                    n = n3 + 1;
                    continue;
                }
                if (hashSet.isEmpty()) {
                    stringBuffer.append(string.substring(n));
                    return Union2.createFirst((Object)stringBuffer.toString());
                }
                return Union2.createSecond(hashSet);
            }
            if (hashSet.isEmpty()) {
                stringBuffer.append(string.substring(n, n + 2));
            }
            n += 2;
        }
    }

    public static File resolveFile(File file, String string) throws IllegalArgumentException {
        File file2;
        if (file == null) {
            throw new NullPointerException("null basedir passed to resolveFile");
        }
        if (string == null) {
            throw new NullPointerException("null filename passed to resolveFile");
        }
        if (!file.isAbsolute()) {
            throw new IllegalArgumentException("nonabsolute basedir passed to resolveFile: " + file);
        }
        if (RELATIVE_SLASH_SEPARATED_PATH.matcher(string).matches()) {
            file2 = new File(file, string.replace('/', File.separatorChar));
        } else {
            String string2 = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
            file2 = new File(string2);
            if (!file2.isAbsolute()) {
                file2 = new File(file, string2);
            }
            assert (file2.isAbsolute());
        }
        return FileUtil.normalizeFile((File)file2);
    }

    public static String relativizeFile(File file, File file2) {
        if (file.isFile()) {
            throw new IllegalArgumentException("Cannot relative w.r.t. a data file " + file);
        }
        if (file.equals(file2)) {
            return ".";
        }
        StringBuffer stringBuffer = new StringBuffer();
        File file3 = file;
        String string = file2.getAbsolutePath();
        while (!string.startsWith(PropertyUtils.slashify(file3.getAbsolutePath()))) {
            if ((file3 = file3.getParentFile()) == null) {
                return null;
            }
            if (file3.equals(file2)) {
                stringBuffer.append("..");
                return stringBuffer.toString();
            }
            stringBuffer.append("../");
        }
        URI uRI = file3.toURI().relativize(file2.toURI());
        assert (!uRI.isAbsolute()) : uRI + " from " + file + " and " + file2 + " with common root " + file3;
        stringBuffer.append(uRI.getPath());
        if (stringBuffer.charAt(stringBuffer.length() - 1) == '/') {
            stringBuffer.setLength(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }

    private static String slashify(String string) {
        if (string.endsWith(File.separator)) {
            return string;
        }
        return string + File.separatorChar;
    }

    static FileObject resolveFileObject(FileObject fileObject, String string) {
        return FileUtil.toFileObject((File)PropertyUtils.resolveFile(FileUtil.toFile((FileObject)fileObject), string));
    }

    static String resolvePath(File file, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray = PropertyUtils.tokenizePath(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(File.pathSeparatorChar);
            }
            stringBuffer.append(PropertyUtils.resolveFile(file, stringArray[i]).getAbsolutePath());
        }
        return stringBuffer.toString();
    }

    public static String[] tokenizePath(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":;", true);
        char c = '\u0000';
        int n = 0;
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            char c2;
            String string2 = stringTokenizer.nextToken();
            if (string2.length() == 0) continue;
            if (string2.length() == 1 && ((c2 = string2.charAt(0)) == ':' || c2 == ';')) {
                n = c2;
                ++n2;
                continue;
            }
            if (c != '\u0000') {
                if (n == 58 && n2 == 1 && (string2.charAt(0) == '\\' || string2.charAt(0) == '/')) {
                    string2 = "" + c + ':' + string2;
                } else {
                    arrayList.add(Character.toString(c));
                }
                c = '\u0000';
            }
            n2 = 0;
            if (string2.length() == 1 && ((c2 = string2.charAt(0)) >= 'a' && c2 <= 'z' || c2 >= 'A' && c2 <= 'Z')) {
                c = c2;
                continue;
            }
            arrayList.add(string2);
        }
        if (c != '\u0000') {
            arrayList.add(Character.toString(c));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isUsablePropertyName(String string) {
        return VALID_PROPERTY_NAME.matcher(string).matches();
    }

    public static String getUsablePropertyName(String string) {
        if (PropertyUtils.isUsablePropertyName(string)) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < stringBuffer.length(); ++i) {
            if (PropertyUtils.isUsablePropertyName(stringBuffer.substring(i, i + 1))) continue;
            stringBuffer.replace(i, i + 1, "_");
        }
        return stringBuffer.toString();
    }

    public static PropertyProvider fixedPropertyProvider(Map<String, String> map) {
        return new FixedPropertyProvider(map);
    }

    public static PropertyEvaluator sequentialPropertyEvaluator(PropertyProvider propertyProvider, PropertyProvider ... propertyProviderArray) {
        return new SequentialPropertyEvaluator(propertyProvider, propertyProviderArray);
    }

    public static PropertyProvider userPropertiesProvider(PropertyEvaluator propertyEvaluator, String string, File file) {
        return new UserPropertiesProvider(propertyEvaluator, string, file);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SequentialPropertyEvaluator
    implements PropertyEvaluator,
    ChangeListener {
        private final PropertyProvider preprovider;
        private final PropertyProvider[] providers;
        private Map<String, String> defs;
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        public SequentialPropertyEvaluator(final PropertyProvider propertyProvider, final PropertyProvider[] propertyProviderArray) {
            this.preprovider = propertyProvider;
            this.providers = propertyProviderArray;
            this.defs = (Map)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Map<String, String>>(){

                public Map<String, String> run() {
                    return SequentialPropertyEvaluator.compose(propertyProvider, propertyProviderArray);
                }
            });
            if (propertyProvider != null) {
                propertyProvider.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)propertyProvider));
            }
            for (PropertyProvider propertyProvider2 : propertyProviderArray) {
                propertyProvider2.addChangeListener(WeakListeners.change((ChangeListener)this, (Object)propertyProvider2));
            }
        }

        @Override
        public String getProperty(final String string) {
            return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    if (SequentialPropertyEvaluator.this.defs == null) {
                        return null;
                    }
                    return (String)SequentialPropertyEvaluator.this.defs.get(string);
                }
            });
        }

        @Override
        public String evaluate(final String string) {
            if (string == null) {
                throw new NullPointerException("Attempted to pass null to PropertyEvaluator.evaluate");
            }
            return (String)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<String>(){

                public String run() {
                    if (SequentialPropertyEvaluator.this.defs == null) {
                        return null;
                    }
                    Union2 union2 = PropertyUtils.substitute(string, SequentialPropertyEvaluator.this.defs, Collections.emptySet());
                    assert (union2.hasFirst()) : "Unexpected result " + union2 + " from " + string + " on " + SequentialPropertyEvaluator.access$200(SequentialPropertyEvaluator.this);
                    return (String)union2.first();
                }
            });
        }

        @Override
        public Map<String, String> getProperties() {
            return (Map)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Map<String, String>>(){

                public Map<String, String> run() {
                    return SequentialPropertyEvaluator.this.defs;
                }
            });
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            Map<String, String> map;
            assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
            Map<String, String> map2 = SequentialPropertyEvaluator.compose(this.preprovider, this.providers);
            Map<Object, Object> map3 = this.defs != null ? this.defs : Collections.emptyMap();
            Map<String, String> map4 = map = map2 != null ? map2 : Collections.emptyMap();
            if (!((Object)map3).equals(map)) {
                HashSet<Object> hashSet = new HashSet<Object>(map3.keySet());
                hashSet.addAll(map.keySet());
                LinkedList<PropertyChangeEvent> linkedList = new LinkedList<PropertyChangeEvent>();
                for (String object : hashSet) {
                    assert (object != null);
                    String string = (String)map3.get(object);
                    String string2 = map.get(object);
                    if (string2 != null) {
                        if (string2.equals(string)) {
                            continue;
                        }
                    } else assert (string != null) : "should not have had " + object;
                    linkedList.add(new PropertyChangeEvent(this, object, string, string2));
                }
                assert (!linkedList.isEmpty());
                this.defs = map2;
                for (PropertyChangeEvent propertyChangeEvent : linkedList) {
                    this.pcs.firePropertyChange(propertyChangeEvent);
                }
            }
        }

        private static Map<String, String> compose(PropertyProvider propertyProvider, PropertyProvider[] propertyProviderArray) {
            assert (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess());
            Map<Object, Object> map = propertyProvider != null ? propertyProvider.getProperties() : Collections.emptyMap();
            ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>(propertyProviderArray.length);
            for (PropertyProvider propertyProvider2 : propertyProviderArray) {
                arrayList.add(propertyProvider2.getProperties());
            }
            return PropertyUtils.evaluateAll(map, arrayList);
        }
    }

    private static final class UserPropertiesProvider
    extends FilterPropertyProvider
    implements PropertyChangeListener {
        private final PropertyEvaluator findUserPropertiesFile;
        private final String propertyName;
        private final File basedir;

        public UserPropertiesProvider(PropertyEvaluator propertyEvaluator, String string, File file) {
            super(UserPropertiesProvider.computeDelegate(propertyEvaluator, string, file));
            this.findUserPropertiesFile = propertyEvaluator;
            this.propertyName = string;
            this.basedir = file;
            propertyEvaluator.addPropertyChangeListener(this);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.propertyName.equals(propertyChangeEvent.getPropertyName())) {
                this.setDelegate(UserPropertiesProvider.computeDelegate(this.findUserPropertiesFile, this.propertyName, this.basedir));
            }
        }

        private static PropertyProvider computeDelegate(PropertyEvaluator propertyEvaluator, String string, File file) {
            String string2 = propertyEvaluator.getProperty(string);
            if (string2 != null) {
                File file2 = PropertyUtils.resolveFile(file, string2);
                if (file2.equals(PropertyUtils.userBuildProperties())) {
                    return PropertyUtils.globalPropertyProvider();
                }
                return PropertyUtils.propertiesFilePropertyProvider(file2);
            }
            return PropertyUtils.globalPropertyProvider();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FixedPropertyProvider
    implements PropertyProvider {
        private final Map<String, String> defs;

        public FixedPropertyProvider(Map<String, String> map) {
            this.defs = map;
        }

        @Override
        public Map<String, String> getProperties() {
            return this.defs;
        }

        @Override
        public void addChangeListener(ChangeListener changeListener) {
        }

        @Override
        public void removeChangeListener(ChangeListener changeListener) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class FilePropertyProvider
    implements PropertyProvider,
    FileChangeListener {
        private static final RequestProcessor RP = new RequestProcessor("PropertyUtils.FilePropertyProvider.RP");
        private final File properties;
        private final ChangeSupport cs = new ChangeSupport((Object)this);
        private Map<String, String> cached = null;
        private long cachedTime = 0L;

        public FilePropertyProvider(File file) {
            this.properties = file;
            FileUtil.addFileChangeListener((FileChangeListener)this, (File)file);
        }

        @Override
        public Map<String, String> getProperties() {
            long l = this.properties.lastModified();
            if (this.cached == null || this.cachedTime != l) {
                this.cachedTime = l;
                this.cached = this.loadProperties();
            }
            return this.cached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, String> loadProperties() {
            if (this.properties.isFile() && this.properties.canRead()) {
                Map map;
                FileInputStream fileInputStream = new FileInputStream(this.properties);
                try {
                    Properties properties = new Properties();
                    properties.load(fileInputStream);
                    map = NbCollections.checkedMapByFilter((Map)properties, String.class, String.class, (boolean)true);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        try {
                            Logger.getLogger(PropertyUtils.class.getName()).log(Level.WARNING, "Property file: " + this.properties.getPath(), illegalArgumentException);
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            ((InputStream)fileInputStream).close();
                        }
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(PropertyUtils.class.getName()).log(Level.INFO, null, iOException);
                    }
                }
                ((InputStream)fileInputStream).close();
                return map;
            }
            return Collections.emptyMap();
        }

        private void fireChange() {
            this.cachedTime = -1L;
            if (!this.cs.hasListeners()) {
                return;
            }
            Mutex.Action<Void> action = new Mutex.Action<Void>(){

                public Void run() {
                    FilePropertyProvider.this.cs.fireChange();
                    return null;
                }
            };
            if (ProjectManager.mutex().isWriteAccess()) {
                ProjectManager.mutex().readAccess((Mutex.Action)action);
            } else if (ProjectManager.mutex().isReadAccess()) {
                action.run();
            } else {
                RP.post(new Runnable((Mutex.Action)action){
                    final /* synthetic */ Mutex.Action val$action;
                    {
                        this.val$action = action;
                    }

                    public void run() {
                        ProjectManager.mutex().readAccess(this.val$action);
                    }
                });
            }
        }

        @Override
        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        @Override
        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileChanged(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.fireChange();
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            this.fireChange();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.fireChange();
        }

        public String toString() {
            return "FilePropertyProvider[" + this.properties + ":" + this.getProperties() + "]";
        }
    }
}

