/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support.ant.ui;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.ButtonModel;
import javax.swing.JToggleButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;

public class StoreGroup {
    private Map<String, Object[]> models;
    private Set<Document> modifiedDocuments;
    private static final int BOOLEAN_KIND_TF = 0;
    private static final int BOOLEAN_KIND_YN = 1;
    private static final int BOOLEAN_KIND_ED = 2;
    private DocumentListener documentListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent documentEvent) {
            StoreGroup.this.documentModified(documentEvent.getDocument());
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            StoreGroup.this.documentModified(documentEvent.getDocument());
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            StoreGroup.this.documentModified(documentEvent.getDocument());
        }
    };

    public StoreGroup() {
        this.models = new HashMap<String, Object[]>();
        this.modifiedDocuments = new HashSet<Document>();
    }

    public void store(EditableProperties editableProperties) {
        for (Map.Entry<String, Object[]> entry : this.models.entrySet()) {
            String string;
            Object object;
            String string2 = entry.getKey();
            Object[] objectArray = entry.getValue();
            if (objectArray[0] instanceof ButtonModel) {
                object = (ButtonModel)objectArray[0];
                boolean bl = object.isSelected();
                if (objectArray[2] == Boolean.TRUE) {
                    bl = !bl;
                }
                editableProperties.setProperty(string2, StoreGroup.encodeBoolean(bl, (Integer)objectArray[1]));
                continue;
            }
            if (!(objectArray[0] instanceof Document) || !this.modifiedDocuments.contains(objectArray[0])) continue;
            object = (Document)objectArray[0];
            try {
                string = object.getText(0, object.getLength());
            }
            catch (BadLocationException badLocationException) {
                string = "";
            }
            editableProperties.setProperty(string2, string);
        }
    }

    public final JToggleButton.ToggleButtonModel createToggleButtonModel(PropertyEvaluator propertyEvaluator, String string) {
        return this.createBooleanButtonModel(propertyEvaluator, string, false);
    }

    public final JToggleButton.ToggleButtonModel createInverseToggleButtonModel(PropertyEvaluator propertyEvaluator, String string) {
        return this.createBooleanButtonModel(propertyEvaluator, string, true);
    }

    public final Document createStringDocument(PropertyEvaluator propertyEvaluator, String string) {
        this.checkModelDoesNotExist(string);
        String string2 = propertyEvaluator.getProperty(string);
        if (string2 == null) {
            string2 = "";
        }
        try {
            PlainDocument plainDocument = new PlainDocument();
            plainDocument.remove(0, plainDocument.getLength());
            plainDocument.insertString(0, string2, null);
            plainDocument.addDocumentListener(this.documentListener);
            this.models.put(string, new Object[]{plainDocument});
            return plainDocument;
        }
        catch (BadLocationException badLocationException) {
            assert (false) : "Bad location exception from new document.";
            return new PlainDocument();
        }
    }

    private void checkModelDoesNotExist(String string) {
        if (this.models.get(string) != null) {
            throw new IllegalArgumentException("Model for property " + string + "already exists.");
        }
    }

    private final JToggleButton.ToggleButtonModel createBooleanButtonModel(PropertyEvaluator propertyEvaluator, String string, boolean bl) {
        Object object;
        this.checkModelDoesNotExist(string);
        String string2 = propertyEvaluator.getProperty(string);
        boolean bl2 = false;
        Integer n = 0;
        if (string2 != null) {
            object = string2.toLowerCase();
            if (((String)object).equals("yes") || ((String)object).equals("no")) {
                n = 1;
            } else if (((String)object).equals("on") || ((String)object).equals("off")) {
                n = 2;
            }
            if (((String)object).equals("true") || ((String)object).equals("yes") || ((String)object).equals("on")) {
                bl2 = true;
            }
        }
        object = new JToggleButton.ToggleButtonModel();
        ((JToggleButton.ToggleButtonModel)object).setSelected(bl ? !bl2 : bl2);
        this.models.put(string, new Object[]{object, n, bl});
        return object;
    }

    private static String encodeBoolean(boolean bl, Integer n) {
        if (n == 2) {
            return bl ? "on" : "off";
        }
        if (n == 1) {
            return bl ? "yes" : "no";
        }
        return bl ? "true" : "false";
    }

    private void documentModified(Document document) {
        this.modifiedDocuments.add(document);
    }
}

