/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph.layout;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.widget.Widget;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeGraphLayoutUtility<N, E, P> {
    private final GraphPinScene<N, E, P> scene;
    private final int originX;
    private final int originY;
    private final int verticalGap;
    private final int horizontalGap;
    private final boolean vertical;

    private TreeGraphLayoutUtility(GraphPinScene<N, E, P> graphPinScene, int n, int n2, int n3, int n4, boolean bl) {
        this.scene = graphPinScene;
        this.originX = n;
        this.originY = n2;
        this.verticalGap = n3;
        this.horizontalGap = n4;
        this.vertical = bl;
    }

    public static final <N, E, P> void performLayout(GraphPinScene<N, E, P> graphPinScene) {
        TreeGraphLayoutUtility.performLayout(graphPinScene, 100, 100, 50, 50, true);
    }

    public static final <N, E, P> void performLayout(GraphPinScene<N, E, P> graphPinScene, int n, int n2, int n3, int n4, boolean bl) {
        Object object2;
        Collection collection = graphPinScene.getNodes();
        HashSet hashSet = new HashSet(collection);
        HashMap hashMap = new HashMap();
        for (Object object2 : hashSet) {
            HashSet<Object> hashSet2 = new HashSet<Object>();
            for (Object e : graphPinScene.getEdges()) {
                Object object3;
                Object object4 = graphPinScene.getEdgeSource(e);
                if (graphPinScene.getPinNode(object4).equals(object2)) {
                    hashSet2.add(object2);
                }
                if (!graphPinScene.getPinNode(object3 = graphPinScene.getEdgeTarget(e)).equals(object2)) continue;
                hashSet2.add(object2);
            }
            hashMap.put(object2, hashSet2);
        }
        Iterator iterator = TreeGraphLayoutUtility.findNodeWithMaxEdges(hashSet, hashMap);
        object2 = new TreeGraphLayoutUtility<N, E, P>(graphPinScene, 100, 100, 50, 50, true);
        ((TreeGraphLayoutUtility)object2).layout(iterator);
    }

    public final void layout(N n) {
        if (n == null) {
            return;
        }
        Collection collection = this.scene.getNodes();
        ArrayList arrayList = new ArrayList(collection);
        HashSet hashSet = new HashSet();
        Node node = new Node(n, hashSet);
        arrayList.removeAll(hashSet);
        if (this.vertical) {
            node.allocateHorizontally();
            node.resolveVertically(this.originX, this.originY);
        } else {
            node.allocateVertically();
            node.resolveHorizontally(this.originX, this.originY);
        }
        HashMap hashMap = new HashMap();
        node.upload(hashMap);
        for (Object object : arrayList) {
            Point point = new Point();
            hashMap.put(object, point);
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            this.scene.findWidget(entry.getKey()).setPreferredLocation((Point)entry.getValue());
        }
        this.scene.validate();
    }

    protected Collection<N> resolveChildren(N n) {
        HashSet<N> hashSet = new HashSet<N>();
        Collection collection = this.scene.getEdges();
        for (Object e : collection) {
            Object object = this.scene.getEdgeSource(e);
            if (!this.scene.getPinNode(object).equals(n)) continue;
            hashSet.add(n);
        }
        return hashSet;
    }

    private static <N> N findNodeWithMaxEdges(Set<N> set, Map<N, Collection<N>> map) {
        N n = null;
        int n2 = Integer.MIN_VALUE;
        for (N n3 : set) {
            int n4 = map.get(n3).size();
            if (n4 <= n2) continue;
            n = n3;
            n2 = n4;
        }
        return n;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Node {
        private final N myNode;
        private final List<Node> children;
        private Rectangle relativeBounds;
        private int space;
        private int totalSpace;
        private Point point;

        private Node(N n, Set<N> set) {
            this.myNode = n;
            set.add(n);
            Collection collection = TreeGraphLayoutUtility.this.resolveChildren(n);
            this.children = new ArrayList<Node>();
            for (Object n2 : collection) {
                if (set.contains(n2)) continue;
                this.children.add(new Node(n2, set));
            }
        }

        private int allocateHorizontally() {
            Widget widget = TreeGraphLayoutUtility.this.scene.findWidget(this.myNode);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i > 0) {
                    this.space += TreeGraphLayoutUtility.this.horizontalGap;
                }
                this.space += this.children.get(i).allocateHorizontally();
            }
            this.totalSpace = Math.max(this.space, this.relativeBounds.width);
            return this.totalSpace;
        }

        private void resolveVertically(int n, int n2) {
            int n3 = n;
            int n4 = n2;
            this.point = new Point(n3 + this.totalSpace / 2, n4 - this.relativeBounds.y);
            n3 += (this.totalSpace - this.space) / 2;
            n4 += this.relativeBounds.height + TreeGraphLayoutUtility.this.verticalGap;
            for (Node node : this.children) {
                node.resolveVertically(n3, n4);
                n3 += node.totalSpace + TreeGraphLayoutUtility.this.horizontalGap;
            }
        }

        private int allocateVertically() {
            Widget widget = TreeGraphLayoutUtility.this.scene.findWidget(this.myNode);
            widget.getLayout().layout(widget);
            this.relativeBounds = widget.getPreferredBounds();
            this.space = 0;
            for (int i = 0; i < this.children.size(); ++i) {
                if (i > 0) {
                    this.space += TreeGraphLayoutUtility.this.verticalGap;
                }
                this.space += this.children.get(i).allocateVertically();
            }
            this.totalSpace = Math.max(this.space, this.relativeBounds.height);
            return this.totalSpace;
        }

        private void resolveHorizontally(int n, int n2) {
            int n3 = n;
            int n4 = n2;
            this.point = new Point(n3 - this.relativeBounds.x, n4 + this.totalSpace / 2);
            n3 += this.relativeBounds.width + TreeGraphLayoutUtility.this.horizontalGap;
            n4 += (this.totalSpace - this.space) / 2;
            for (Node node : this.children) {
                node.resolveHorizontally(n3, n4);
                n4 += node.totalSpace + TreeGraphLayoutUtility.this.verticalGap;
            }
        }

        private void upload(Map<N, Point> map) {
            map.put(this.myNode, this.point);
            for (Node node : this.children) {
                node.upload(map);
            }
        }
    }
}

