/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.sun.ide.j2ee.ui;

import java.awt.Component;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.j2ee.sun.ide.j2ee.Utils;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.AddInstanceVisualDirectoryPanel;
import org.netbeans.modules.j2ee.sun.ide.j2ee.ui.Util;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class AddDomainDirectoryPanel
implements WizardDescriptor.FinishablePanel,
ChangeListener {
    private AddInstanceVisualDirectoryPanel component;
    private WizardDescriptor wiz;
    private final boolean creatingPersonalInstance;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    AddDomainDirectoryPanel(boolean bl) {
        this.creatingPersonalInstance = bl;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new AddInstanceVisualDirectoryPanel(this.creatingPersonalInstance);
            this.component.addChangeListener(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        if (this.creatingPersonalInstance) {
            return new HelpCtx("AS_RegServ_EnterPIDir");
        }
        return new HelpCtx("AS_RegServ_EnterDomainDir");
    }

    public boolean isValid() {
        byte[] byArray;
        if (null == this.wiz) {
            return false;
        }
        String string = this.component.getInstanceDirectory().trim();
        if (string.length() < 1) {
            this.setInfoMsg("Msg_EnterSomeDomainDir");
            return false;
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            this.setErrorMsg("Msg_EneterValidDomainDir");
            this.component.setAdminPort("");
            return false;
        }
        if (!this.creatingPersonalInstance) {
            if (string.length() < 1) {
                this.setErrorMsg("Msg_EneterValidDomainDir");
                this.component.setAdminPort("");
                return false;
            }
            String string2 = Util.rootOfUsableDomain(file);
            if (null != string2) {
                this.setErrorMsgLiteral(string2);
                this.component.setAdminPort("");
                return false;
            }
            Util.fillDescriptorFromDomainXml(this.wiz, file);
            String string3 = (String)this.wiz.getProperty("port");
            this.component.setAdminPort(string3);
            if ("".equals(string3)) {
                this.setErrorMsg("Msg_UnsupportedDomain");
                return false;
            }
            return true;
        }
        File file2 = file.getParentFile();
        if (file.exists()) {
            this.setErrorMsg("Msg_ExistingDomainDir", file.getAbsolutePath());
            return false;
        }
        if (null == file2) {
            this.setErrorMsg("Msg_InValidDomainDir", string);
            return false;
        }
        if (!file2.exists() || !Utils.canWrite(file2)) {
            this.setErrorMsg("Msg_InValidDomainDirParent", file2.getAbsolutePath());
            return false;
        }
        String string4 = file.getAbsolutePath();
        byte[] byArray2 = byArray = string4.getBytes();
        try {
            byArray2 = string4.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Logger.getLogger(AddDomainDirectoryPanel.class.getName()).log(Level.FINER, null, unsupportedEncodingException);
        }
        if (byArray.length != byArray2.length) {
            this.setErrorMsg("Msg_Utf8Required");
            return false;
        }
        this.wiz.putProperty("domain", (Object)file.getName());
        this.wiz.putProperty("install_location", (Object)file.getParentFile().getAbsolutePath());
        this.wiz.putProperty("WizardPanel_errorMessage", null);
        this.wiz.putProperty("WizardPanel_infoMessage", null);
        return true;
    }

    private void setErrorMsgLiteral(String string) {
        this.wiz.putProperty("WizardPanel_errorMessage", (Object)string);
    }

    private void setErrorMsg(String string) {
        this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)string));
    }

    private void setErrorMsg(String string, Object object) {
        this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)string, (Object)object));
    }

    private void setInfoMsg(String string) {
        this.wiz.putProperty("WizardPanel_infoMessage", (Object)NbBundle.getMessage(AddDomainDirectoryPanel.class, (String)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    public void readSettings(Object object) {
        this.wiz = (WizardDescriptor)object;
    }

    public void storeSettings(Object object) {
    }

    public void stateChanged(ChangeEvent changeEvent) {
        this.fireChangeEvent();
    }

    public boolean isFinishPanel() {
        return !this.creatingPersonalInstance;
    }
}

