/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.examples;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.Stack;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

public class J2SESampleProjectGenerator {
    private static final String PROJECT_CONFIGURATION_NAMESPACE = "http://www.netbeans.org/ns/j2se-project/3";
    private static final String SOURCE_ENCODING = "source.encoding";
    static final /* synthetic */ boolean $assertionsDisabled;

    private J2SESampleProjectGenerator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileObject createProjectFromTemplate(FileObject fileObject, File file, String string) throws IOException {
        if (!($assertionsDisabled || fileObject != null && file != null && string != null)) {
            throw new AssertionError();
        }
        FileObject fileObject2 = J2SESampleProjectGenerator.createProjectFolder(file);
        if (fileObject.getExt().endsWith("zip")) {
            block17: {
                J2SESampleProjectGenerator.unzip(fileObject.getInputStream(), fileObject2);
                try {
                    Object object;
                    Object object2;
                    File file2 = FileUtil.toFile((FileObject)fileObject2.getFileObject("nbproject/project.xml"));
                    Document document = XMLUtil.parse((InputSource)new InputSource(file2.toURI().toString()), (boolean)false, (boolean)true, null, null);
                    NodeList nodeList = document.getElementsByTagNameNS(PROJECT_CONFIGURATION_NAMESPACE, "name");
                    if (nodeList == null) break block17;
                    for (int i = 0; i < nodeList.getLength(); ++i) {
                        object2 = nodeList.item(i);
                        if (object2.getNodeType() != 1) continue;
                        object = (Element)object2;
                        J2SESampleProjectGenerator.replaceText((Element)object, string);
                    }
                    J2SESampleProjectGenerator.saveXml(document, fileObject2, "nbproject/project.xml");
                    File file3 = J2SESampleProjectGenerator.createPrivateProperties(fileObject2);
                    object2 = new Properties();
                    ((Properties)object2).put("javadoc.preview", "true");
                    ((Properties)object2).put("compile.on.save", "true");
                    object = new FileOutputStream(file3);
                    try {
                        ((Properties)object2).store((OutputStream)object, null);
                    }
                    finally {
                        ((OutputStream)object).close();
                    }
                    FileObject fileObject3 = fileObject2.getFileObject("nbproject/project.properties");
                    if (fileObject3 == null) break block17;
                    FileLock fileLock = fileObject3.lock();
                    try {
                        EditableProperties editableProperties = new EditableProperties();
                        InputStream inputStream = fileObject3.getInputStream();
                        try {
                            editableProperties.load(inputStream);
                        }
                        finally {
                            inputStream.close();
                        }
                        editableProperties.put(SOURCE_ENCODING, "UTF-8");
                        object = fileObject3.getOutputStream(fileLock);
                        try {
                            editableProperties.store((OutputStream)object);
                        }
                        finally {
                            ((OutputStream)object).close();
                        }
                    }
                    finally {
                        fileLock.releaseLock();
                    }
                }
                catch (Exception exception) {
                    throw new IOException(exception.toString());
                }
            }
            fileObject2.refresh(false);
        }
        return fileObject2;
    }

    private static FileObject createProjectFolder(File file) throws IOException {
        FileObject fileObject;
        Stack<String> stack = new Stack<String>();
        while ((fileObject = FileUtil.toFileObject((File)file)) == null) {
            stack.push(file.getName());
            file = file.getParentFile();
        }
        while (!stack.empty()) {
            fileObject = fileObject.createFolder((String)stack.pop());
            if (!$assertionsDisabled && fileObject == null) {
                throw new AssertionError();
            }
        }
        return fileObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unzip(InputStream inputStream, FileObject fileObject) throws IOException {
        ZipInputStream zipInputStream = new ZipInputStream(inputStream);
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) {
                    FileUtil.createFolder((FileObject)fileObject, (String)zipEntry.getName());
                    continue;
                }
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)zipEntry.getName());
                FileLock fileLock = fileObject2.lock();
                try {
                    OutputStream outputStream = fileObject2.getOutputStream(fileLock);
                    try {
                        FileUtil.copy((InputStream)zipInputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                finally {
                    fileLock.releaseLock();
                }
            }
        }
        finally {
            zipInputStream.close();
        }
    }

    private static File createPrivateProperties(FileObject fileObject) throws IOException {
        String[] stringArray = "nbproject/private/private.properties".split("/");
        for (int i = 0; i < stringArray.length - 1; ++i) {
            FileObject fileObject2 = fileObject.getFileObject(stringArray[i]);
            if (fileObject2 == null) {
                fileObject2 = fileObject.createFolder(stringArray[i]);
            }
            fileObject = fileObject2;
        }
        fileObject = fileObject.createData(stringArray[stringArray.length - 1]);
        return FileUtil.toFile((FileObject)fileObject);
    }

    private static void replaceText(Element element, String string) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            text.setNodeValue(string);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveXml(Document document, FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        FileLock fileLock = fileObject2.lock();
        try {
            OutputStream outputStream = fileObject2.getOutputStream(fileLock);
            try {
                XMLUtil.write((Document)document, (OutputStream)outputStream, (String)"UTF-8");
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    static {
        $assertionsDisabled = !J2SESampleProjectGenerator.class.desiredAssertionStatus();
    }
}

