/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl;

import java.util.Collections;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.impl.SourceAccessor;
import org.netbeans.modules.parsing.impl.SourceCache;
import org.netbeans.modules.parsing.impl.TaskProcessor;
import org.netbeans.modules.parsing.impl.event.EventSupport;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.SchedulerTask;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static volatile IndexingStatus status;

    private Utilities() {
    }

    public static void acquireParserLock() {
        TaskProcessor.acquireParserLock();
    }

    public static void releaseParserLock() {
        TaskProcessor.releaseParserLock();
    }

    public static boolean holdsParserLock() {
        return TaskProcessor.holdsParserLock();
    }

    public static void scheduleSpecialTask(SchedulerTask schedulerTask) {
        TaskProcessor.scheduleSpecialTask(schedulerTask);
    }

    public static void setIndexingStatus(IndexingStatus indexingStatus) {
        assert (indexingStatus != null);
        assert (status == null);
        status = indexingStatus;
    }

    public static boolean isScanInProgress() {
        if (status == null) {
            return RepositoryUpdater.getDefault().isScanInProgress();
        }
        return status.isScanInProgress();
    }

    public static void revalidate(Source source) {
        EventSupport eventSupport = SourceAccessor.getINSTANCE().getEventSupport(source);
        assert (eventSupport != null);
        eventSupport.resetState(true, -1, -1);
    }

    public static void addParserResultTask(ParserResultTask<?> parserResultTask, Source source) {
        assert (parserResultTask != null);
        assert (source != null);
        SourceCache sourceCache = SourceAccessor.getINSTANCE().getCache(source);
        TaskProcessor.addPhaseCompletionTasks(Collections.singleton(parserResultTask), sourceCache, true, null);
    }

    public static void removeParserResultTask(ParserResultTask<?> parserResultTask, Source source) {
        assert (parserResultTask != null);
        assert (source != null);
        TaskProcessor.removePhaseCompletionTasks(Collections.singleton(parserResultTask), source);
    }

    public static void rescheduleTask(ParserResultTask<?> parserResultTask, Source source) {
        assert (parserResultTask != null);
        assert (source != null);
        TaskProcessor.rescheduleTasks(Collections.singleton(parserResultTask), source, null);
    }

    public static interface IndexingStatus {
        public boolean isScanInProgress();
    }
}

