/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;

public class CacheFolder {
    private static final String NB_USER_DIR = "netbeans.user";
    private static final String INDEX_DIR = "var" + File.separatorChar + "cache" + File.separatorChar + "index";
    private static final String SEGMENTS_FILE = "segments";
    private static final String SLICE_PREFIX = "s";
    private static FileObject cacheFolder;
    private static Properties segments;
    private static Map<String, String> invertedSegments;
    private static int index;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadSegments() throws IOException {
        if (segments == null) {
            FileObject fileObject = CacheFolder.getCacheFolder();
            assert (fileObject != null);
            segments = new Properties();
            invertedSegments = new HashMap<String, String>();
            FileObject fileObject2 = fileObject.getFileObject(SEGMENTS_FILE);
            if (fileObject2 != null) {
                InputStream inputStream = fileObject2.getInputStream();
                try {
                    segments.load(inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            for (Map.Entry entry : segments.entrySet()) {
                String string = (String)entry.getKey();
                String string2 = (String)entry.getValue();
                invertedSegments.put(string2, string);
                try {
                    index = Math.max(index, Integer.parseInt(string.substring(SLICE_PREFIX.length())));
                }
                catch (NumberFormatException numberFormatException) {
                    Exceptions.printStackTrace((Throwable)numberFormatException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeSegments() throws IOException {
        FileObject fileObject = CacheFolder.getCacheFolder();
        assert (fileObject != null);
        FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)SEGMENTS_FILE);
        OutputStream outputStream = fileObject2.getOutputStream();
        try {
            segments.store(outputStream, null);
        }
        finally {
            outputStream.close();
        }
    }

    public static synchronized URL getSourceRootForDataFolder(FileObject fileObject) {
        FileObject fileObject2 = fileObject.getParent();
        if (fileObject2 == null || !fileObject2.equals(cacheFolder)) {
            return null;
        }
        String string = segments.getProperty(fileObject.getName());
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return null;
    }

    public static synchronized FileObject getDataFolder(URL uRL) throws IOException {
        return CacheFolder.getDataFolder(uRL, false);
    }

    public static synchronized FileObject getDataFolder(URL uRL, boolean bl) throws IOException {
        CacheFolder.loadSegments();
        String string = uRL.toExternalForm();
        String string2 = invertedSegments.get(string);
        if (string2 == null) {
            if (bl) {
                return null;
            }
            string2 = SLICE_PREFIX + ++index;
            while (segments.getProperty(string2) != null) {
                string2 = SLICE_PREFIX + ++index;
            }
            segments.put(string2, string);
            invertedSegments.put(string, string2);
            CacheFolder.storeSegments();
        }
        FileObject fileObject = CacheFolder.getCacheFolder();
        if (bl) {
            return fileObject.getFileObject(string2);
        }
        return FileUtil.createFolder((FileObject)fileObject, (String)string2);
    }

    private static String getNbUserDir() {
        String string = System.getProperty(NB_USER_DIR);
        return string;
    }

    public static synchronized FileObject getCacheFolder() {
        if (cacheFolder == null) {
            String string = CacheFolder.getNbUserDir();
            assert (string != null);
            File file = new File(string);
            File file2 = FileUtil.normalizeFile((File)new File(file, INDEX_DIR));
            if (!file2.exists()) {
                boolean bl = file2.mkdirs();
                assert (bl) : "Cannot create cache folder";
            } else assert (file2.isDirectory() && file2.canRead() && file2.canWrite());
            cacheFolder = FileUtil.toFileObject((File)file2);
            assert (cacheFolder != null);
        }
        return cacheFolder;
    }

    public static synchronized void setCacheFolder(FileObject fileObject) {
        assert (fileObject != null && fileObject.canRead() && fileObject.canWrite());
        cacheFolder = fileObject;
        segments = null;
        invertedSegments = null;
        index = 0;
    }

    static {
        index = 0;
    }
}

