/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing;

import java.net.URL;
import org.netbeans.modules.parsing.impl.indexing.IndexableImpl;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.util.Parameters;

public final class FileObjectIndexable
implements IndexableImpl {
    private final FileObject root;
    private final String relativePath;
    private final String mimeType;
    private Object url;

    public FileObjectIndexable(FileObject fileObject, FileObject fileObject2) {
        this(fileObject, FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2), fileObject2.getMIMEType());
    }

    public FileObjectIndexable(FileObject fileObject, String string, String string2) {
        Parameters.notNull((CharSequence)"root", (Object)fileObject);
        Parameters.notNull((CharSequence)"relativePath", (Object)string);
        Parameters.notNull((CharSequence)"mimeType", (Object)string2);
        this.root = fileObject;
        this.relativePath = string;
        this.mimeType = string2;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public URL getURL() {
        if (this.url == null) {
            try {
                FileObject fileObject = this.root.getFileObject(this.relativePath);
                this.url = fileObject.getURL();
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                this.url = fileStateInvalidException;
            }
        }
        return this.url instanceof URL ? (URL)this.url : null;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        FileObjectIndexable fileObjectIndexable = (FileObjectIndexable)object;
        if (!(this.root == fileObjectIndexable.root || this.root != null && this.root.equals(fileObjectIndexable.root))) {
            return false;
        }
        return this.relativePath == fileObjectIndexable.relativePath || this.relativePath != null && this.relativePath.equals(fileObjectIndexable.relativePath);
    }

    public int hashCode() {
        int n = 7;
        n = 83 * n + (this.root != null ? this.root.hashCode() : 0);
        n = 83 * n + (this.relativePath != null ? this.relativePath.hashCode() : 0);
        return n;
    }

    public String toString() {
        return "FileObjectIndexable@" + Integer.toHexString(System.identityHashCode(this)) + " [" + FileObjectIndexable.toURL(this.root) + "/" + this.getRelativePath() + "]";
    }

    private static String toURL(FileObject fileObject) {
        try {
            return fileObject.getURL().toString();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return fileObject.getPath();
        }
    }
}

