/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.impl.indexing.lucene;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LMListener {
    private static MemoryPoolMXBean cachedPool;
    private MemoryPoolMXBean pool;
    private static final float DEFAULT_HEAP_LIMIT = 0.7f;
    private final float heapLimit;

    public LMListener() {
        this(0.7f);
    }

    public LMListener(float f) {
        this.heapLimit = f;
        this.pool = LMListener.findPool();
        assert (this.pool != null);
    }

    public float getHeapLimit() {
        return this.heapLimit;
    }

    public boolean isLowMemory() {
        MemoryUsage memoryUsage;
        if (this.pool != null && (memoryUsage = this.pool.getUsage()) != null) {
            long l;
            long l2 = memoryUsage.getUsed();
            return (float)l2 > (float)(l = memoryUsage.getMax()) * this.heapLimit;
        }
        return false;
    }

    private static synchronized MemoryPoolMXBean findPool() {
        if (cachedPool == null || !cachedPool.isValid()) {
            List<MemoryPoolMXBean> list = ManagementFactory.getMemoryPoolMXBeans();
            for (MemoryPoolMXBean memoryPoolMXBean : list) {
                if (memoryPoolMXBean.getType() != MemoryType.HEAP || !memoryPoolMXBean.isUsageThresholdSupported()) continue;
                cachedPool = memoryPoolMXBean;
                break;
            }
            assert (cachedPool != null) : LMListener.dumpMemoryPoolMXBean(list);
        }
        return cachedPool;
    }

    private static String dumpMemoryPoolMXBean(List<MemoryPoolMXBean> list) {
        StringBuilder stringBuilder = new StringBuilder();
        for (MemoryPoolMXBean memoryPoolMXBean : list) {
            stringBuilder.append(String.format("Pool: %s Type: %s TresholdSupported: %s\n", new Object[]{memoryPoolMXBean.getName(), memoryPoolMXBean.getType(), memoryPoolMXBean.isUsageThresholdSupported() ? Boolean.TRUE : Boolean.FALSE}));
        }
        stringBuilder.append('\n');
        return stringBuilder.toString();
    }
}

