/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.parsing.spi.indexing;

import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.parsing.impl.indexing.CancelRequest;
import org.netbeans.modules.parsing.impl.indexing.IndexFactoryImpl;
import org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Context {
    private final URL rootURL;
    private final FileObject indexBaseFolder;
    private final FileObject indexFolder;
    private final String indexerName;
    private final int indexerVersion;
    private final boolean followUpJob;
    private final boolean checkForEditorModifications;
    private final boolean allFilesJob;
    private final CancelRequest cancelRequest;
    private FileObject root;
    private IndexingSupport indexingSupport;
    final IndexFactoryImpl factory;

    Context(FileObject fileObject, URL uRL, String string, int n, IndexFactoryImpl indexFactoryImpl, boolean bl, boolean bl2, boolean bl3, CancelRequest cancelRequest) throws IOException {
        assert (fileObject != null);
        assert (uRL != null);
        assert (string != null);
        this.indexBaseFolder = fileObject;
        this.rootURL = uRL;
        this.indexerName = string;
        this.indexerVersion = n;
        this.factory = indexFactoryImpl;
        this.followUpJob = bl;
        String string2 = Context.getIndexerPath(string, n);
        this.indexFolder = FileUtil.createFolder((FileObject)this.indexBaseFolder, (String)string2);
        this.checkForEditorModifications = bl2;
        this.allFilesJob = bl3;
        this.cancelRequest = cancelRequest;
    }

    public FileObject getIndexFolder() {
        return this.indexFolder;
    }

    public URL getRootURI() {
        return this.rootURL;
    }

    public FileObject getRoot() {
        if (this.root == null) {
            this.root = URLMapper.findFileObject((URL)this.rootURL);
        }
        return this.root;
    }

    public void addSupplementaryFiles(URL uRL, Collection<? extends URL> collection) {
        Logger logger = Logger.getLogger(RepositoryUpdater.class.getName());
        if (logger.isLoggable(Level.FINE)) {
            logger.fine("addSupplementaryFiles: root=" + uRL + ", files=" + collection);
        }
        RepositoryUpdater.getDefault().addIndexingJob(uRL, collection, true, false, false, true);
    }

    public boolean isSupplementaryFilesIndexing() {
        return this.followUpJob;
    }

    public boolean isAllFilesIndexing() {
        return this.allFilesJob;
    }

    public boolean checkForEditorModifications() {
        return this.checkForEditorModifications;
    }

    public boolean isCancelled() {
        return this.cancelRequest == null ? false : this.cancelRequest.isRaised();
    }

    String getIndexerName() {
        return this.indexerName;
    }

    int getIndexerVersion() {
        return this.indexerVersion;
    }

    void attachIndexingSupport(IndexingSupport indexingSupport) {
        assert (this.indexingSupport == null);
        this.indexingSupport = indexingSupport;
    }

    IndexingSupport getAttachedIndexingSupport() {
        return this.indexingSupport;
    }

    static String getIndexerPath(String string, int n) {
        return string + "/" + n;
    }
}

