/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.ws.wadl2java;

import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.research.ws.wadl2java.Wadl2Java;
import com.sun.research.ws.wadl2java.Wadl2JavaMessages;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.bind.JAXBException;

public class Main {
    protected static void printUsage() {
        System.err.println(Wadl2JavaMessages.USAGE());
    }

    public static void main(String[] args) {
        if (args.length % 2 != 1) {
            Main.printUsage();
            System.exit(1);
        }
        try {
            File outputDir = null;
            String pkg = null;
            for (int i = 0; i < args.length - 2; i += 2) {
                if (args[i].equals("-o")) {
                    outputDir = new File(args[i + 1]);
                    continue;
                }
                if (args[i].equals("-p")) {
                    pkg = args[i + 1];
                    continue;
                }
                System.err.println(Wadl2JavaMessages.UNKNOWN_OPTION(args[i]));
                Main.printUsage();
                System.exit(1);
            }
            URI wadlDesc = new URI(args[args.length - 1]);
            if (wadlDesc.getScheme() == null || wadlDesc.getScheme().equals("file")) {
                File wadlFile = new File(wadlDesc.getPath());
                if (!wadlFile.exists() || !wadlFile.isFile()) {
                    System.err.println(Wadl2JavaMessages.NOT_A_FILE(wadlFile.getPath()));
                    Main.printUsage();
                    System.exit(1);
                }
                if (!outputDir.exists() || !outputDir.isDirectory()) {
                    System.err.println(Wadl2JavaMessages.NOT_A_DIRECTORY(outputDir.getPath()));
                    Main.printUsage();
                    System.exit(1);
                }
                wadlDesc = wadlFile.toURI();
            }
            Wadl2Java w = new Wadl2Java(outputDir, pkg);
            w.process(wadlDesc);
        }
        catch (URISyntaxException ex) {
            ex.printStackTrace();
        }
        catch (JAXBException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        catch (JClassAlreadyExistsException ex) {
            ex.printStackTrace();
        }
    }
}

