/*
 * Decompiled with CFR 0.152.
 */
package com.sun.research.ws.wadl2java;

import com.sun.codemodel.JAssignmentTarget;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JClassAlreadyExistsException;
import com.sun.codemodel.JCodeModel;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JFieldRef;
import com.sun.codemodel.JFieldVar;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JPackage;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.research.ws.wadl.Param;
import com.sun.research.ws.wadl.util.DSDispatcher;
import com.sun.research.ws.wadl.util.JAXBDispatcher;
import com.sun.research.ws.wadl2java.GeneratorUtil;
import com.sun.research.ws.wadl2java.JavaDocUtil;
import com.sun.research.ws.wadl2java.Wadl2JavaMessages;
import com.sun.research.ws.wadl2java.ast.FaultNode;
import com.sun.research.ws.wadl2java.ast.MethodNode;
import com.sun.research.ws.wadl2java.ast.PathSegment;
import com.sun.research.ws.wadl2java.ast.RepresentationNode;
import com.sun.research.ws.wadl2java.ast.ResourceNode;
import com.sun.research.ws.wadl2java.ast.ResourceTypeNode;
import com.sun.tools.xjc.api.Mapping;
import com.sun.tools.xjc.api.S2JJAXBModel;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceClassGenerator {
    private ResourceNode resource;
    private JPackage pkg;
    private S2JJAXBModel s2jModel;
    private JCodeModel codeModel;
    private JFieldVar $jaxbDispatcher;
    private JFieldVar $dsDispatcher;
    private JDefinedClass $class = null;
    private JavaDocUtil javaDoc;

    public ResourceClassGenerator(S2JJAXBModel s2jModel, JCodeModel codeModel, JPackage pkg, JavaDocUtil javaDoc, ResourceNode resource) {
        this.resource = resource;
        this.codeModel = codeModel;
        this.javaDoc = javaDoc;
        this.s2jModel = s2jModel;
        this.pkg = pkg;
    }

    public ResourceClassGenerator(S2JJAXBModel s2jModel, JCodeModel codeModel, JPackage pkg, JavaDocUtil javaDoc, JDefinedClass clazz) {
        this.resource = null;
        this.codeModel = codeModel;
        this.javaDoc = javaDoc;
        this.s2jModel = s2jModel;
        this.pkg = pkg;
        this.$class = clazz;
    }

    public JDefinedClass getGeneratedClass() {
        return this.$class;
    }

    public JDefinedClass generateClass(JDefinedClass parentClass) throws JClassAlreadyExistsException {
        JDefinedClass $impl = parentClass._class(17, this.resource.getClassName());
        for (ResourceTypeNode t : this.resource.getResourceTypes()) {
            $impl._implements((JClass)t.getGeneratedInterface());
        }
        this.javaDoc.generateClassDoc(this.resource, $impl);
        this.$jaxbDispatcher = $impl.field(4, JAXBDispatcher.class, "jaxbDispatcher");
        this.$dsDispatcher = $impl.field(4, DSDispatcher.class, "dsDispatcher");
        JMethod $ctor = $impl.constructor(1);
        for (PathSegment segment : this.resource.getPathSegments()) {
            for (Param p : segment.getTemplateParameters()) {
                $ctor.param((JType)GeneratorUtil.getJavaType(p, this.codeModel, $impl, this.javaDoc), p.getName());
            }
            for (Param p : segment.getMatrixParameters()) {
                $ctor.param((JType)GeneratorUtil.getJavaType(p, this.codeModel, $impl, this.javaDoc), p.getName());
            }
        }
        $ctor._throws(JAXBException.class);
        JBlock $ctorBody = $ctor.body();
        JInvocation jcInit = this.codeModel.ref(JAXBContext.class).staticInvoke("newInstance");
        jcInit.arg(JExpr.lit((String)this.pkg.name()));
        JVar $jc = $ctorBody.decl((JType)this.codeModel.ref(JAXBContext.class), "jc", (JExpression)jcInit);
        JClass arrayListOfString = this.codeModel.ref(ArrayList.class).narrow(String.class);
        JClass listOfString = this.codeModel.ref(List.class).narrow(String.class);
        JClass arrayListOfListOfString = this.codeModel.ref(ArrayList.class).narrow(listOfString);
        JClass listOfListOfString = this.codeModel.ref(List.class).narrow(listOfString);
        JVar $pathSegmentList = $ctorBody.decl((JType)listOfString, "pathSegments", (JExpression)JExpr._new((JClass)arrayListOfString));
        JVar $matrixParamList = $ctorBody.decl((JType)listOfListOfString, "matrixParameters", (JExpression)JExpr._new((JClass)arrayListOfListOfString));
        JVar $matrixParamSet = $ctorBody.decl((JType)listOfString, "matrixParamSet");
        for (PathSegment segment : this.resource.getPathSegments()) {
            $ctorBody.invoke((JExpression)$pathSegmentList, "add").arg(JExpr.lit((String)segment.getTemplate()));
            $ctorBody.assign((JAssignmentTarget)$matrixParamSet, (JExpression)JExpr._new((JClass)arrayListOfString));
            for (Param p : segment.getMatrixParameters()) {
                $ctorBody.invoke((JExpression)$matrixParamSet, "add").arg(JExpr.lit((String)p.getName()));
            }
            $ctorBody.invoke((JExpression)$matrixParamList, "add").arg((JExpression)$matrixParamSet);
        }
        JClass mapOfStringObject = this.codeModel.ref(HashMap.class).narrow(new Class[]{String.class, Object.class});
        JVar $paramValMap = $ctorBody.decl((JType)mapOfStringObject, "parameterValues", (JExpression)JExpr._new((JClass)mapOfStringObject));
        for (PathSegment segment : this.resource.getPathSegments()) {
            for (Param p : segment.getTemplateParameters()) {
                $ctorBody.invoke((JExpression)$paramValMap, "put").arg(JExpr.lit((String)p.getName())).arg((JExpression)JExpr.ref((String)p.getName()));
            }
            for (Param p : segment.getMatrixParameters()) {
                $ctorBody.invoke((JExpression)$paramValMap, "put").arg(JExpr.lit((String)p.getName())).arg((JExpression)JExpr.ref((String)p.getName()));
            }
        }
        $ctorBody.assign((JAssignmentTarget)this.$jaxbDispatcher, (JExpression)JExpr._new((JClass)this.codeModel.ref(JAXBDispatcher.class)).arg((JExpression)$jc).arg((JExpression)$pathSegmentList).arg((JExpression)$matrixParamList).arg((JExpression)$paramValMap));
        $ctorBody.assign((JAssignmentTarget)this.$dsDispatcher, (JExpression)JExpr._new((JClass)this.codeModel.ref(DSDispatcher.class)).arg((JExpression)$pathSegmentList).arg((JExpression)$matrixParamList).arg((JExpression)$paramValMap));
        $ctor = $impl.constructor(1);
        JVar $uri = $ctor.param(URI.class, "uri");
        $ctor._throws(JAXBException.class);
        $ctorBody = $ctor.body();
        jcInit = this.codeModel.ref(JAXBContext.class).staticInvoke("newInstance");
        jcInit.arg(JExpr.lit((String)this.pkg.name()));
        $jc = $ctorBody.decl((JType)this.codeModel.ref(JAXBContext.class), "jc", (JExpression)jcInit);
        $ctorBody.assign((JAssignmentTarget)this.$jaxbDispatcher, (JExpression)JExpr._new((JClass)this.codeModel.ref(JAXBDispatcher.class)).arg((JExpression)$jc).arg((JExpression)$uri));
        $ctorBody.assign((JAssignmentTarget)this.$dsDispatcher, (JExpression)JExpr._new((JClass)this.codeModel.ref(DSDispatcher.class)).arg((JExpression)$uri));
        this.$class = $impl;
        return this.$class;
    }

    protected JDefinedClass generateExceptionClass(FaultNode f) {
        JDefinedClass $exCls = null;
        String exName = f.getClassName();
        try {
            $exCls = this.pkg._class(1, exName);
            $exCls._extends(Exception.class);
            Mapping m = this.s2jModel.get(f.getElement());
            if (m == null) {
                System.err.println(Wadl2JavaMessages.ELEMENT_NOT_FOUND(f.getElement().toString()));
            }
            JType detailType = m == null ? this.codeModel._ref(Object.class) : m.getType().getTypeClass();
            JFieldVar $detailField = $exCls.field(4, detailType, "m_faultInfo");
            JMethod $ctor = $exCls.constructor(1);
            JVar $msg = $ctor.param(String.class, "message");
            JVar $detail = $ctor.param(detailType, "faultInfo");
            JBlock $ctorBody = $ctor.body();
            $ctorBody.directStatement("super(message);");
            $ctorBody.assign((JAssignmentTarget)$detailField, (JExpression)$detail);
            JMethod $faultInfoGetter = $exCls.method(1, detailType, "getFaultInfo");
            $faultInfoGetter.body()._return((JExpression)$detailField);
        }
        catch (JClassAlreadyExistsException ex) {
            $exCls = ex.getExistingClass();
        }
        return $exCls;
    }

    protected void generateMethodDecls(MethodNode method, boolean isAbstract) {
        List<RepresentationNode> supportedInputs = method.getSupportedInputs();
        List<RepresentationNode> supportedOutputs = method.getSupportedOutputs();
        HashMap<JType, JDefinedClass> exceptionMap = new HashMap<JType, JDefinedClass>();
        for (FaultNode f : method.getFaults()) {
            if (f.getElement() == null) {
                System.err.println(Wadl2JavaMessages.FAULT_NO_ELEMENT());
                continue;
            }
            JDefinedClass generatedException = this.generateExceptionClass(f);
            Mapping m = this.s2jModel.get(f.getElement());
            if (m == null) {
                System.err.println(Wadl2JavaMessages.ELEMENT_NOT_FOUND(f.getElement().toString()));
            }
            JType faultType = m == null ? this.codeModel._ref(Object.class) : m.getType().getTypeClass();
            exceptionMap.put(faultType, generatedException);
        }
        if (supportedInputs.size() == 0) {
            for (RepresentationNode returnType : supportedOutputs) {
                this.generateMethodVariants(exceptionMap, method, false, null, returnType, isAbstract);
                if (!method.hasOptionalParameters()) continue;
                this.generateMethodVariants(exceptionMap, method, true, null, returnType, isAbstract);
            }
        } else {
            for (RepresentationNode inputType : supportedInputs) {
                for (RepresentationNode returnType : supportedOutputs) {
                    this.generateMethodVariants(exceptionMap, method, false, inputType, returnType, isAbstract);
                    if (!method.hasOptionalParameters()) continue;
                    this.generateMethodVariants(exceptionMap, method, true, inputType, returnType, isAbstract);
                }
            }
        }
    }

    protected JType getTypeFromElement(QName element) {
        JType type = null;
        if (element == null) {
            return this.codeModel._ref(DataSource.class);
        }
        Mapping m = this.s2jModel.get(element);
        if (m == null) {
            System.err.println(Wadl2JavaMessages.ELEMENT_NOT_FOUND(element.toString()));
        }
        type = m == null ? this.codeModel._ref(Object.class) : m.getType().getTypeClass();
        return type;
    }

    protected void generateMethodVariants(Map<JType, JDefinedClass> exceptionMap, MethodNode method, boolean includeOptionalParams, RepresentationNode inputRep, RepresentationNode outputRep, boolean isAbstract) {
        this.generateDSMethodDecl(exceptionMap, method, includeOptionalParams, inputRep, outputRep, isAbstract);
        this.generateJAXBMethodDecl(exceptionMap, method, includeOptionalParams, inputRep, outputRep, isAbstract);
    }

    protected void generateJAXBMethodDecl(Map<JType, JDefinedClass> exceptionMap, MethodNode method, boolean includeOptionalParams, RepresentationNode inputRep, RepresentationNode outputRep, boolean isAbstract) {
        if (outputRep != null && outputRep.getElement() == null || inputRep != null && inputRep.getElement() == null) {
            return;
        }
        JType inputType = null;
        Object returnType = null;
        if (inputRep != null) {
            inputType = this.getTypeFromElement(inputRep.getElement());
        }
        returnType = outputRep != null ? this.getTypeFromElement(outputRep.getElement()) : this.codeModel.VOID;
        String returnTypeSuffix = outputRep.getElement() == null ? outputRep.getMediaTypeAsClassName() : returnType.name();
        String methodName = method.getName().toLowerCase() + "As" + returnTypeSuffix;
        JMethod $genMethod = this.$class.method(1, (JType)returnType, methodName);
        this.javaDoc.generateMethodDoc(method, $genMethod);
        if (outputRep != null) {
            this.javaDoc.generateReturnDoc(outputRep, $genMethod);
        }
        for (JDefinedClass $ex : exceptionMap.values()) {
            $genMethod._throws((JClass)$ex);
        }
        if (inputType != null) {
            $genMethod.param(inputType, "input");
            this.javaDoc.generateParamDoc(inputRep, $genMethod);
        }
        List<Param> params = includeOptionalParams ? method.getQueryParameters() : method.getRequiredParameters();
        for (Param q : params) {
            if (q.getFixed() != null) continue;
            JClass javaType = GeneratorUtil.getJavaType(q, this.codeModel, this.$class, this.javaDoc);
            String paramName = q.getName().equals("input") ? "queryInput" : q.getName();
            q.setName(paramName);
            this.javaDoc.generateParamDoc(q, $genMethod);
            if (q.isRepeating()) {
                $genMethod.param((JType)this.codeModel.ref(List.class).narrow(javaType), q.getName());
                continue;
            }
            $genMethod.param((JType)javaType, q.getName());
        }
        if (!isAbstract) {
            JBlock $methodBody = $genMethod.body();
            JClass mapOfString = this.codeModel.ref(HashMap.class).narrow(new Class[]{String.class, Object.class});
            JVar $paramMap = $methodBody.decl((JType)mapOfString, "parameterMap", (JExpression)JExpr._new((JClass)mapOfString));
            for (Param q : params) {
                if (!includeOptionalParams && !q.isRequired() && q.getFixed() == null) continue;
                JFieldRef $paramArg = JExpr.ref((String)q.getName());
                if (q.isRequired() && q.getFixed() == null) {
                    JBlock $throwBlock = $methodBody._if($paramArg.eq(JExpr._null()))._then();
                    $throwBlock._throw((JExpression)JExpr._new((JClass)this.codeModel.ref(IllegalArgumentException.class)).arg(JExpr.lit((String)Wadl2JavaMessages.PARAMETER_REQUIRED(q.getName(), methodName))));
                }
                JInvocation addParamToMap = $methodBody.invoke((JExpression)$paramMap, "put");
                if (q.getFixed() != null) {
                    addParamToMap.arg(JExpr.lit((String)q.getName())).arg(JExpr.lit((String)q.getFixed()));
                    continue;
                }
                addParamToMap.arg(JExpr.lit((String)q.getName())).arg((JExpression)$paramArg);
            }
            this.generateJAXBDBody(method, exceptionMap, outputRep, (JType)returnType, $paramMap, inputRep, $methodBody);
        }
    }

    protected void generateDSMethodDecl(Map<JType, JDefinedClass> exceptionMap, MethodNode method, boolean includeOptionalParams, RepresentationNode inputRep, RepresentationNode outputRep, boolean isAbstract) {
        JType inputType = null;
        Object returnType = null;
        if (inputRep != null) {
            inputType = this.getTypeFromElement(null);
        }
        returnType = outputRep != null ? this.getTypeFromElement(null) : this.codeModel.VOID;
        String returnTypeSuffix = outputRep.getMediaTypeAsClassName();
        String methodName = method.getName().toLowerCase() + "As" + returnTypeSuffix;
        JMethod $genMethod = this.$class.method(1, returnType, methodName);
        this.javaDoc.generateMethodDoc(method, $genMethod);
        if (outputRep != null) {
            this.javaDoc.generateReturnDoc(outputRep, $genMethod);
        }
        if (inputType != null) {
            $genMethod.param(inputType, "input");
            this.javaDoc.generateParamDoc(inputRep, $genMethod);
        }
        List<Param> params = includeOptionalParams ? method.getQueryParameters() : method.getRequiredParameters();
        for (Param q : params) {
            if (q.getFixed() != null) continue;
            JClass javaType = GeneratorUtil.getJavaType(q, this.codeModel, this.$class, this.javaDoc);
            String paramName = q.getName().equals("input") ? "queryInput" : q.getName();
            q.setName(paramName);
            this.javaDoc.generateParamDoc(q, $genMethod);
            if (q.isRepeating()) {
                $genMethod.param((JType)this.codeModel.ref(List.class).narrow(javaType), q.getName());
                continue;
            }
            $genMethod.param((JType)javaType, q.getName());
        }
        if (!isAbstract) {
            JBlock $methodBody = $genMethod.body();
            JClass mapOfString = this.codeModel.ref(HashMap.class).narrow(new Class[]{String.class, Object.class});
            JVar $paramMap = $methodBody.decl((JType)mapOfString, "parameterMap", (JExpression)JExpr._new((JClass)mapOfString));
            for (Param q : params) {
                if (!includeOptionalParams && !q.isRequired() && q.getFixed() == null) continue;
                JFieldRef $paramArg = JExpr.ref((String)q.getName());
                if (q.isRequired() && q.getFixed() == null) {
                    JBlock $throwBlock = $methodBody._if($paramArg.eq(JExpr._null()))._then();
                    $throwBlock._throw((JExpression)JExpr._new((JClass)this.codeModel.ref(IllegalArgumentException.class)).arg(JExpr.lit((String)Wadl2JavaMessages.PARAMETER_REQUIRED(q.getName(), methodName))));
                }
                JInvocation addParamToMap = $methodBody.invoke((JExpression)$paramMap, "put");
                if (q.getFixed() != null) {
                    addParamToMap.arg(JExpr.lit((String)q.getName())).arg(JExpr.lit((String)q.getFixed()));
                    continue;
                }
                addParamToMap.arg(JExpr.lit((String)q.getName())).arg((JExpression)$paramArg);
            }
            this.generateDSDBody(method, outputRep, (JType)returnType, $paramMap, inputRep, $methodBody);
        }
    }

    protected void generateJAXBDBody(MethodNode method, Map<JType, JDefinedClass> exceptionMap, RepresentationNode outputRep, JType returnType, JVar $paramMap, RepresentationNode inputRep, JBlock $methodBody) {
        JInvocation $executeMethod = this.$jaxbDispatcher.invoke("do" + method.getName());
        if (method.getName().equals("POST") || method.getName().equals("PUT")) {
            $executeMethod.arg((JExpression)JExpr.ref((String)"input"));
            $executeMethod.arg(JExpr.lit((String)inputRep.getMediaType()));
        }
        $executeMethod.arg((JExpression)$paramMap);
        $executeMethod.arg(JExpr.lit((String)outputRep.getMediaType()));
        JVar $retVal = $methodBody.decl((JType)this.codeModel.ref(Object.class), "retVal", (JExpression)$executeMethod);
        for (JType faultType : exceptionMap.keySet()) {
            JDefinedClass matchingException = exceptionMap.get(faultType);
            JBlock $throwBlock = $methodBody._if((JExpression)JExpr.invoke((JExpression)JExpr.dotclass((JClass)faultType.boxify()), (String)"isInstance").arg((JExpression)$retVal))._then();
            $throwBlock._throw((JExpression)JExpr._new((JClass)matchingException).arg(JExpr.lit((String)Wadl2JavaMessages.INVOCATION_FAILED())).arg((JExpression)JExpr.cast((JType)faultType, (JExpression)$retVal)));
        }
        $methodBody._return((JExpression)JExpr.cast((JType)returnType, (JExpression)$retVal));
    }

    protected void generateDSDBody(MethodNode method, RepresentationNode outputRep, JType returnType, JVar $paramMap, RepresentationNode inputRep, JBlock $methodBody) {
        JInvocation $executeMethod = this.$dsDispatcher.invoke("do" + method.getName());
        if (method.getName().equals("POST") || method.getName().equals("PUT")) {
            $executeMethod.arg((JExpression)JExpr.ref((String)"input"));
            $executeMethod.arg(JExpr.lit((String)inputRep.getMediaType()));
        }
        $executeMethod.arg((JExpression)$paramMap);
        $executeMethod.arg(JExpr.lit((String)outputRep.getMediaType()));
        JVar $retVal = $methodBody.decl((JType)this.codeModel.ref(DataSource.class), "retVal", (JExpression)$executeMethod);
        $methodBody._return((JExpression)$retVal);
    }
}

