/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.AbstractListModel;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.packet.MUCUser;
import org.netbeans.modules.kenai.collab.chat.Buddy;

public class BuddyListModel
extends AbstractListModel
implements PacketListener {
    private final ArrayList<Buddy> usrs = new ArrayList();

    public BuddyListModel(MultiUserChat multiUserChat) {
        Iterator iterator = multiUserChat.getOccupants();
        while (iterator.hasNext()) {
            this.usrs.add(new Buddy(multiUserChat.getOccupant((String)iterator.next()).getJid()));
        }
        Collections.sort(this.usrs);
    }

    public BuddyListModel(Roster roster) {
        for (RosterEntry rosterEntry : roster.getEntries()) {
            this.usrs.add(new Buddy(rosterEntry.getName()));
        }
        Collections.sort(this.usrs);
    }

    public int getSize() {
        return this.usrs.size();
    }

    public Object getElementAt(int n) {
        return this.usrs.get(n);
    }

    public void processPacket(Packet packet) {
        Presence presence = (Presence)packet;
        Buddy buddy = new Buddy(presence.getFrom());
        if (!this.usrs.contains(buddy) && presence.getType().equals((Object)Presence.Type.available)) {
            this.usrs.add(new Buddy(((MUCUser)presence.getExtension("http://jabber.org/protocol/muc#user")).getItem().getJid()));
            Collections.sort(this.usrs);
        }
        if (presence.getType().equals((Object)Presence.Type.unavailable)) {
            this.usrs.remove(buddy);
        }
        this.fireContentsChanged(this, 0, this.usrs.size());
    }
}

