/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.collab.chat;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.util.StringUtils;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.netbeans.modules.kenai.api.Kenai;
import org.netbeans.modules.kenai.api.KenaiException;
import org.netbeans.modules.kenai.collab.chat.ChatNotifications;
import org.netbeans.modules.kenai.collab.chat.ChatTopComponent;
import org.netbeans.modules.kenai.collab.chat.KenaiConnection;
import org.netbeans.modules.kenai.ui.spi.UIUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class PresenceIndicator {
    private static ImageIcon ONLINE = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/collab/resources/online.png"));
    private static ImageIcon OFFLINE = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/kenai/collab/resources/offline.png"));
    private static PresenceIndicator instance;
    private JLabel label;
    private MouseL helper;
    private Status status = Status.OFFLINE;
    private static RequestProcessor presenceUpdater;

    public void setStatus(Status status) {
        this.status = status;
        this.label.setIcon(status == Status.ONLINE ? ONLINE : OFFLINE);
        if (status == Status.OFFLINE) {
            this.label.setText("");
            this.label.setToolTipText(NbBundle.getMessage(PresenceIndicator.class, (String)"LBL_Offline"));
        }
    }

    Component getComponent() {
        return this.label;
    }

    public static synchronized PresenceIndicator getDefault() {
        if (instance == null) {
            instance = new PresenceIndicator();
            KenaiConnection.getDefault();
        }
        return instance;
    }

    private PresenceIndicator() {
        this.label = new JLabel(OFFLINE, 0);
        this.label.setToolTipText(NbBundle.getMessage(PresenceIndicator.class, (String)"LBL_Offline"));
        this.helper = new MouseL();
        this.label.addMouseListener(this.helper);
    }

    void showPopup() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
                int n = toolTipManager.getInitialDelay();
                toolTipManager.setInitialDelay(0);
                toolTipManager.mouseMoved(new MouseEvent(PresenceIndicator.this.label, 0, 0L, 0, 0, 0, 0, false));
                toolTipManager.setInitialDelay(n);
            }
        });
    }

    static {
        presenceUpdater = new RequestProcessor();
    }

    public class PresenceListener
    implements PacketListener {
        private RequestProcessor.Task task;

        public PresenceListener() {
            this.task = presenceUpdater.create(new Runnable(){

                private String getDisplayName(MultiUserChat multiUserChat) {
                    String string = StringUtils.parseName((String)multiUserChat.getRoom());
                    try {
                        String string2 = Kenai.getDefault().getProject(string).getDisplayName();
                        return string2;
                    }
                    catch (KenaiException kenaiException) {
                        return string;
                    }
                }

                public void run() {
                    HashSet<String> hashSet = new HashSet<String>();
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append("<html><body>");
                    List<MultiUserChat> list = KenaiConnection.getDefault().getChats();
                    Collections.sort(list, new Comparator(){

                        public int compare(Object object, Object object2) {
                            return this.getDisplayName((MultiUserChat)object).compareTo(this.getDisplayName((MultiUserChat)object2));
                        }
                    });
                    for (MultiUserChat multiUserChat : list) {
                        String string = StringUtils.parseName((String)multiUserChat.getRoom());
                        stringBuffer.append("<font color=gray>" + this.getDisplayName(multiUserChat) + "</font><br>");
                        Iterator iterator = multiUserChat.getOccupants();
                        ArrayList<Object> arrayList = new ArrayList<Object>();
                        ChatNotifications.getDefault().getMessagingHandle(string).setOnlineCount(multiUserChat.getOccupantsCount());
                        while (iterator.hasNext()) {
                            String string2 = StringUtils.parseResource((String)((String)iterator.next()));
                            arrayList.add(string2);
                        }
                        Collections.sort(arrayList);
                        for (String string3 : arrayList) {
                            hashSet.add(string3);
                            stringBuffer.append("&nbsp;&nbsp;" + string3 + "<br>");
                        }
                    }
                    stringBuffer.append("</body></html>");
                    if (hashSet.size() == 0) {
                        PresenceIndicator.this.setStatus(Status.OFFLINE);
                    } else {
                        PresenceIndicator.this.label.setToolTipText(stringBuffer.toString());
                        PresenceIndicator.this.label.setText(String.valueOf(hashSet.size()));
                    }
                }
            });
        }

        public void processPacket(Packet packet) {
            this.task.schedule(100);
        }
    }

    private class MouseL
    extends MouseAdapter {
        private MouseL() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                if (PresenceIndicator.this.status == Status.ONLINE) {
                    ChatTopComponent.openAction((TopComponent)ChatTopComponent.findInstance(), (String)"", (String)"", (boolean)false).actionPerformed(new ActionEvent(mouseEvent, mouseEvent.getID(), ""));
                } else {
                    UIUtils.showLogin();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        ONLINE,
        OFFLINE;

    }
}

