/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.resolver;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.CyclicDependencyException;
import org.apache.maven.artifact.resolver.ResolutionNode;
import org.apache.maven.artifact.versioning.OverConstrainedVersionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactResolutionResult {
    private Artifact originatingArtifact;
    private List<Exception> versionRangeViolations;
    private List<ArtifactResolutionException> metadataResolutionExceptions;
    private List<Artifact> missingArtifacts;
    private List<CyclicDependencyException> circularDependencyExceptions;
    private List<ArtifactResolutionException> errorArtifactExceptions;
    private List<ArtifactRepository> repositories;
    private Set<ResolutionNode> resolutionNodes;
    private Set<Artifact> artifacts;

    public Artifact getOriginatingArtifact() {
        return this.originatingArtifact;
    }

    public ArtifactResolutionResult ListOriginatingArtifact(Artifact originatingArtifact) {
        this.originatingArtifact = originatingArtifact;
        return this;
    }

    public Set<Artifact> getArtifacts() {
        if (this.artifacts == null) {
            this.artifacts = new LinkedHashSet<Artifact>();
            for (ResolutionNode node : this.resolutionNodes) {
                this.artifacts.add(node.getArtifact());
            }
        }
        return this.artifacts;
    }

    public Set<ResolutionNode> getArtifactResolutionNodes() {
        if (this.resolutionNodes == null) {
            return Collections.emptySet();
        }
        return this.resolutionNodes;
    }

    public ArtifactResolutionResult setArtifactResolutionNodes(Set<ResolutionNode> resolutionNodes) {
        this.resolutionNodes = resolutionNodes;
        this.artifacts = null;
        return this;
    }

    public List getMissingArtifacts() {
        return this.missingArtifacts == null ? Collections.EMPTY_LIST : this.missingArtifacts;
    }

    public ArtifactResolutionResult addMissingArtifact(Artifact artifact) {
        this.missingArtifacts = this.initList(this.missingArtifacts);
        this.missingArtifacts.add(artifact);
        return this;
    }

    public ArtifactResolutionResult setUnresolvedArtifacts(List<Artifact> unresolvedArtifacts) {
        this.missingArtifacts = unresolvedArtifacts;
        return this;
    }

    public boolean hasVersionRangeViolations() {
        return this.versionRangeViolations != null;
    }

    public ArtifactResolutionResult addVersionRangeViolation(Exception e) {
        this.versionRangeViolations = this.initList(this.versionRangeViolations);
        this.versionRangeViolations.add(e);
        return this;
    }

    public OverConstrainedVersionException getVersionRangeViolation(int i) {
        return (OverConstrainedVersionException)this.versionRangeViolations.get(i);
    }

    public List getVersionRangeViolations() {
        return this.versionRangeViolations == null ? Collections.EMPTY_LIST : this.versionRangeViolations;
    }

    public boolean hasMetadataResolutionExceptions() {
        return this.metadataResolutionExceptions != null;
    }

    public ArtifactResolutionResult addMetadataResolutionException(ArtifactResolutionException e) {
        this.metadataResolutionExceptions = this.initList(this.metadataResolutionExceptions);
        this.metadataResolutionExceptions.add(e);
        return this;
    }

    public ArtifactResolutionException getMetadataResolutionException(int i) {
        return this.metadataResolutionExceptions.get(i);
    }

    public List getMetadataResolutionExceptions() {
        return this.metadataResolutionExceptions == null ? Collections.EMPTY_LIST : this.metadataResolutionExceptions;
    }

    public boolean hasErrorArtifactExceptions() {
        return this.errorArtifactExceptions != null;
    }

    public ArtifactResolutionResult addErrorArtifactException(ArtifactResolutionException e) {
        this.errorArtifactExceptions = this.initList(this.errorArtifactExceptions);
        this.errorArtifactExceptions.add(e);
        return this;
    }

    public List<ArtifactResolutionException> getErrorArtifactExceptions() {
        if (this.errorArtifactExceptions == null) {
            return Collections.emptyList();
        }
        return this.errorArtifactExceptions;
    }

    public boolean hasCircularDependencyExceptions() {
        return this.circularDependencyExceptions != null;
    }

    public ArtifactResolutionResult addCircularDependencyException(CyclicDependencyException e) {
        this.circularDependencyExceptions = this.initList(this.circularDependencyExceptions);
        this.circularDependencyExceptions.add(e);
        return this;
    }

    public CyclicDependencyException getCircularDependencyException(int i) {
        return this.circularDependencyExceptions.get(i);
    }

    public List<CyclicDependencyException> getCircularDependencyExceptions() {
        if (this.circularDependencyExceptions == null) {
            return Collections.emptyList();
        }
        return this.circularDependencyExceptions;
    }

    public List<ArtifactRepository> getRepositories() {
        if (this.repositories == null) {
            return Collections.emptyList();
        }
        return this.repositories;
    }

    public ArtifactResolutionResult setRepositories(List<ArtifactRepository> repositories) {
        this.repositories = repositories;
        return this;
    }

    private <T> List<T> initList(List<T> l) {
        if (l == null) {
            return new ArrayList();
        }
        return l;
    }
}

