/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.plan;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.maven.lifecycle.LifecycleLoaderException;
import org.apache.maven.lifecycle.LifecycleSpecificationException;
import org.apache.maven.lifecycle.LifecycleUtils;
import org.apache.maven.lifecycle.MojoBindingUtils;
import org.apache.maven.lifecycle.NoSuchPhaseException;
import org.apache.maven.lifecycle.model.LifecycleBinding;
import org.apache.maven.lifecycle.model.LifecycleBindings;
import org.apache.maven.lifecycle.model.MojoBinding;
import org.apache.maven.lifecycle.statemgmt.StateManagementUtils;

public class BuildPlan {
    private LifecycleBindings bindings;
    private final List tasks;
    private final Map forkedDirectInvocations;
    private final Map forkedPhases;
    private List renderedLifecycleMojos = new ArrayList();
    private final Map directInvocationBindings;
    private Set fullyResolvedBindings = new HashSet();
    private boolean includingReports = false;
    private Set unbindableMojos;

    public BuildPlan(LifecycleBindings packaging, LifecycleBindings projectBindings, LifecycleBindings defaults, Set unbindableMojos, List tasks) throws LifecycleSpecificationException, LifecycleLoaderException {
        this(LifecycleUtils.mergeBindings(packaging, projectBindings, defaults, true, false), unbindableMojos, tasks);
    }

    public BuildPlan(LifecycleBindings bindings, Set unbindableMojos, List tasks) throws LifecycleSpecificationException, LifecycleLoaderException {
        this.bindings = bindings;
        this.unbindableMojos = unbindableMojos == null ? null : new HashSet(unbindableMojos);
        this.tasks = tasks;
        this.forkedDirectInvocations = new HashMap();
        this.forkedPhases = new HashMap();
        this.directInvocationBindings = new HashMap();
    }

    private BuildPlan(LifecycleBindings bindings, Map forkedDirectInvocations, Map forkedPhases, Map directInvocationBindings, Set fullyResolvedMojoBindings, Set unbindableMojos, List tasks, boolean includingReports) {
        this.unbindableMojos = unbindableMojos == null ? null : new HashSet(unbindableMojos);
        this.bindings = LifecycleUtils.cloneBindings(bindings);
        this.forkedDirectInvocations = new HashMap(forkedDirectInvocations);
        this.forkedPhases = new HashMap(forkedPhases);
        this.fullyResolvedBindings = new HashSet(fullyResolvedMojoBindings);
        this.tasks = tasks;
        this.includingReports = includingReports;
        this.directInvocationBindings = new HashMap(directInvocationBindings);
    }

    public void markAsIncludingReports() {
        this.includingReports = true;
    }

    public boolean isIncludingReports() {
        return this.includingReports;
    }

    public boolean hasUnbindableMojos() {
        return this.unbindableMojos != null && !this.unbindableMojos.isEmpty();
    }

    public Set getUnbindableMojos() {
        return this.unbindableMojos;
    }

    public void clearUnbindableMojos() {
        this.unbindableMojos = null;
    }

    public void addUnbindableMojo(MojoBinding binding) {
        this.unbindableMojos.add(binding);
    }

    public boolean isFullyResolved(MojoBinding mojoBinding) {
        String key = MojoBindingUtils.createMojoBindingKey(mojoBinding, false);
        return this.fullyResolvedBindings.contains(key);
    }

    public void markFullyResolved() throws NoSuchPhaseException {
        List bindings = this.renderExecutionPlan(new Stack());
        for (MojoBinding mojoBinding : bindings) {
            String key = MojoBindingUtils.createMojoBindingKey(mojoBinding, false);
            this.fullyResolvedBindings.add(key);
        }
    }

    public void addLifecycleOverlay(LifecycleBindings overlay) {
        this.bindings = LifecycleUtils.mergeBindings(overlay, this.bindings, null, true, true);
    }

    public void addTask(String task, MojoBinding binding) throws LifecycleSpecificationException, LifecycleLoaderException {
        this.tasks.add(task);
        if (!LifecycleUtils.isValidPhaseName(task)) {
            this.addDirectInvocationBinding(task, binding);
        }
    }

    public LifecycleBindings getLifecycleBindings() {
        return this.bindings;
    }

    public List getTasks() {
        return this.tasks;
    }

    public void addDirectInvocationBinding(String key, MojoBinding binding) {
        this.directInvocationBindings.put(MojoBindingUtils.createMojoBindingKey(binding, false), binding);
        this.directInvocationBindings.put(key, binding);
    }

    public Map getDirectInvocationBindings() {
        return this.directInvocationBindings;
    }

    public Map getForkedDirectInvocations() {
        return this.forkedDirectInvocations;
    }

    public Map getForkedPhases() {
        return this.forkedPhases;
    }

    public void addForkedExecution(MojoBinding mojoBinding, BuildPlan plan) {
        String key = MojoBindingUtils.createMojoBindingKey(mojoBinding, false);
        this.forkedPhases.put(key, plan);
    }

    public void addForkedExecution(MojoBinding mojoBinding, List forkedInvocations) {
        String key = MojoBindingUtils.createMojoBindingKey(mojoBinding, false);
        ArrayList invoke = (ArrayList)this.forkedDirectInvocations.get(key);
        if (invoke == null) {
            invoke = new ArrayList();
            this.forkedDirectInvocations.put(key, invoke);
        }
        invoke.addAll(forkedInvocations);
    }

    public BuildPlan copy(String task) {
        return this.copy(Collections.singletonList(task));
    }

    public BuildPlan copy(List newTasks) {
        return new BuildPlan(this.bindings, this.forkedDirectInvocations, this.forkedPhases, this.directInvocationBindings, this.fullyResolvedBindings, this.unbindableMojos, newTasks, this.includingReports);
    }

    public void resetExecutionProgress() {
        this.renderedLifecycleMojos = new ArrayList();
        for (BuildPlan plan : this.forkedPhases.values()) {
            plan.resetExecutionProgress();
        }
    }

    public List renderExecutionPlan(Stack executionStack) throws NoSuchPhaseException {
        LifecycleUtils.setupTrackingInfo(this.bindings);
        ArrayList plan = new ArrayList();
        for (String task : this.tasks) {
            if (LifecycleUtils.isValidPhaseName(task)) {
                LifecycleBinding binding = LifecycleUtils.findLifecycleBindingForPhase(task, this.bindings);
                List bindingsToAdd = LifecycleUtils.getMojoBindingListForLifecycle(task, binding);
                ArrayList newRendered = new ArrayList(bindingsToAdd);
                if (this.renderedLifecycleMojos != null && this.renderedLifecycleMojos.size() < bindingsToAdd.size() && bindingsToAdd.containsAll(this.renderedLifecycleMojos)) {
                    bindingsToAdd = bindingsToAdd.subList(this.renderedLifecycleMojos.size(), bindingsToAdd.size());
                }
                this.renderedLifecycleMojos = newRendered;
                for (MojoBinding mojoBinding : bindingsToAdd) {
                    String key = MojoBindingUtils.createMojoBindingKey(mojoBinding, false);
                    if (executionStack.contains(key)) continue;
                    plan.addAll(this.findForkedBindings(mojoBinding, executionStack));
                }
                continue;
            }
            MojoBinding mojoBinding = (MojoBinding)this.directInvocationBindings.get(task);
            String key = MojoBindingUtils.createMojoBindingKey(mojoBinding, false);
            if (executionStack.contains(key)) continue;
            plan.addAll(this.findForkedBindings(mojoBinding, executionStack));
        }
        return plan;
    }

    private List findForkedBindings(MojoBinding mojoBinding, Stack executionStack) throws NoSuchPhaseException {
        ArrayList<MojoBinding> bindings = new ArrayList<MojoBinding>();
        String key = MojoBindingUtils.createMojoBindingKey(mojoBinding, false);
        executionStack.push(key);
        try {
            List directInvocations;
            List forkedBindings = new ArrayList();
            BuildPlan forkedPlan = (BuildPlan)this.forkedPhases.get(key);
            if (forkedPlan != null) {
                forkedBindings = forkedPlan.renderExecutionPlan(executionStack);
            }
            if ((directInvocations = (List)this.forkedDirectInvocations.get(key)) != null) {
                for (MojoBinding invocation : directInvocations) {
                    String invocationKey = MojoBindingUtils.createMojoBindingKey(invocation, false);
                    if (executionStack.contains(invocationKey)) continue;
                    forkedBindings.addAll(this.findForkedBindings(invocation, executionStack));
                }
            }
            if (!forkedBindings.isEmpty()) {
                bindings.add(StateManagementUtils.createStartForkedExecutionMojoBinding());
                bindings.addAll(forkedBindings);
                bindings.add(StateManagementUtils.createEndForkedExecutionMojoBinding());
            }
            bindings.add(mojoBinding);
            if (!forkedBindings.isEmpty()) {
                bindings.add(StateManagementUtils.createClearForkedExecutionMojoBinding());
            }
        }
        finally {
            executionStack.pop();
        }
        return bindings;
    }

    public void removeAll(List mojoBindings) throws NoSuchPhaseException {
        LifecycleUtils.removeMojoBindings(mojoBindings, this.bindings, false);
    }
}

