/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.build.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.model.Model;
import org.apache.maven.project.build.model.ModelLineage;
import org.apache.maven.project.build.model.ModelLineageIterator;

public class DefaultModelLineage
implements ModelLineage {
    private List tuples = new ArrayList();

    public void addParent(Model model, File pomFile, List artifactRepositories, boolean validProfilesXmlLocation) {
        if (this.tuples.isEmpty()) {
            throw new IllegalStateException("You must call setOrigin(..) before adding a parent to the lineage.");
        }
        this.tuples.add(new ModelLineageTuple(model, pomFile, artifactRepositories, validProfilesXmlLocation));
    }

    public Iterator artifactRepositoryListIterator() {
        return new Iterator(){
            private int idx = 0;

            public boolean hasNext() {
                return DefaultModelLineage.this.tuples.size() > this.idx;
            }

            public Object next() {
                return ((ModelLineageTuple)DefaultModelLineage.this.tuples.get(this.idx++)).remoteRepositories;
            }

            public void remove() {
                DefaultModelLineage.this.tuples.remove(this.idx);
            }
        };
    }

    public Iterator fileIterator() {
        return new Iterator(){
            private int idx = 0;

            public boolean hasNext() {
                return DefaultModelLineage.this.tuples.size() > this.idx;
            }

            public Object next() {
                return ((ModelLineageTuple)DefaultModelLineage.this.tuples.get(this.idx++)).file;
            }

            public void remove() {
                DefaultModelLineage.this.tuples.remove(this.idx);
            }
        };
    }

    public List getArtifactRepositories(Model model) {
        int index = this.tuples.indexOf(new ModelLineageTuple(model));
        ModelLineageTuple tuple = (ModelLineageTuple)this.tuples.get(index);
        return tuple != null ? tuple.remoteRepositories : null;
    }

    public List getArtifactRepositoryListsInDescendingOrder() {
        if (this.tuples.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList tuplesInReverse = new ArrayList(this.tuples);
        Collections.reverse(tuplesInReverse);
        ArrayList<List> results = new ArrayList<List>(tuplesInReverse.size());
        for (ModelLineageTuple tuple : tuplesInReverse) {
            results.add(tuple.remoteRepositories);
        }
        return results;
    }

    public File getFile(Model model) {
        int index = this.tuples.indexOf(new ModelLineageTuple(model));
        ModelLineageTuple tuple = (ModelLineageTuple)this.tuples.get(index);
        return tuple != null ? tuple.file : null;
    }

    public List getFilesInDescendingOrder() {
        if (this.tuples.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList tuplesInReverse = new ArrayList(this.tuples);
        Collections.reverse(tuplesInReverse);
        ArrayList<File> results = new ArrayList<File>(tuplesInReverse.size());
        for (ModelLineageTuple tuple : tuplesInReverse) {
            results.add(tuple.file);
        }
        return results;
    }

    public List getModelsInDescendingOrder() {
        if (this.tuples.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList tuplesInReverse = new ArrayList(this.tuples);
        Collections.reverse(tuplesInReverse);
        ArrayList<Model> results = new ArrayList<Model>(tuplesInReverse.size());
        for (ModelLineageTuple tuple : tuplesInReverse) {
            results.add(tuple.model);
        }
        return results;
    }

    public List getOriginatingArtifactRepositoryList() {
        if (this.tuples.isEmpty()) {
            return null;
        }
        ModelLineageTuple tuple = (ModelLineageTuple)this.tuples.get(0);
        return tuple.remoteRepositories;
    }

    public Model getOriginatingModel() {
        if (this.tuples.isEmpty()) {
            return null;
        }
        ModelLineageTuple tuple = (ModelLineageTuple)this.tuples.get(0);
        return tuple.model;
    }

    public File getOriginatingPOMFile() {
        if (this.tuples.isEmpty()) {
            return null;
        }
        ModelLineageTuple tuple = (ModelLineageTuple)this.tuples.get(0);
        return tuple.file;
    }

    public List getDeepestAncestorArtifactRepositoryList() {
        if (this.tuples.isEmpty()) {
            return null;
        }
        ModelLineageTuple tuple = (ModelLineageTuple)this.tuples.get(this.tuples.size() - 1);
        return tuple.remoteRepositories;
    }

    public File getDeepestAncestorFile() {
        if (this.tuples.isEmpty()) {
            return null;
        }
        ModelLineageTuple tuple = (ModelLineageTuple)this.tuples.get(this.tuples.size() - 1);
        return tuple.file;
    }

    public Model getDeepestAncestorModel() {
        if (this.tuples.isEmpty()) {
            return null;
        }
        ModelLineageTuple tuple = (ModelLineageTuple)this.tuples.get(this.tuples.size() - 1);
        return tuple.model;
    }

    public boolean isDeepestAncestorUsingProfilesXml() {
        if (this.tuples.isEmpty()) {
            return false;
        }
        ModelLineageTuple tuple = (ModelLineageTuple)this.tuples.get(this.tuples.size() - 1);
        return tuple.validProfilesXmlLocation;
    }

    public Iterator modelIterator() {
        return new Iterator(){
            private int idx = 0;

            public boolean hasNext() {
                return DefaultModelLineage.this.tuples.size() > this.idx;
            }

            public Object next() {
                return ((ModelLineageTuple)DefaultModelLineage.this.tuples.get(this.idx++)).model;
            }

            public void remove() {
                DefaultModelLineage.this.tuples.remove(this.idx);
            }
        };
    }

    public void setOrigin(Model model, File pomFile, List artifactRepositories, boolean validProfilesXmlLocation) {
        if (!this.tuples.isEmpty()) {
            throw new IllegalStateException("Origin already set; you must use addParent(..) for successive additions to the lineage.");
        }
        this.tuples.add(new ModelLineageTuple(model, pomFile, artifactRepositories, validProfilesXmlLocation));
    }

    public int size() {
        return this.tuples.size();
    }

    public ModelLineageIterator lineageIterator() {
        return new ModelLineageIterator(){
            private int idx = -1;

            public boolean hasNext() {
                return DefaultModelLineage.this.tuples.size() > this.idx + 1;
            }

            public Object next() {
                return ((ModelLineageTuple)DefaultModelLineage.this.tuples.get(++this.idx)).model;
            }

            public void remove() {
                DefaultModelLineage.this.tuples.remove(this.idx);
            }

            public List getArtifactRepositories() {
                return ((ModelLineageTuple)DefaultModelLineage.this.tuples.get(this.idx)).remoteRepositories;
            }

            public Model getModel() {
                return ((ModelLineageTuple)DefaultModelLineage.this.tuples.get(this.idx)).model;
            }

            public File getPOMFile() {
                return ((ModelLineageTuple)DefaultModelLineage.this.tuples.get(this.idx)).file;
            }
        };
    }

    public ModelLineageIterator reversedLineageIterator() {
        return new ModelLineageIterator(){
            private int idx;
            {
                this.idx = DefaultModelLineage.this.tuples.size();
            }

            public boolean hasNext() {
                return this.idx > 0;
            }

            public Object next() {
                return ((ModelLineageTuple)DefaultModelLineage.this.tuples.get(--this.idx)).model;
            }

            public void remove() {
                DefaultModelLineage.this.tuples.remove(this.idx);
            }

            public List getArtifactRepositories() {
                return ((ModelLineageTuple)DefaultModelLineage.this.tuples.get(this.idx)).remoteRepositories;
            }

            public Model getModel() {
                return ((ModelLineageTuple)DefaultModelLineage.this.tuples.get(this.idx)).model;
            }

            public File getPOMFile() {
                return ((ModelLineageTuple)DefaultModelLineage.this.tuples.get(this.idx)).file;
            }
        };
    }

    private static final class ModelLineageTuple {
        private Model model;
        private File file;
        private List remoteRepositories;
        private final boolean validProfilesXmlLocation;

        ModelLineageTuple(Model model) {
            this.model = model;
            this.validProfilesXmlLocation = false;
        }

        ModelLineageTuple(Model model, File file, List remoteRepositories, boolean validProfilesXmlLocation) {
            this.model = model;
            this.file = file;
            this.remoteRepositories = remoteRepositories;
            this.validProfilesXmlLocation = validProfilesXmlLocation;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof ModelLineageTuple) {
                ModelLineageTuple otherTuple = (ModelLineageTuple)other;
                return this.model.getId().equals(otherTuple.model.getId());
            }
            return false;
        }
    }
}

