/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.interpolation;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.project.interpolation.ModelInterpolationException;
import org.apache.maven.project.interpolation.ModelInterpolator;
import org.apache.maven.project.interpolation.PathTranslatingValueSource;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.interpolation.InterpolationException;
import org.codehaus.plexus.interpolation.MapBasedValueSource;
import org.codehaus.plexus.interpolation.ObjectBasedValueSource;
import org.codehaus.plexus.interpolation.PrefixAwareRecursionInterceptor;
import org.codehaus.plexus.interpolation.PrefixedObjectValueSource;
import org.codehaus.plexus.interpolation.PrefixedValueSourceWrapper;
import org.codehaus.plexus.interpolation.RegexBasedInterpolator;
import org.codehaus.plexus.interpolation.ValueSource;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class RegexBasedModelInterpolator
extends AbstractLogEnabled
implements ModelInterpolator {
    private static final Pattern EXPRESSION_PATTERN = Pattern.compile("\\$\\{([^}]+)\\}");
    private static final List PROJECT_PREFIXES = Arrays.asList("pom.", "project.");
    private static final List TRANSLATED_PATH_EXPRESSIONS;
    private PathTranslator pathTranslator;

    static {
        ArrayList<String> translatedPrefixes = new ArrayList<String>();
        translatedPrefixes.add("build.directory");
        translatedPrefixes.add("build.outputDirectory");
        translatedPrefixes.add("build.testOutputDirectory");
        translatedPrefixes.add("build.sourceDirectory");
        translatedPrefixes.add("build.testSourceDirectory");
        TRANSLATED_PATH_EXPRESSIONS = translatedPrefixes;
    }

    public Model interpolate(Model model, Map context) throws ModelInterpolationException {
        return this.interpolate(model, context, Collections.EMPTY_MAP, null, true);
    }

    public Model interpolate(Model model, Map context, boolean strict) throws ModelInterpolationException {
        return this.interpolate(model, context, Collections.EMPTY_MAP, null, true);
    }

    public Model interpolate(Model model, Map context, Map overrideContext, boolean strict) throws ModelInterpolationException {
        return this.interpolate(model, context, Collections.EMPTY_MAP, null, true);
    }

    public Model interpolate(Model model, Map context, Map overrideContext, File projectDir, boolean outputDebugMessages) throws ModelInterpolationException {
        StringWriter sWriter = new StringWriter();
        MavenXpp3Writer writer = new MavenXpp3Writer();
        try {
            writer.write(sWriter, model);
        }
        catch (IOException e) {
            throw new ModelInterpolationException("Cannot serialize project model for interpolation.", e);
        }
        String serializedModel = sWriter.toString();
        serializedModel = this.interpolateInternal(serializedModel, model, context, overrideContext, projectDir, outputDebugMessages);
        StringReader sReader = new StringReader(serializedModel);
        MavenXpp3Reader modelReader = new MavenXpp3Reader();
        try {
            model = modelReader.read(sReader);
        }
        catch (IOException e) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e);
        }
        catch (XmlPullParserException e) {
            throw new ModelInterpolationException("Cannot read project model from interpolating filter of serialized version.", e);
        }
        return model;
    }

    private String interpolateInternal(String src, Model model, Map context, Map overrideContext, final File projectDir, boolean outputDebugMessages) throws ModelInterpolationException {
        List feedback;
        Logger logger = this.getLogger();
        PrefixedObjectValueSource baseModelValueSource1 = new PrefixedObjectValueSource(PROJECT_PREFIXES, model, false);
        PathTranslatingValueSource modelValueSource1 = new PathTranslatingValueSource(baseModelValueSource1, TRANSLATED_PATH_EXPRESSIONS, projectDir, this.pathTranslator);
        ObjectBasedValueSource baseModelValueSource2 = new ObjectBasedValueSource(model);
        PathTranslatingValueSource modelValueSource2 = new PathTranslatingValueSource(baseModelValueSource2, TRANSLATED_PATH_EXPRESSIONS, projectDir, this.pathTranslator);
        PrefixedValueSourceWrapper basedirValueSource = new PrefixedValueSourceWrapper(new ValueSource(){

            public Object getValue(String expression) {
                if (projectDir != null && "basedir".equals(expression)) {
                    return projectDir.getAbsolutePath();
                }
                return null;
            }
        }, PROJECT_PREFIXES, true);
        RegexBasedInterpolator interpolator = new RegexBasedInterpolator();
        interpolator.addValueSource(basedirValueSource);
        interpolator.addValueSource(new MapBasedValueSource(overrideContext));
        interpolator.addValueSource(modelValueSource1);
        Properties props = new Properties();
        props.putAll((Map<?, ?>)model.getProperties());
        for (Map.Entry<Object, Object> en : props.entrySet()) {
            String val;
            String string = val = en.getValue() != null ? en.getValue().toString() : null;
            if (val == null) continue;
            val = val.replace("&", "&amp;");
            en.setValue(val);
        }
        interpolator.addValueSource(new PrefixedValueSourceWrapper((ValueSource)new MapBasedValueSource(props), PROJECT_PREFIXES, true));
        interpolator.addValueSource(modelValueSource2);
        interpolator.addValueSource(new MapBasedValueSource(context));
        PrefixAwareRecursionInterceptor recursionInterceptor = new PrefixAwareRecursionInterceptor(PROJECT_PREFIXES);
        String result = src;
        Matcher matcher = EXPRESSION_PATTERN.matcher(result);
        while (matcher.find()) {
            String value;
            String wholeExpr = matcher.group(0);
            try {
                value = interpolator.interpolate(wholeExpr, "", recursionInterceptor);
            }
            catch (InterpolationException e) {
                throw new ModelInterpolationException(e.getMessage(), e);
            }
            if (value == null || value.equals(wholeExpr) || value == null) continue;
            if (StringUtils.replace(value.toString(), "${project.", "${pom.").indexOf(StringUtils.replace(wholeExpr, "${project.", "${pom.")) > -1) {
                throw new ModelInterpolationException(wholeExpr, "Expression value '" + value + "' references itself in '" + model.getId() + "'.");
            }
            result = StringUtils.replace(result, wholeExpr, value.toString());
            matcher.reset(result);
        }
        if (outputDebugMessages && (feedback = interpolator.getFeedback()) != null && !feedback.isEmpty()) {
            logger.debug("Maven encountered the following problems during initial POM interpolation:");
            Object last = null;
            for (Object next : feedback) {
                if (next instanceof Throwable) {
                    if (last == null) {
                        logger.debug("", (Throwable)next);
                        continue;
                    }
                    logger.debug(String.valueOf(last), (Throwable)next);
                    continue;
                }
                if (last != null) {
                    logger.debug(String.valueOf(last));
                }
                last = next;
            }
            if (last != null) {
                logger.debug(String.valueOf(last));
            }
        }
        interpolator.clearFeedback();
        return result;
    }
}

