/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.component.composition;

import hidden.org.codehaus.plexus.util.StringUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.component.MapOrientedComponent;
import org.codehaus.plexus.component.composition.AbstractComponentComposer;
import org.codehaus.plexus.component.composition.CompositionException;
import org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.codehaus.plexus.component.repository.ComponentRequirement;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;

public class MapOrientedComponentComposer
extends AbstractComponentComposer {
    private static String SINGLE_MAPPING_TYPE = "single";
    private static String MAP_MAPPING_TYPE = "map";
    private static String SET_MAPPING_TYPE = "set";
    private static String DEFAULT_MAPPING_TYPE = SINGLE_MAPPING_TYPE;
    static /* synthetic */ Class class$0;

    public String getId() {
        return "map-oriented";
    }

    public void verifyComponentSuitability(Object component) throws CompositionException {
        if (!(component instanceof MapOrientedComponent)) {
            throw new CompositionException("Cannot compose component: " + component.getClass().getName() + "; it does not implement " + MapOrientedComponent.class.getName());
        }
    }

    public void assignRequirement(Object component, ComponentDescriptor componentDescriptor, ComponentRequirement requirement, PlexusContainer container, Map compositionContext, ClassRealm lookupRealm) throws CompositionException {
        this.addRequirement((MapOrientedComponent)component, container, requirement, lookupRealm);
    }

    private List addRequirement(MapOrientedComponent component, PlexusContainer container, ComponentRequirement requirement, ClassRealm componentRealm) throws CompositionException {
        try {
            List<ComponentDescriptor> retValue;
            String role = requirement.getRole();
            String hint = requirement.getRoleHint();
            String mappingType = requirement.getFieldMappingType();
            HashSet value = null;
            if (StringUtils.isNotEmpty(hint) && !hint.equals("default")) {
                value = container.lookup(role, hint);
                ComponentDescriptor componentDescriptor = container.getComponentDescriptor(role, hint, componentRealm);
                retValue = Collections.singletonList(componentDescriptor);
            } else if (SINGLE_MAPPING_TYPE.equals(mappingType)) {
                value = container.lookup(role, hint);
                ComponentDescriptor componentDescriptor = container.getComponentDescriptor(role, hint, componentRealm);
                retValue = Collections.singletonList(componentDescriptor);
            } else if (MAP_MAPPING_TYPE.equals(mappingType)) {
                value = container.lookupMap(role);
                retValue = container.getComponentDescriptorList(role);
            } else if (SET_MAPPING_TYPE.equals(mappingType)) {
                value = new HashSet(container.lookupList(role));
                retValue = container.getComponentDescriptorList(role);
            } else {
                value = container.lookup(role, hint);
                ComponentDescriptor componentDescriptor = container.getComponentDescriptor(role, hint, componentRealm);
                retValue = Collections.singletonList(componentDescriptor);
            }
            component.addComponentRequirement(requirement, value);
            return retValue;
        }
        catch (ComponentLookupException e) {
            throw new CompositionException("Composition failed in object of type " + component.getClass().getName() + " because the requirement " + requirement + " was missing", e);
        }
        catch (ComponentConfigurationException e) {
            throw new CompositionException("Composition failed in object of type " + component.getClass().getName() + " because the requirement " + requirement + " cannot be set on the component.", e);
        }
    }
}

