/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.upgrade;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Set;
import java.util.regex.Pattern;
import org.netbeans.upgrade.PathTransformation;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

final class Copy {
    private FileObject sourceRoot;
    private FileObject targetRoot;
    private Set thoseToCopy;
    private PathTransformation transformation;

    private Copy(FileObject fileObject, FileObject fileObject2, Set set, PathTransformation pathTransformation) {
        this.sourceRoot = fileObject;
        this.targetRoot = fileObject2;
        this.thoseToCopy = set;
        this.transformation = pathTransformation;
    }

    public static void copyDeep(FileObject fileObject, FileObject fileObject2, Set set) throws IOException {
        Copy.copyDeep(fileObject, fileObject2, set, null);
    }

    public static void copyDeep(FileObject fileObject, FileObject fileObject2, Set set, PathTransformation pathTransformation) throws IOException {
        Copy copy = new Copy(fileObject, fileObject2, set, pathTransformation);
        copy.copyFolder(copy.sourceRoot);
    }

    private void copyFolder(FileObject fileObject) throws IOException {
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileObject fileObject2 = fileObjectArray[i];
            if (fileObject2.isFolder()) {
                this.copyFolder(fileObject2);
                if (!this.thoseToCopy.contains(fileObject2.getPath()) && !this.thoseToCopy.contains(fileObject2.getPath() + "/") || !fileObject2.getAttributes().hasMoreElements()) continue;
                this.copyFolderAttributes(fileObject2);
                continue;
            }
            if (!this.thoseToCopy.contains(fileObject2.getPath())) continue;
            this.copyFile(fileObject2);
        }
    }

    private void copyFolderAttributes(FileObject fileObject) throws IOException {
        FileObject fileObject2 = FileUtil.createFolder((FileObject)this.targetRoot, (String)fileObject.getPath());
        if (fileObject.getAttributes().hasMoreElements()) {
            FileUtil.copyAttributes((FileObject)fileObject, (FileObject)fileObject2);
        }
    }

    private void copyFile(FileObject fileObject) throws IOException {
        String string = this.transformation != null ? this.transformation.transformPath(fileObject.getPath()) : fileObject.getPath();
        boolean bl = !string.equals(fileObject.getPath());
        FileObject fileObject2 = this.targetRoot.getFileObject(string);
        try {
            if (fileObject2 == null) {
                FileObject fileObject3 = null;
                String string2 = null;
                String string3 = null;
                if (bl) {
                    FileObject fileObject4 = FileUtil.createData((FileObject)this.targetRoot, (String)string);
                    fileObject3 = fileObject4.getParent();
                    string2 = fileObject4.getName();
                    string3 = fileObject4.getExt();
                    fileObject4.delete();
                } else {
                    fileObject3 = FileUtil.createFolder((FileObject)this.targetRoot, (String)fileObject.getParent().getPath());
                    string2 = fileObject.getName();
                    string3 = fileObject.getExt();
                }
                fileObject2 = FileUtil.copyFile((FileObject)fileObject, (FileObject)fileObject3, (String)string2, (String)string3);
            }
        }
        catch (IOException iOException) {
            if (fileObject.getNameExt().endsWith("_hidden")) {
                return;
            }
            throw iOException;
        }
        FileUtil.copyAttributes((FileObject)fileObject, (FileObject)fileObject2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public static void appendSelectedLines(File var0, File var1_1, String[] var2_2) throws IOException {
        if (!var0.exists()) {
            return;
        }
        var3_3 = new Pattern[var2_2.length];
        for (var4_4 = 0; var4_4 < var3_3.length; ++var4_4) {
            var3_3[var4_4] = Pattern.compile(var2_2[var4_4]);
        }
        var4_5 = new ByteArrayOutputStream();
        var5_6 = new File(var1_1, var0.getName());
        if (!var1_1.exists()) {
            var1_1.mkdirs();
        }
        if (!Copy.$assertionsDisabled && !var1_1.exists()) {
            throw new AssertionError();
        }
        if (!var5_6.exists()) {
            var5_6.createNewFile();
        } else {
            var6_7 = new FileInputStream(var5_6);
            try {
                FileUtil.copy((InputStream)var6_7, (OutputStream)var4_5);
            }
            finally {
                var6_7.close();
            }
        }
        if (!Copy.$assertionsDisabled && !var5_6.exists()) {
            throw new AssertionError();
        }
        var6_7 = null;
        var7_9 = new BufferedReader(new FileReader(var0));
lbl30:
        // 2 sources

        try {
            block10: while ((var6_7 = var7_9.readLine()) != null) {
                block21: {
                    if (var3_3 == null) break block21;
                    for (var8_10 = 0; var8_10 < var3_3.length; ++var8_10) {
                        var9_12 = var3_3[var8_10].matcher((CharSequence)var6_7);
                        if (!var9_12.matches()) continue;
                        var4_5.write(var6_7.getBytes());
                        var4_5.write(10);
                        continue block10;
                    }
                    ** GOTO lbl30
                }
                var4_5.write(var6_7.getBytes());
                var4_5.write(10);
            }
        }
        finally {
            var7_9.close();
        }
        var8_11 = new ByteArrayInputStream(var4_5.toByteArray());
        var9_12 = new FileOutputStream(var5_6);
        try {
            FileUtil.copy((InputStream)var8_11, (OutputStream)var9_12);
        }
        finally {
            var8_11.close();
            var9_12.close();
        }
    }
}

