/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.openide.util.ImageUtilities;
import org.openide.util.Utilities;

public class Util {
    private Util() {
    }

    public static void setDefaultLookAndFeel() {
        String string = Utilities.isWindows() ? "com.sun.java.swing.plaf.windows.WindowsLookAndFeel" : (Utilities.isMac() ? "apple.laf.AquaLookAndFeel" : (Utilities.isUnix() ? "javax.swing.plaf.metal.MetalLookAndFeel" : UIManager.getSystemLookAndFeelClassName()));
        if (string.equals(UIManager.getLookAndFeel().getClass().getName())) {
            return;
        }
        try {
            UIManager.setLookAndFeel(string);
        }
        catch (Exception exception) {
            System.err.println("Cannot set L&F " + string);
            System.err.println("Exception:" + exception.getMessage());
            exception.printStackTrace();
        }
    }

    public static JDialog createModalDialog(String string) {
        try {
            Class<?> clazz = Class.forName("java.awt.Dialog$ModalityType");
            Method method = clazz.getMethod("valueOf", String.class);
            Object object = method.invoke(null, "APPLICATION_MODAL");
            Constructor constructor = JDialog.class.getConstructor(Window.class, String.class, object.getClass());
            return (JDialog)constructor.newInstance(null, string, object);
        }
        catch (Exception exception) {
            return new JDialog((Frame)null, string, true);
        }
    }

    public static void initIcons(JDialog jDialog) {
        Method method = null;
        try {
            method = jDialog.getClass().getMethod("setIconImages", List.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        if (method != null) {
            ArrayList<Image> arrayList = new ArrayList<Image>();
            arrayList.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame.gif", (boolean)true));
            arrayList.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame32.gif", (boolean)true));
            arrayList.add(ImageUtilities.loadImage((String)"org/netbeans/core/startup/frame48.gif", (boolean)true));
            try {
                method.invoke((Object)jDialog, arrayList);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }

    public static JDialog createJOptionDialog(final JOptionPane jOptionPane, String string) {
        final JDialog jDialog = Util.createModalDialog(string);
        Util.initIcons(jDialog);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)jOptionPane, "Center");
        jDialog.setResizable(false);
        jDialog.pack();
        jDialog.setLocationRelativeTo(null);
        WindowAdapter windowAdapter = new WindowAdapter(){
            private boolean gotFocus = false;

            public void windowClosing(WindowEvent windowEvent) {
                jOptionPane.setValue(null);
            }

            public void windowGainedFocus(WindowEvent windowEvent) {
                if (!this.gotFocus) {
                    jOptionPane.selectInitialValue();
                    this.gotFocus = true;
                }
            }
        };
        jDialog.addWindowListener(windowAdapter);
        jDialog.addWindowFocusListener(windowAdapter);
        jDialog.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                jOptionPane.setValue(JOptionPane.UNINITIALIZED_VALUE);
            }
        });
        jOptionPane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (jDialog.isVisible() && propertyChangeEvent.getSource() == jOptionPane && propertyChangeEvent.getPropertyName().equals("value") && propertyChangeEvent.getNewValue() != null && propertyChangeEvent.getNewValue() != JOptionPane.UNINITIALIZED_VALUE) {
                    jDialog.setVisible(false);
                }
            }
        });
        return jDialog;
    }
}

