/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mobility.antext;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.classfile.CPEntry;
import org.netbeans.modules.classfile.CPMethodInfo;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.classfile.ClassName;
import org.netbeans.modules.classfile.Code;
import org.netbeans.modules.classfile.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StackTraceTranslator {
    private final ClassLoader cl;
    private final Map<ClassName, ClassFile> parsedClasses;

    public StackTraceTranslator(File file, String[] stringArray) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (int i = 0; i < stringArray.length; ++i) {
            StackTraceTranslator.addURL(arrayList, file, stringArray[i]);
        }
        this.cl = new URLClassLoader(arrayList.toArray(new URL[arrayList.size()]), null);
        this.parsedClasses = new HashMap<ClassName, ClassFile>();
    }

    public String translate(String string, boolean bl) {
        String[] stringArray = string.split("[\n\r]+", -1);
        String[] stringArray2 = new String[stringArray.length + 1];
        String[] stringArray3 = new String[stringArray.length + 1];
        int[] nArray = new int[stringArray.length];
        boolean[] blArray = new boolean[stringArray.length];
        String[] stringArray4 = new String[stringArray.length];
        if (bl) {
            this.fillArraysBci(stringArray, stringArray2, stringArray3, nArray);
        } else {
            this.fillArrays(stringArray, stringArray2, stringArray3, nArray, blArray);
        }
        String[] stringArray5 = new String[]{null};
        for (int i = stringArray.length - 1; i >= 0; --i) {
            int n;
            if (stringArray2[i] == null) {
                stringArray5[0] = null;
                stringArray4[i] = stringArray[i];
                continue;
            }
            Method method = this.findMethod(stringArray2[i], stringArray3[i], stringArray5[0], i > 0 ? stringArray2[i - 1] : null, i > 0 ? stringArray3[i - 1] : null, nArray[i], stringArray5);
            int n2 = n = method == null ? -1 : this.getLineNumber(method.getCode(), nArray[i]);
            if (n < 0) {
                if (bl) {
                    stringArray4[i] = "\tat " + stringArray[i].substring(stringArray[i].indexOf(stringArray2[i]));
                    continue;
                }
                stringArray4[i] = stringArray[i];
                continue;
            }
            stringArray4[i] = (blArray[i] && !bl ? "[catch] at " : "\tat ") + stringArray2[i] + "." + stringArray3[i] + "(" + method.getClassFile().getSourceFileName() + ":" + String.valueOf(n) + ")";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray4.length; ++i) {
            stringBuffer.append(stringArray4[i]).append('\n');
        }
        return stringBuffer.toString();
    }

    private void fillArrays(String[] stringArray, String[] stringArray2, String[] stringArray3, int[] nArray, boolean[] blArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            int n = string.indexOf("at ");
            int n2 = string.lastIndexOf(46);
            int n3 = string.lastIndexOf("(+");
            int n4 = string.lastIndexOf(41);
            if (!string.startsWith("[catch]") && n != 0 || n2 <= 3 || n3 <= 5 || n4 <= 8) continue;
            try {
                stringArray2[i] = string.substring(n + 3, n2).trim();
                stringArray3[i] = string.substring(n2 + 1, n3).trim();
                nArray[i] = Integer.parseInt(string.substring(n3 + 2, n4).trim());
                blArray[i] = n > 0;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void fillArraysBci(String[] stringArray, String[] stringArray2, String[] stringArray3, int[] nArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i].trim();
            int n = string.indexOf("- ");
            int n2 = string.lastIndexOf(46);
            int n3 = string.lastIndexOf("(),");
            int n4 = string.lastIndexOf("bci=");
            if (n2 <= 2 || n3 <= 4 || n4 <= 7) continue;
            try {
                stringArray2[i] = string.substring(n + 2, n2).trim();
                stringArray3[i] = string.substring(n2 + 1, n3).trim();
                nArray[i] = Integer.parseInt(string.substring(n4 + 4).trim()) + 3;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private static void addURL(List<URL> list, File file, String string) {
        if (string == null) {
            return;
        }
        File file2 = new File(string);
        if (!(file == null || file2.exists() && file2.isAbsolute())) {
            file2 = new File(file, string);
        }
        try {
            if (file2.exists()) {
                list.add(file2.toURI().toURL());
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
    }

    private ClassFile getClass(ClassName className) {
        if (this.parsedClasses.containsKey(className)) {
            return this.parsedClasses.get(className);
        }
        ClassFile classFile = null;
        InputStream inputStream = this.cl.getResourceAsStream(className.getInternalName() + ".class");
        if (inputStream != null) {
            try {
                classFile = new ClassFile(inputStream);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.parsedClasses.put(className, classFile);
        return classFile;
    }

    private int getLineNumber(Code code, int n) {
        if ((n -= 3) < 0 || n >= code.getByteCodes().length) {
            return -1;
        }
        int[] nArray = code.getLineNumberTable();
        if (nArray.length == 0) {
            return -1;
        }
        for (int i = 2; i < nArray.length; i += 2) {
            if (nArray[i] <= n) continue;
            return nArray[i - 1];
        }
        return nArray[nArray.length - 1];
    }

    private Method findMethod(String string, String string2, String string3, String string4, String string5, int n, String[] stringArray) {
        Method method;
        ClassFile classFile;
        if (stringArray != null && stringArray.length == 1) {
            stringArray[0] = null;
        }
        if ((classFile = this.getClass(this.getClassName(string))) == null) {
            return null;
        }
        if (string3 != null && (method = classFile.getMethod(string2, string3)) != null && this.checkMethod(classFile, method, string4, string5, n, stringArray)) {
            return method;
        }
        for (Method method2 : classFile.getMethods()) {
            if (!method2.getName().equals(string2) || !this.checkMethod(classFile, method2, string4, string5, n, stringArray)) continue;
            return method2;
        }
        return null;
    }

    private boolean checkMethod(ClassFile classFile, Method method, String string, String string2, int n, String[] stringArray) {
        Set<String> set = this.getParents(string);
        if (set.isEmpty() || string2 == null) {
            return true;
        }
        CPMethodInfo cPMethodInfo = this.getMethodCall(classFile, method.getCode(), n);
        if (cPMethodInfo != null && set.contains(cPMethodInfo.getClassName().getInternalName()) && string2.equals(cPMethodInfo.getName())) {
            if (stringArray != null && stringArray.length == 1) {
                stringArray[0] = cPMethodInfo.getDescriptor();
            }
            return true;
        }
        return false;
    }

    private ClassName getClassName(String string) {
        return string == null ? null : ClassName.getClassName((String)string.replace('.', '/'));
    }

    private Set<String> getParents(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        this.collectParents(this.getClassName(string), hashSet);
        return hashSet;
    }

    private void collectParents(ClassName className, Set<String> set) {
        if (className == null) {
            return;
        }
        ClassFile classFile = this.getClass(className);
        if (classFile == null) {
            return;
        }
        set.add(classFile.getName().getInternalName());
        this.collectParents(classFile.getSuperClass(), set);
        for (ClassName className2 : classFile.getInterfaces()) {
            this.collectParents(className2, set);
        }
    }

    private CPMethodInfo getMethodCall(ClassFile classFile, Code code, int n) {
        if ((n -= 3) < 0 || code == null || n >= code.getByteCodes().length) {
            return null;
        }
        byte[] byArray = code.getByteCodes();
        int n2 = byArray[n] & 0xFF;
        if (n2 != 183 && n2 != 184 && n2 != 182 && ((n -= 2) < 0 || (byArray[n] & 0xFF) != 185)) {
            return null;
        }
        int n3 = (byArray[n + 1] & 0xFF00) + (byArray[n + 2] & 0xFF);
        try {
            CPEntry cPEntry = classFile.getConstantPool().get(n3);
            if (cPEntry instanceof CPMethodInfo) {
                return (CPMethodInfo)cPEntry;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }
}

