/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.lexer.JavadocTokenId;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.lexer.TokenUtilities;
import org.netbeans.spi.editor.bracesmatching.BracesMatcher;
import org.netbeans.spi.editor.bracesmatching.BracesMatcherFactory;
import org.netbeans.spi.editor.bracesmatching.MatcherContext;
import org.netbeans.spi.editor.bracesmatching.support.BracesMatcherSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JavadocBracesMatcher
implements BracesMatcher,
BracesMatcherFactory {
    private static final Logger LOG = Logger.getLogger(JavadocBracesMatcher.class.getName());
    private final MatcherContext context;
    private TokenSequence<? extends TokenId> jdocSeq;
    private int jdocStart;
    private int jdocEnd;
    private BracesMatcher defaultMatcher;

    public JavadocBracesMatcher() {
        this(null);
    }

    private JavadocBracesMatcher(MatcherContext matcherContext) {
        this.context = matcherContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findOrigin() throws BadLocationException, InterruptedException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            int n = this.context.getSearchOffset();
            boolean bl = this.context.isSearchingBackward();
            TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.context.getDocument());
            List list = tokenHierarchy.embeddedTokenSequences(n, bl);
            for (int i = list.size() - 1; i >= 0; --i) {
                TokenSequence tokenSequence = (TokenSequence)list.get(i);
                if (tokenSequence.language() != JavadocTokenId.language()) continue;
                this.jdocSeq = tokenSequence;
                if (i > 0) {
                    TokenSequence tokenSequence2 = (TokenSequence)list.get(i - 1);
                    this.jdocStart = tokenSequence2.offset();
                    this.jdocEnd = tokenSequence2.offset() + tokenSequence2.token().length();
                    break;
                }
                this.jdocStart = 0;
                this.jdocEnd = this.context.getDocument().getLength();
                break;
            }
            if (this.jdocSeq == null) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Not javadoc TokenSequence.");
                }
                int[] nArray = null;
                return nArray;
            }
            this.jdocSeq.move(n);
            if (this.jdocSeq.moveNext()) {
                if (JavadocBracesMatcher.isTag((Token<? extends TokenId>)this.jdocSeq.token()) && (this.jdocSeq.offset() < n || !bl)) {
                    int[] nArray = JavadocBracesMatcher.prepareOffsets(this.jdocSeq, true);
                    return nArray;
                }
                while (this.moveTheSequence(this.jdocSeq, bl, this.context.getLimitOffset())) {
                    if (!JavadocBracesMatcher.isTag((Token<? extends TokenId>)this.jdocSeq.token())) continue;
                    int[] nArray = JavadocBracesMatcher.prepareOffsets(this.jdocSeq, true);
                    return nArray;
                }
            }
            this.defaultMatcher = BracesMatcherSupport.defaultMatcher((MatcherContext)this.context, (int)this.jdocStart, (int)this.jdocEnd);
            int[] nArray = this.defaultMatcher.findOrigin();
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] findMatches() throws InterruptedException, BadLocationException {
        ((AbstractDocument)this.context.getDocument()).readLock();
        try {
            if (this.defaultMatcher != null) {
                int[] nArray = this.defaultMatcher.findMatches();
                return nArray;
            }
            assert (this.jdocSeq != null) : "No javadoc token sequence";
            Token token = this.jdocSeq.token();
            assert (token.id() == JavadocTokenId.HTML_TAG) : "Wrong token";
            if (JavadocBracesMatcher.isSingleTag((Token<? extends TokenId>)token)) {
                int[] nArray = new int[]{this.jdocSeq.offset(), this.jdocSeq.offset() + this.jdocSeq.token().length()};
                return nArray;
            }
            boolean bl = !JavadocBracesMatcher.isOpeningTag((Token<? extends TokenId>)token);
            int n = 0;
            while (this.moveTheSequence(this.jdocSeq, bl, -1)) {
                if (!JavadocBracesMatcher.isTag((Token<? extends TokenId>)this.jdocSeq.token()) || !JavadocBracesMatcher.matchTags((Token<? extends TokenId>)token, (Token<? extends TokenId>)this.jdocSeq.token())) continue;
                if (bl && !JavadocBracesMatcher.isOpeningTag((Token<? extends TokenId>)this.jdocSeq.token()) || !bl && JavadocBracesMatcher.isOpeningTag((Token<? extends TokenId>)this.jdocSeq.token())) {
                    ++n;
                    continue;
                }
                if (n == 0) {
                    int[] nArray = JavadocBracesMatcher.prepareOffsets(this.jdocSeq, false);
                    return nArray;
                }
                --n;
            }
            int[] nArray = null;
            return nArray;
        }
        finally {
            ((AbstractDocument)this.context.getDocument()).readUnlock();
        }
    }

    private boolean moveTheSequence(TokenSequence<? extends TokenId> tokenSequence, boolean bl, int n) {
        if (bl) {
            if (tokenSequence.movePrevious()) {
                int n2 = tokenSequence.offset() + tokenSequence.token().length();
                return n == -1 ? true : n2 > n;
            }
        } else if (tokenSequence.moveNext()) {
            int n3 = tokenSequence.offset();
            return n == -1 ? true : n3 < n;
        }
        return false;
    }

    private static boolean isTag(Token<? extends TokenId> token) {
        boolean bl;
        CharSequence charSequence = token.text();
        int n = charSequence.length();
        boolean bl2 = bl = token.id() == JavadocTokenId.HTML_TAG && n >= 3 && charSequence.charAt(0) == '<' && charSequence.charAt(n - 1) == '>';
        if (bl) {
            bl = charSequence.charAt(1) == '/' ? n >= 4 && Character.isLetterOrDigit(charSequence.charAt(2)) : Character.isLetterOrDigit(charSequence.charAt(1));
        }
        return bl;
    }

    private static boolean isSingleTag(Token<? extends TokenId> token) {
        return TokenUtilities.endsWith((CharSequence)token.text(), (CharSequence)"/>");
    }

    private static boolean isOpeningTag(Token<? extends TokenId> token) {
        return !TokenUtilities.startsWith((CharSequence)token.text(), (CharSequence)"</");
    }

    private static boolean matchTags(Token<? extends TokenId> token, Token<? extends TokenId> token2) {
        assert (token.length() >= 2 && token.text().charAt(0) == '<') : token + " is not a tag.";
        assert (token2.length() >= 2 && token2.text().charAt(0) == '<') : token2 + " is not a tag.";
        int n = 1;
        int n2 = 1;
        if (token.text().charAt(1) == '/') {
            ++n;
        }
        if (token2.text().charAt(1) == '/') {
            ++n2;
        }
        while (n < token.length() && n2 < token2.length()) {
            char c;
            char c2 = token.text().charAt(n);
            if (c2 != (c = token2.text().charAt(n2))) {
                return !Character.isLetterOrDigit(c2) || !Character.isLetterOrDigit(c);
            }
            if (!Character.isLetterOrDigit(c2)) {
                return true;
            }
            ++n;
            ++n2;
        }
        return false;
    }

    private static int[] prepareOffsets(TokenSequence<? extends TokenId> tokenSequence, boolean bl) {
        int n = tokenSequence.offset();
        int n2 = tokenSequence.offset() + tokenSequence.token().length();
        CharSequence charSequence = tokenSequence.token().text();
        if (charSequence.charAt(1) == '/') {
            return new int[]{n, n2};
        }
        int n3 = n2;
        for (int i = 1; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '>') continue;
            n3 = n + i;
            break;
        }
        if (bl) {
            return new int[]{n, n2, n, n3};
        }
        return new int[]{n, n3};
    }

    public BracesMatcher createMatcher(MatcherContext matcherContext) {
        return new JavadocBracesMatcher(matcherContext);
    }
}

