/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.javadoc.search.IndexBuilder;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class ReferencesPanel
extends JPanel
implements Runnable,
ListSelectionListener {
    private static final String PLEASE_WAIT = NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.wait.text");
    private static final Object LOCK = new Object();
    private static final String EMPTY_LOCATION = "";
    private int state = 0;
    private ListModel model;
    private ItemDesc[] items;
    private final AbstractButton openBtn;
    private JScrollPane jScrollPane1;
    private JLabel listLabel;
    private JTextField locationField;
    private JLabel locationLabel;
    private JList refList;

    public ReferencesPanel(AbstractButton abstractButton) {
        this.initComponents();
        Mnemonics.setLocalizedText((JLabel)this.listLabel, (String)NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.listLabel.text"));
        Mnemonics.setLocalizedText((JLabel)this.locationLabel, (String)NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.locationLabel.text"));
        this.openBtn = abstractButton;
    }

    public static FileObject showInWindow() {
        JButton jButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.ok.text"));
        jButton.getAccessibleContext().setAccessibleDescription(jButton.getText());
        jButton.setEnabled(false);
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        ReferencesPanel referencesPanel = new ReferencesPanel(jButton);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)referencesPanel, NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.title"), true, objectArray, (Object)jButton, 0, HelpCtx.DEFAULT_HELP, null);
        dialogDescriptor.setClosingOptions(objectArray);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReferencesPanel.class, (String)"AN_ReferencesDialog"));
        dialog.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReferencesPanel.class, (String)"AD_ReferencesDialog"));
        RequestProcessor.getDefault().post((Runnable)referencesPanel);
        dialog.setVisible(true);
        dialog.dispose();
        return dialogDescriptor.getValue() == jButton ? referencesPanel.getSelectedItem() : null;
    }

    public void run() {
        switch (this.state) {
            case 0: {
                this.runGetIndiciesTask();
                break;
            }
            case 1: {
                this.runListUpdateTask();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runGetIndiciesTask() {
        List[] listArray = IndexBuilder.getDefault().getIndices(true);
        List list = listArray[0];
        List list2 = listArray[1];
        Object object = LOCK;
        synchronized (object) {
            ItemDesc[] itemDescArray;
            if (list.isEmpty()) {
                itemDescArray = new ItemDesc[]{ItemDesc.noItem()};
            } else {
                itemDescArray = new ItemDesc[list.size()];
                this.items = itemDescArray;
                int n = 0;
                for (String string : list) {
                    itemDescArray[n] = new ItemDesc(string, (FileObject)list2.get(n));
                    ++n;
                }
            }
            this.model = new FixListModel(itemDescArray);
        }
        this.state = 1;
        EventQueue.invokeLater(this);
    }

    private void runListUpdateTask() {
        this.refList.setModel(this.model);
        this.refList.addListSelectionListener(this);
        this.refList.setSelectedIndex(0);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        FileObject fileObject = this.getSelectedItem();
        String string = fileObject == null ? EMPTY_LOCATION : FileUtil.getFileDisplayName((FileObject)fileObject);
        this.locationField.setText(string);
        this.openBtn.setEnabled(fileObject != null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    FileObject getSelectedItem() {
        int n = this.refList.getSelectedIndex();
        Object object = LOCK;
        synchronized (object) {
            return n < 0 || this.items == null || this.items.length == 0 ? null : this.items[n].location;
        }
    }

    private void initComponents() {
        this.listLabel = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.refList = new JList<String>(new String[]{PLEASE_WAIT});
        this.locationField = new JTextField();
        this.locationLabel = new JLabel();
        this.listLabel.setLabelFor(this.refList);
        this.listLabel.setText(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.listLabel.text"));
        this.refList.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.refList);
        this.refList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.refList.AccessibleContext.accessibleName"));
        this.refList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.refList.AccessibleContext.accessibleDescription"));
        this.locationField.setEditable(false);
        this.locationLabel.setLabelFor(this.locationField);
        this.locationLabel.setText(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.locationLabel.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.jScrollPane1, -1, 376, Short.MAX_VALUE).add(1, (Component)this.listLabel).add(1, (Component)this.locationField, -1, 376, Short.MAX_VALUE).add(1, (Component)this.locationLabel)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((Component)this.listLabel).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 191, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.locationLabel).addPreferredGap(0).add((Component)this.locationField, -2, -1, -2).addContainerGap()));
        this.listLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.listLabel.AccessibleContext.accessibleName"));
        this.listLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.listLabel.AccessibleContext.accessibleDescription"));
        this.locationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.locationLabel.AccessibleContext.accessibleName"));
        this.locationLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.locationLabel.AccessibleContext.accessibleDescription"));
    }

    private static final class FixListModel
    implements ListModel {
        private ItemDesc[] items;

        public FixListModel(ItemDesc[] itemDescArray) {
            this.items = itemDescArray;
        }

        public int getSize() {
            return this.items.length;
        }

        public Object getElementAt(int n) {
            return this.items[n].name;
        }

        public void addListDataListener(ListDataListener listDataListener) {
        }

        public void removeListDataListener(ListDataListener listDataListener) {
        }
    }

    private static final class ItemDesc {
        private static ItemDesc NO_ITEM;
        String name;
        String locationName;
        FileObject location;

        public ItemDesc(String string, FileObject fileObject) {
            this.name = string;
            this.location = fileObject;
        }

        String getLocationName() {
            if (this.locationName == null) {
                this.locationName = FileUtil.getFileDisplayName((FileObject)this.location);
            }
            return this.locationName;
        }

        static ItemDesc noItem() {
            if (NO_ITEM == null) {
                NO_ITEM = new ItemDesc(NbBundle.getMessage(ReferencesPanel.class, (String)"ReferencesPanel.noJavadoc"), null);
            }
            return NO_ITEM;
        }
    }
}

