/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.AbstractAction;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.netbeans.api.visual.widget.Scene;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class ZoomManager {
    public static final int DEFAULT_ZOOM_PERCENT = 100;
    public static final int MIN_ZOOM_PERCENT = 33;
    public static final int MAX_ZOOM_PERCENT = 200;
    private static final int ZOOM_STEP_THRESHOLD = 100;
    private static final int ZOOM_STEP_SMALL = 5;
    private static final int ZOOM_STEP_LARGE = 25;
    private Scene scene;
    private int zoomPercentage = 100;
    private EventListenerList listeners;

    public ZoomManager(Scene scene) {
        this.scene = scene;
        this.listeners = new EventListenerList();
        scene.addSceneListener(new Scene.SceneListener(){

            public void sceneRepaint() {
            }

            public void sceneValidating() {
            }

            public void sceneValidated() {
                int n = (int)(ZoomManager.this.getScene().getZoomFactor() * 100.0);
                if (n != ZoomManager.this.zoomPercentage) {
                    ZoomManager.this.zoomPercentage = n;
                    ZoomManager.this.fireZoomEvent(ZoomManager.this.zoomPercentage);
                }
            }
        });
    }

    public void addZoomListener(ZoomListener zoomListener) {
        this.listeners.add(ZoomListener.class, zoomListener);
    }

    public void addToolbarActions(JToolBar jToolBar) {
        jToolBar.add(new FitDiagramAction(this));
        jToolBar.add(new FitWidthAction(this));
        jToolBar.add(new ZoomDefaultAction(this));
        jToolBar.add(new ZoomComboBox(this));
        ZoomInAction zoomInAction = new ZoomInAction(this);
        this.addZoomListener(zoomInAction);
        jToolBar.add(zoomInAction);
        ZoomOutAction zoomOutAction = new ZoomOutAction(this);
        this.addZoomListener(zoomOutAction);
        jToolBar.add(zoomOutAction);
    }

    public static int calculateZoomInValue(int n) {
        int n2 = n >= 100 ? (n + 25) / 25 * 25 : (n + 5) / 5 * 5;
        return n2;
    }

    public static int calculateZoomOutValue(int n) {
        int n2 = n > 100 ? (n - 1) / 25 * 25 : (n - 1) / 5 * 5;
        return n2;
    }

    private void fireZoomEvent(int n) {
        Object[] objectArray = this.listeners.getListenerList();
        ZoomEvent zoomEvent = null;
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != ZoomListener.class) continue;
            if (zoomEvent == null) {
                zoomEvent = new ZoomEvent(this, n);
            }
            ((ZoomListener)objectArray[i + 1]).zoomChanged(zoomEvent);
        }
    }

    public Scene getScene() {
        return this.scene;
    }

    public int getZoom() {
        return this.zoomPercentage;
    }

    public void removeZoomListener(ZoomListener zoomListener) {
        this.listeners.remove(ZoomListener.class, zoomListener);
    }

    public void setZoom(int n) {
        JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, this.scene.getView());
        assert (jScrollPane != null) : "Scene view component not in a JScrollPane?!?";
        if (jScrollPane == null) {
            return;
        }
        JViewport jViewport = jScrollPane.getViewport();
        Rectangle rectangle = jViewport.getViewRect();
        Point point = new Point(rectangle.x + rectangle.width / 2, rectangle.y + rectangle.height / 2);
        this.setZoom(n, point);
    }

    public void setZoom(int n, Point point) {
        if (n < 33) {
            n = 33;
        } else if (n > 200) {
            n = 200;
        }
        Point point2 = this.scene.convertViewToScene(point);
        this.zoomPercentage = n;
        double d = (double)n / 100.0;
        this.scene.setZoomFactor(d);
        this.scene.validate();
        this.scene.repaint();
        Point point3 = this.scene.convertSceneToView(point2);
        JComponent jComponent = this.scene.getView();
        Rectangle rectangle = jComponent.getVisibleRect();
        rectangle.x = point3.x - (point.x - rectangle.x);
        rectangle.y = point3.y - (point.y - rectangle.y);
        Dimension dimension = jComponent.getSize();
        if (rectangle.x + rectangle.width > dimension.width) {
            rectangle.x = dimension.width - rectangle.width;
        }
        if (rectangle.y + rectangle.height > dimension.height) {
            rectangle.y = dimension.height - rectangle.height;
        }
        if (rectangle.x < 0) {
            rectangle.x = 0;
        }
        if (rectangle.y < 0) {
            rectangle.y = 0;
        }
        jComponent.scrollRectToVisible(rectangle);
        jComponent.revalidate();
        jComponent.repaint();
        this.fireZoomEvent(n);
    }

    private static class ZoomOutAction
    extends AbstractAction
    implements ZoomListener {
        private ZoomManager manager;

        public ZoomOutAction(ZoomManager zoomManager) {
            this.manager = zoomManager;
            String string = NbBundle.getMessage(ZoomOutAction.class, (String)"IMG_ZoomOutAction");
            Image image = ImageUtilities.loadImage((String)string);
            if (image != null) {
                this.putValue("SmallIcon", new ImageIcon(image));
            }
            String string2 = NbBundle.getMessage(ZoomOutAction.class, (String)"LBL_ZoomOutAction");
            this.putValue("Name", string2);
            this.putValue("ShortDescription", string2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.manager.getZoom();
            n = ZoomManager.calculateZoomOutValue(n);
            this.manager.setZoom(n);
        }

        public void zoomChanged(ZoomEvent zoomEvent) {
            boolean bl = zoomEvent.getPercent() > 33;
            this.setEnabled(bl);
        }
    }

    private static class ZoomInAction
    extends AbstractAction
    implements ZoomListener {
        private ZoomManager manager;

        public ZoomInAction(ZoomManager zoomManager) {
            this.manager = zoomManager;
            String string = NbBundle.getMessage(ZoomInAction.class, (String)"IMG_ZoomInAction");
            Image image = ImageUtilities.loadImage((String)string);
            if (image != null) {
                this.putValue("SmallIcon", new ImageIcon(image));
            }
            String string2 = NbBundle.getMessage(ZoomInAction.class, (String)"LBL_ZoomInAction");
            this.putValue("Name", string2);
            this.putValue("ShortDescription", string2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = this.manager.getZoom();
            n = ZoomManager.calculateZoomInValue(n);
            this.manager.setZoom(n);
        }

        public void zoomChanged(ZoomEvent zoomEvent) {
            boolean bl = zoomEvent.getPercent() < 200;
            this.setEnabled(bl);
        }
    }

    private static class ZoomDefaultAction
    extends AbstractAction {
        private ZoomManager manager;

        public ZoomDefaultAction(ZoomManager zoomManager) {
            this.manager = zoomManager;
            String string = NbBundle.getMessage(ZoomDefaultAction.class, (String)"IMG_ZoomDefaultAction");
            Image image = ImageUtilities.loadImage((String)string);
            if (image != null) {
                this.putValue("SmallIcon", new ImageIcon(image));
            }
            String string2 = NbBundle.getMessage(ZoomDefaultAction.class, (String)"LBL_ZoomDefaultAction");
            this.putValue("Name", string2);
            this.putValue("ShortDescription", string2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.manager.setZoom(100);
        }
    }

    private static class FitWidthAction
    extends AbstractAction {
        private ZoomManager manager;

        public FitWidthAction(ZoomManager zoomManager) {
            this.manager = zoomManager;
            String string = NbBundle.getMessage(FitWidthAction.class, (String)"IMG_FitWidthAction");
            Image image = ImageUtilities.loadImage((String)string);
            if (image != null) {
                this.putValue("SmallIcon", new ImageIcon(image));
            }
            String string2 = NbBundle.getMessage(FitWidthAction.class, (String)"LBL_FitWidthAction");
            this.putValue("Name", string2);
            this.putValue("ShortDescription", string2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Scene scene = this.manager.getScene();
            JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, scene.getView());
            if (jScrollPane == null) {
                return;
            }
            JViewport jViewport = jScrollPane.getViewport();
            Rectangle rectangle = jViewport.getViewRect();
            Rectangle rectangle2 = scene.getPreferredBounds();
            int n = rectangle.width * 100 / rectangle2.width;
            this.manager.setZoom(n);
        }
    }

    private static class FitDiagramAction
    extends AbstractAction {
        private ZoomManager manager;

        public FitDiagramAction(ZoomManager zoomManager) {
            this.manager = zoomManager;
            String string = NbBundle.getMessage(FitDiagramAction.class, (String)"IMG_FitDiagramAction");
            Image image = ImageUtilities.loadImage((String)string);
            if (image != null) {
                this.putValue("SmallIcon", new ImageIcon(image));
            }
            String string2 = NbBundle.getMessage(FitDiagramAction.class, (String)"LBL_FitDiagramAction");
            this.putValue("Name", string2);
            this.putValue("ShortDescription", string2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Scene scene = this.manager.getScene();
            JScrollPane jScrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, scene.getView());
            if (jScrollPane == null) {
                return;
            }
            JViewport jViewport = jScrollPane.getViewport();
            Rectangle rectangle = jViewport.getViewRect();
            Rectangle rectangle2 = scene.getPreferredBounds();
            int n = rectangle.width * 100 / rectangle2.width;
            int n2 = rectangle.height * 100 / rectangle2.height;
            int n3 = Math.min(n, n2);
            this.manager.setZoom(n3);
        }
    }

    private static interface ZoomListener
    extends EventListener {
        public void zoomChanged(ZoomEvent var1);
    }

    private static class ZoomEvent
    extends EventObject {
        private int percent;

        public ZoomEvent(Object object, int n) {
            super(object);
            this.percent = n;
        }

        public int getPercent() {
            return this.percent;
        }
    }

    private static class ZoomComboBox
    extends JComboBox {
        private ZoomManager manager;

        public ZoomComboBox(ZoomManager zoomManager) {
            super(new Model());
            this.manager = zoomManager;
            this.setPrototypeDisplayValue(new Integer(100000));
            this.setMaximumSize(this.getPreferredSize());
            this.setEditable(true);
            Listener listener = new Listener(zoomManager);
            this.addActionListener(listener);
            zoomManager.addZoomListener(listener);
        }

        private class Listener
        implements ActionListener,
        ZoomListener {
            private ZoomManager manager;

            public Listener(ZoomManager zoomManager) {
                this.manager = zoomManager;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                Object object = actionEvent.getSource();
                String string = actionEvent.getActionCommand();
                if (object == ZoomComboBox.this && string.equals(ZoomComboBox.this.getActionCommand())) {
                    Object object2 = ZoomComboBox.this.getSelectedItem();
                    Value value = null;
                    if (object2 instanceof String) {
                        String string2 = (String)object2;
                        if (string2.endsWith("%")) {
                            string2 = string2.substring(0, string2.length() - 1);
                        }
                        try {
                            int n = Integer.parseInt(string2);
                            value = new Value(n);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (object2 instanceof Value) {
                        value = (Value)object2;
                    }
                    if (value == null) {
                        value = new Value(ZoomComboBox.this.manager.getZoom());
                    }
                    this.manager.setZoom(value.getValue());
                }
            }

            public void zoomChanged(ZoomEvent zoomEvent) {
                ZoomComboBox.this.removeActionListener(this);
                ZoomComboBox.this.setSelectedItem(new Value(zoomEvent.getPercent()));
                ZoomComboBox.this.addActionListener(this);
            }
        }

        private static class Value {
            private int value;
            private String str;

            public Value(int n) {
                this.value = n;
                this.str = n + "%";
            }

            public boolean equals(Object object) {
                if (object instanceof Value) {
                    return this.value == ((Value)object).getValue();
                }
                return false;
            }

            public int hashCode() {
                return this.value;
            }

            public int getValue() {
                return this.value;
            }

            public String toString() {
                return this.str;
            }
        }

        private static class Model
        extends DefaultComboBoxModel {
            public Model() {
                this.addElement(new Value(33));
                this.addElement(new Value(50));
                this.addElement(new Value(75));
                Value value = new Value(100);
                this.addElement(value);
                this.addElement(new Value(150));
                this.addElement(new Value(200));
                this.setSelectedItem(value);
            }
        }
    }
}

