/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.ImageWidget;
import org.netbeans.api.visual.widget.LabelWidget;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ImageLabelWidget
extends Widget {
    private ImageWidget imageWidget;
    private LabelWidget labelWidget;
    private LabelWidget commentWidget;
    private TextFieldInplaceEditor editor = null;
    public static final int DEFAULT_GAP = 4;

    public ImageLabelWidget(Scene scene, Image image, String string) {
        this(scene, image, string, null, 4);
    }

    public ImageLabelWidget(Scene scene, Image image, String string, int n) {
        this(scene, image, string, null, n);
    }

    public ImageLabelWidget(Scene scene, Image image, String string, String string2) {
        this(scene, image, string, string2, 4);
    }

    public ImageLabelWidget(Scene scene, Image image, String string, String string2, int n) {
        super(scene);
        this.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.CENTER, (int)n));
        this.setImage(image);
        this.setLabel(string);
        this.setComment(string2);
    }

    public final void setLabel(String string) {
        if (this.labelWidget == null) {
            this.labelWidget = new LabelWidget(this.getScene(), string);
            this.labelWidget.setUseGlyphVector(true);
            this.labelWidget.setAlignment(LabelWidget.Alignment.CENTER);
            this.addChild(this.imageWidget == null || this.getChildren().isEmpty() ? 0 : 1, (Widget)this.labelWidget, 1);
        } else {
            this.labelWidget.setLabel(string);
        }
        this.labelWidget.setVisible(string != null);
    }

    public final void setImage(Image image) {
        if (this.imageWidget == null) {
            this.imageWidget = new ImageWidget(this.getScene(), image);
            this.addChild(0, (Widget)this.imageWidget, 1);
        } else {
            this.imageWidget.setImage(image);
            this.imageWidget.removeChildren();
        }
        this.imageWidget.setVisible(image != null);
    }

    public final void setImage(Widget widget) {
        if (this.imageWidget == null) {
            this.imageWidget = new ImageWidget(this.getScene(), null);
            this.addChild(0, (Widget)this.imageWidget, 1);
        } else {
            this.imageWidget.setImage(null);
            this.imageWidget.removeChildren();
        }
        if (widget != null) {
            this.imageWidget.addChild(widget);
        }
        this.imageWidget.setVisible(widget != null);
    }

    public final void setComment(String string) {
        if (this.commentWidget == null) {
            this.commentWidget = new LabelWidget(this.getScene(), string);
            this.addChild((Widget)this.commentWidget, 1);
            this.commentWidget.setPaintAsDisabled(true);
        } else {
            this.commentWidget.setLabel(string);
        }
        this.commentWidget.setVisible(string != null);
    }

    public final String getLabel() {
        return this.labelWidget == null ? null : this.labelWidget.getLabel();
    }

    public final Image getImage() {
        return this.imageWidget == null ? null : this.imageWidget.getImage();
    }

    protected final Widget getImageWidget() {
        return this.imageWidget == null || this.imageWidget.getChildren().isEmpty() ? null : (Widget)this.imageWidget.getChildren().get(0);
    }

    public final String getComment() {
        return this.commentWidget == null ? null : this.commentWidget.getLabel();
    }

    public final boolean isPaintAsDisabled() {
        if (this.labelWidget != null) {
            return this.labelWidget.isPaintAsDisabled();
        }
        if (this.imageWidget != null) {
            return this.imageWidget.isPaintAsDisabled();
        }
        if (this.commentWidget != null) {
            return this.commentWidget.isPaintAsDisabled();
        }
        return false;
    }

    public final void setPaintAsDisabled(boolean bl) {
        if (this.labelWidget != null) {
            this.labelWidget.setPaintAsDisabled(bl);
        }
        if (this.imageWidget != null) {
            this.imageWidget.setPaintAsDisabled(bl);
        }
        if (this.commentWidget != null) {
            this.commentWidget.setPaintAsDisabled(bl);
        }
    }

    public final void setLabelForeground(Color color) {
        if (this.labelWidget != null) {
            this.labelWidget.setForeground(color);
        }
        if (this.commentWidget != null) {
            this.commentWidget.setForeground(color);
        }
    }

    public final void setLabelFont(Font font) {
        this.labelWidget.setFont(font);
    }

    public final void setLabelEditor(TextFieldInplaceEditor textFieldInplaceEditor) {
        if (this.editor != null) {
            throw new IllegalStateException("An editor is already specified.");
        }
        this.editor = textFieldInplaceEditor;
        this.getActions().addAction(ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)textFieldInplaceEditor));
    }

    public final boolean isEditable() {
        return this.editor != null && this.editor.isEnabled((Widget)this);
    }

    protected final LabelWidget getLabelWidget() {
        return this.labelWidget;
    }

    protected void notifyStateChanged(ObjectState objectState, ObjectState objectState2) {
        if (objectState.isFocused() != objectState2.isFocused()) {
            this.labelWidget.setBorder(objectState2.isFocused() ? BorderFactory.createDashedBorder((Color)this.getForeground(), (int)2, (int)2, (boolean)true) : BorderFactory.createEmptyBorder());
            this.revalidate(true);
        }
    }

    public static abstract class PaintableImageWidget
    extends Widget {
        private static final Stroke STROKE = new BasicStroke(1.0f, 2, 0);
        private Shape shape;

        public PaintableImageWidget(Scene scene, Color color, int n, int n2) {
            super(scene);
            this.setPreferredSize(new Dimension(n, n2));
            this.setForeground(color);
        }

        protected abstract Shape createImage(int var1, int var2);

        protected final Shape getImage() {
            if (this.shape == null) {
                this.shape = this.createImage(this.getBounds().width, this.getBounds().height);
            }
            return this.shape;
        }

        protected Stroke getImageStroke() {
            return STROKE;
        }

        protected void paintWidget() {
            Graphics2D graphics2D = this.getGraphics();
            Stroke stroke = graphics2D.getStroke();
            Paint paint = graphics2D.getPaint();
            graphics2D.setStroke(this.getImageStroke());
            graphics2D.setPaint(this.getForeground());
            graphics2D.draw(this.getImage());
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
        }
    }
}

