/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.design.view.widget;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.geom.GeneralPath;
import javax.swing.AbstractAction;
import javax.xml.soap.SOAPMessage;
import org.netbeans.api.visual.border.BorderFactory;
import org.netbeans.api.visual.layout.LayoutFactory;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.websvc.design.javamodel.MethodModel;
import org.netbeans.modules.websvc.design.javamodel.Utils;
import org.netbeans.modules.websvc.design.view.widget.AbstractTitledWidget;
import org.netbeans.modules.websvc.design.view.widget.ButtonWidget;
import org.netbeans.modules.websvc.design.view.widget.EditorPaneWidget;
import org.netbeans.modules.websvc.design.view.widget.ImageLabelWidget;
import org.openide.util.NbBundle;

public class SampleMessageWidget
extends AbstractTitledWidget {
    private static final Color INPUT_COLOR = new Color(128, 128, 255);
    private static final Color OUTPUT_COLOR = new Color(102, 204, 102);
    private transient Widget buttons;
    private transient ImageLabelWidget headerLabelWidget;
    private transient EditorPaneWidget paneWidget;
    private MethodModel operation;
    private Type type;

    public SampleMessageWidget(ObjectScene objectScene, MethodModel methodModel, Type type) {
        super(objectScene, 0, 12, 0, TITLE_COLOR);
        this.operation = methodModel;
        this.type = type;
        this.headerLabelWidget = new ImageLabelWidget((Scene)objectScene, null, methodModel.getOperationName() + ": ", type.getTitle());
        this.headerLabelWidget.setLabelFont(objectScene.getFont().deriveFont(1));
        this.headerLabelWidget.setPaintAsDisabled(false);
        this.headerLabelWidget.setLabelForeground(type.getBorderColor());
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)1);
        this.getHeaderWidget().addChild((Widget)this.headerLabelWidget);
        this.getHeaderWidget().addChild(new Widget(this.getScene()), (Object)1);
        this.buttons = new Widget(this.getScene());
        this.buttons.setLayout(LayoutFactory.createHorizontalFlowLayout((LayoutFactory.SerialAlignment)LayoutFactory.SerialAlignment.JUSTIFY, (int)8));
        this.getHeaderWidget().addChild(this.buttons);
        ButtonWidget buttonWidget = new ButtonWidget(this.getScene(), (String)null);
        buttonWidget.setImage(new ExpanderImageWidget((Scene)objectScene, type.getBorderColor(), 8));
        buttonWidget.setRoundedBorder(0, 4, 4, type.getBorderColor());
        buttonWidget.setAction(new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleMessageWidget.this.removeFromParent();
            }
        });
        this.buttons.addChild((Widget)buttonWidget);
        this.paneWidget = new EditorPaneWidget((Scene)objectScene, Utils.getFormatedDocument(type.getMessage(methodModel)), "text/xml");
        this.paneWidget.setEditable(false);
        this.getContentWidget().addChild((Widget)this.paneWidget);
        this.getContentWidget().setBorder(BorderFactory.createEmptyBorder((int)12, (int)6));
    }

    private static class ButtonImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        private boolean isInput;

        public ButtonImageWidget(Scene scene, int n, Color color, boolean bl) {
            super(scene, color, n, n);
            this.isInput = bl;
        }

        protected Shape createImage(int n, int n2) {
            GeneralPath generalPath = new GeneralPath();
            int n3 = n2 / 3;
            float f = this.isInput ? 0.0f : (float)n;
            float f2 = this.isInput ? (float)(3 * n / 4) : (float)(n / 4);
            float f3 = (n - n3) / 2;
            generalPath.moveTo(f, f3);
            generalPath.lineTo(n / 2, f3);
            generalPath.lineTo(n / 2, n2 / 2 - n3);
            generalPath.lineTo(f2, n2 / 2);
            generalPath.lineTo(n / 2, n2 / 2 + n3);
            generalPath.lineTo(n / 2, f3 + (float)n3);
            generalPath.lineTo(f, f3 + (float)n3);
            generalPath.closePath();
            generalPath.moveTo(n / 2, n2 / 8 - 1);
            generalPath.lineTo((float)n - f, n2 / 8 - 1);
            generalPath.moveTo(n / 2, 7 * n2 / 8 + 1);
            generalPath.lineTo((float)n - f, 7 * n2 / 8 + 1);
            generalPath.moveTo(f2, n2 / 4);
            generalPath.lineTo((float)n - f, n2 / 4);
            generalPath.moveTo(f2, 3 * n2 / 4);
            generalPath.lineTo((float)n - f, 3 * n2 / 4);
            generalPath.moveTo(this.isInput ? (float)(7 * n / 8) : (float)(n / 8), n2 / 2);
            generalPath.lineTo((float)n - f, n2 / 2);
            return generalPath;
        }

        protected void paintWidget() {
            Rectangle rectangle = this.getImage().getBounds();
            Graphics2D graphics2D = this.getGraphics();
            Paint paint = graphics2D.getPaint();
            graphics2D.setPaint(new GradientPaint(0.0f, rectangle.y + rectangle.height / 6, this.getForeground().brighter().brighter(), 0.0f, rectangle.y + rectangle.height / 2, this.getForeground().brighter(), true));
            graphics2D.fill(this.getImage());
            graphics2D.setPaint(paint);
            super.paintWidget();
        }
    }

    private static class ExpanderImageWidget
    extends ImageLabelWidget.PaintableImageWidget {
        private static final Stroke STROKE = new BasicStroke(2.5f, 2, 0);

        public ExpanderImageWidget(Scene scene, Color color, int n) {
            super(scene, color, n, n);
        }

        protected Stroke getImageStroke() {
            return STROKE;
        }

        protected Shape createImage(int n, int n2) {
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(n, n2);
            generalPath.moveTo(0.0f, n2);
            generalPath.lineTo(n, 0.0f);
            return generalPath;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        INPUT{

            public ButtonImageWidget getIcon(Scene scene) {
                return new ButtonImageWidget(scene, 16, this.getBorderColor(), true);
            }

            public String getDescription() {
                return NbBundle.getMessage(SampleMessageWidget.class, (String)"Hint_SampleInput");
            }

            String getTitle() {
                return NbBundle.getMessage(SampleMessageWidget.class, (String)"TITLE_SampleInput");
            }

            Color getBorderColor() {
                return INPUT_COLOR;
            }

            SOAPMessage getMessage(MethodModel methodModel) {
                return methodModel.getSoapRequest();
            }
        }
        ,
        OUTPUT{

            public ButtonImageWidget getIcon(Scene scene) {
                return new ButtonImageWidget(scene, 16, this.getBorderColor(), false);
            }

            public String getDescription() {
                return NbBundle.getMessage(SampleMessageWidget.class, (String)"Hint_SampleOutput");
            }

            String getTitle() {
                return NbBundle.getMessage(SampleMessageWidget.class, (String)"TITLE_SampleOutput");
            }

            Color getBorderColor() {
                return OUTPUT_COLOR;
            }

            SOAPMessage getMessage(MethodModel methodModel) {
                return methodModel.getSoapResponse();
            }
        };


        public abstract ButtonImageWidget getIcon(Scene var1);

        public abstract String getDescription();

        abstract String getTitle();

        abstract Color getBorderColor();

        abstract SOAPMessage getMessage(MethodModel var1);
    }
}

