/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.classpath;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.classpath.SourceRoots;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPlugin;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPluginSupport;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileUtil;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProjectClassPathImplementation
implements ClassPathImplementation,
PropertyChangeListener {
    private static final Logger LOGGER = Logger.getLogger(ProjectClassPathImplementation.class.getName());
    private final PropertyChangeSupport support = new PropertyChangeSupport(this);
    private List<PathResourceImplementation> resources;
    private final GrailsProjectConfig projectConfig;
    private final File projectRoot;
    private File pluginsDir;
    private File globalPluginsDir;
    private PluginsLibListener listenerPluginsLib;

    private ProjectClassPathImplementation(GrailsProjectConfig grailsProjectConfig) {
        this.projectConfig = grailsProjectConfig;
        this.projectRoot = FileUtil.toFile((FileObject)grailsProjectConfig.getProject().getProjectDirectory());
    }

    public static ProjectClassPathImplementation forProject(Project project) {
        GrailsProjectConfig grailsProjectConfig = GrailsProjectConfig.forProject((Project)project);
        ProjectClassPathImplementation projectClassPathImplementation = new ProjectClassPathImplementation(grailsProjectConfig);
        grailsProjectConfig.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)projectClassPathImplementation, (Object)grailsProjectConfig));
        return projectClassPathImplementation;
    }

    public synchronized List<PathResourceImplementation> getResources() {
        if (this.resources == null) {
            this.resources = this.getPath();
        }
        return this.resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("grails.project.plugins.dir".equals(propertyChangeEvent.getPropertyName())) {
            ProjectClassPathImplementation projectClassPathImplementation = this;
            synchronized (projectClassPathImplementation) {
                this.resources = null;
            }
            this.support.firePropertyChange("resources", null, null);
        }
    }

    private List<PathResourceImplementation> getPath() {
        Object object;
        Serializable serializable;
        Object object2;
        assert (Thread.holdsLock(this));
        ArrayList<PathResourceImplementation> arrayList = new ArrayList<PathResourceImplementation>();
        ProjectClassPathImplementation.addLibs(this.projectRoot, arrayList);
        File file = this.pluginsDir;
        File file2 = ((GrailsProject)this.projectConfig.getProject()).getBuildConfig().getProjectPluginsDir();
        if (this.pluginsDir == null || !this.pluginsDir.equals(file2)) {
            LOGGER.log(Level.FINE, "Project plugins dir changed from {0} to {1}", new Object[]{this.pluginsDir, file2});
            this.pluginsDir = file2;
        }
        if (this.pluginsDir.isDirectory()) {
            if (GrailsPlatform.Version.VERSION_1_1.compareTo(this.projectConfig.getGrailsPlatform().getVersion()) <= 0) {
                object2 = new GrailsPluginSupport((GrailsProject)this.projectConfig.getProject()).loadInstalledPlugins11();
                serializable = new HashSet();
                object = object2.iterator();
                while (object.hasNext()) {
                    GrailsPlugin grailsPlugin = (GrailsPlugin)object.next();
                    serializable.add(grailsPlugin.getDirName());
                }
                this.addPlugins(this.pluginsDir, arrayList, (Set<String>)((Object)serializable));
            } else {
                this.addPlugins(this.pluginsDir, arrayList, null);
            }
        }
        object2 = this.globalPluginsDir;
        serializable = ((GrailsProject)this.projectConfig.getProject()).getBuildConfig().getGlobalPluginsDir();
        if (this.globalPluginsDir == null || !this.globalPluginsDir.equals(serializable)) {
            LOGGER.log(Level.FINE, "Project plugins dir changed from {0} to {1}", new Object[]{this.pluginsDir, file2});
            this.globalPluginsDir = serializable;
        }
        if (this.globalPluginsDir != null && this.globalPluginsDir.isDirectory()) {
            this.addPlugins(this.globalPluginsDir, arrayList, null);
        }
        if (this.listenerPluginsLib == null) {
            object = FileUtil.normalizeFile((File)new File(this.projectRoot, "lib"));
            this.listenerPluginsLib = new PluginsLibListener(this);
            FileUtil.addFileChangeListener((FileChangeListener)this.listenerPluginsLib, (File)object);
        }
        this.updateListener(this.listenerPluginsLib, file, file2);
        this.updateListener(this.listenerPluginsLib, (File)object2, (File)serializable);
        return Collections.unmodifiableList(arrayList);
    }

    private void updateListener(FileChangeListener fileChangeListener, File file, File file2) {
        if (file == null || !file.equals(file2)) {
            if (file != null) {
                FileUtil.removeFileChangeListener((FileChangeListener)fileChangeListener, (File)file);
            }
            if (file2 != null) {
                FileUtil.addFileChangeListener((FileChangeListener)fileChangeListener, (File)file2);
            }
        }
    }

    private void addPlugins(File file, List<PathResourceImplementation> list, Set<String> set) {
        for (String string : file.list()) {
            File file2 = new File(file, string);
            if (!file2.isDirectory() || set != null && !set.contains(string)) continue;
            ProjectClassPathImplementation.addLibs(file2, list);
            ProjectClassPathImplementation.addSources(file2, list);
        }
    }

    private static void addLibs(File file, List<PathResourceImplementation> list) {
        File[] fileArray = new File(file, "lib").listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                try {
                    URL uRL;
                    if (!file2.isFile() || !FileUtil.isArchiveFile((URL)(uRL = file2.toURI().toURL()))) continue;
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                    list.add(ClassPathSupport.createResource((URL)uRL));
                }
                catch (MalformedURLException malformedURLException) {
                    assert (false) : malformedURLException;
                }
            }
        }
    }

    private static void addSources(File file, List<PathResourceImplementation> list) {
        SourceRoots sourceRoots = new SourceRoots(null, FileUtil.toFileObject((File)file));
        for (URL uRL : sourceRoots.getRootURLs()) {
            list.add(ClassPathSupport.createResource((URL)uRL));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    private static class PluginsLibListener
    implements FileChangeListener {
        private final ProjectClassPathImplementation impl;

        public PluginsLibListener(ProjectClassPathImplementation projectClassPathImplementation) {
            this.impl = projectClassPathImplementation;
        }

        public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
            this.fireChange();
        }

        public void fileChanged(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileDataCreated(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileDeleted(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileFolderCreated(FileEvent fileEvent) {
            this.fireChange();
        }

        public void fileRenamed(FileRenameEvent fileRenameEvent) {
            this.fireChange();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ProjectClassPathImplementation projectClassPathImplementation = this.impl;
            synchronized (projectClassPathImplementation) {
                this.impl.resources = null;
            }
            this.impl.support.firePropertyChange("resources", null, null);
        }
    }
}

