/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.config;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.api.GrailsPlatform;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.netbeans.modules.groovy.grailsproject.plugins.GrailsPlugin;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildConfig {
    private static final Logger LOGGER = Logger.getLogger(BuildConfig.class.getName());
    private final GrailsProject project;
    private Object buildSettingsInstance;
    private File projectRoot;
    private List<GrailsPlugin> localPlugins;
    private File projectPluginsDir;
    private File globalPluginsDir;

    public BuildConfig(GrailsProject grailsProject) {
        this.project = grailsProject;
        this.projectRoot = FileUtil.toFile((FileObject)grailsProject.getProjectDirectory());
        this.loadLocalPluginsDefault();
        this.loadProjectPluginsDirDefault();
        this.loadGlobalPluginsDirDefault();
    }

    private boolean isFilePresent() {
        FileObject fileObject = this.project.getProjectDirectory();
        return fileObject.getFileObject("grails-app/conf/BuildConfig.groovy") != null;
    }

    private synchronized void loadProjectPluginsDirDefault() {
        GrailsProjectConfig grailsProjectConfig;
        File file;
        this.projectPluginsDir = GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0 ? ((file = (grailsProjectConfig = GrailsProjectConfig.forProject((Project)this.project)).getProjectPluginsDir()) != null && this.isFilePresent() ? file : this.getProjectPluginsDirDefault11()) : this.getProjectPluginsDir10();
    }

    private File getProjectPluginsDirDefault11() {
        File file;
        GrailsPlatform grailsPlatform = GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform();
        String string = System.getProperty("grails.project.plugins.dir");
        if (string == null) {
            File file2;
            String string2 = System.getProperty("grails.project.work.dir");
            if (string2 == null) {
                File file3;
                String string3 = System.getProperty("grails.work.dir");
                if (string3 == null) {
                    string3 = System.getProperty("user.home");
                    string3 = string3 + File.separator + ".grails" + File.separator + grailsPlatform.getVersion();
                    file3 = new File(string3);
                } else {
                    file3 = new File(string3);
                    if (!file3.isAbsolute()) {
                        file3 = new File(this.projectRoot, string3);
                    }
                }
                file2 = new File(file3, "projects" + File.separator + this.projectRoot.getName());
            } else {
                file2 = new File(string2);
                if (!file2.isAbsolute()) {
                    file2 = new File(this.projectRoot, string2);
                }
            }
            file = new File(file2, "plugins");
        } else {
            file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(this.projectRoot, string);
            }
        }
        return file;
    }

    private synchronized void loadGlobalPluginsDirDefault() {
        GrailsProjectConfig grailsProjectConfig;
        File file;
        this.globalPluginsDir = GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0 ? ((file = (grailsProjectConfig = GrailsProjectConfig.forProject((Project)this.project)).getGlobalPluginsDir()) != null && this.isFilePresent() ? file : this.getGlobalPluginsDirDefault11()) : this.getGlobalPluginsDir10();
    }

    private File getGlobalPluginsDirDefault11() {
        File file;
        GrailsPlatform grailsPlatform = GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform();
        String string = System.getProperty("grails.global.plugins.dir");
        if (string == null) {
            File file2;
            String string2 = System.getProperty("grails.work.dir");
            if (string2 == null) {
                string2 = System.getProperty("user.home");
                string2 = string2 + File.separator + ".grails" + File.separator + grailsPlatform.getVersion();
                file2 = new File(string2);
            } else {
                file2 = new File(string2);
                if (!file2.isAbsolute()) {
                    file2 = new File(this.projectRoot, string2);
                }
            }
            file = new File(file2, "global-plugins");
        } else {
            file = new File(string);
            if (!file.isAbsolute()) {
                file = new File(this.projectRoot, string);
            }
        }
        return file;
    }

    private synchronized void loadLocalPluginsDefault() {
        if (GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0) {
            // empty if block
        }
        this.localPlugins = Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        File file;
        File file2;
        long l = System.currentTimeMillis();
        BuildConfig buildConfig = this;
        synchronized (buildConfig) {
            File file3 = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
            assert (file3 != null);
            if (!file3.equals(this.projectRoot)) {
                this.projectRoot = file3;
            }
            this.buildSettingsInstance = this.loadBuildSettings();
            LOGGER.log(Level.FINE, "Took {0} ms to load BuildSettings for {1}", new Object[]{System.currentTimeMillis() - l, this.project.getProjectDirectory().getNameExt()});
            this.loadLocalPlugins();
            file2 = this.loadProjectPluginsDir();
            file = this.loadGlobalPluginsDir();
        }
        if (GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0 && (buildConfig = (GrailsProjectConfig)this.project.getLookup().lookup(GrailsProjectConfig.class)) != null) {
            buildConfig.setProjectPluginsDir(FileUtil.normalizeFile((File)file2));
            buildConfig.setGlobalPluginsDir(FileUtil.normalizeFile((File)file));
        }
    }

    public synchronized File getProjectPluginsDir() {
        return this.projectPluginsDir;
    }

    private synchronized File loadProjectPluginsDir() {
        this.projectPluginsDir = GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0 ? this.getProjectPluginsDir11() : this.getProjectPluginsDir10();
        return this.projectPluginsDir;
    }

    private File getProjectPluginsDir10() {
        assert (Thread.holdsLock(this));
        return new File(this.projectRoot, "plugins");
    }

    private File getProjectPluginsDir11() {
        Object object;
        Object object2;
        assert (Thread.holdsLock(this));
        try {
            if (this.buildSettingsInstance != null && (object2 = ((Method)(object = this.buildSettingsInstance.getClass().getMethod("getProjectPluginsDir", new Class[0]))).invoke(this.buildSettingsInstance, new Object[0])) instanceof File) {
                File file = (File)object2;
                if (!file.isAbsolute()) {
                    file = new File(this.projectRoot, file.getPath());
                }
                return file;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.log(Level.FINE, null, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.log(Level.FINE, null, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.log(Level.FINE, null, invocationTargetException);
        }
        object = GrailsProjectConfig.forProject((Project)this.project);
        object2 = object.getGrailsPlatform();
        if (object2.isConfigured()) {
            return new File(System.getProperty("user.home"), ".grails" + File.separator + object.getGrailsPlatform().getVersion().toString() + File.separator + "projects" + File.separator + this.projectRoot.getName() + File.separator + "plugins");
        }
        return null;
    }

    public synchronized File getGlobalPluginsDir() {
        return this.globalPluginsDir;
    }

    private synchronized File loadGlobalPluginsDir() {
        this.globalPluginsDir = GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0 ? this.getGlobalPluginsDir11() : this.getGlobalPluginsDir10();
        return this.globalPluginsDir;
    }

    private File getGlobalPluginsDir10() {
        assert (Thread.holdsLock(this));
        return null;
    }

    private File getGlobalPluginsDir11() {
        Object object;
        Object object2;
        assert (Thread.holdsLock(this));
        try {
            if (this.buildSettingsInstance != null && (object2 = ((Method)(object = this.buildSettingsInstance.getClass().getMethod("getGlobalPluginsDir", new Class[0]))).invoke(this.buildSettingsInstance, new Object[0])) instanceof File) {
                File file = (File)object2;
                if (!file.isAbsolute()) {
                    file = new File(this.projectRoot, file.getPath());
                }
                return file;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.log(Level.FINE, null, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.log(Level.FINE, null, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.log(Level.FINE, null, invocationTargetException);
        }
        object = GrailsProjectConfig.forProject((Project)this.project);
        object2 = object.getGrailsPlatform();
        if (object2.isConfigured()) {
            return new File(System.getProperty("user.home"), ".grails" + File.separator + object.getGrailsPlatform().getVersion().toString() + File.separator + "global-plugins");
        }
        return null;
    }

    public synchronized List<GrailsPlugin> getLocalPlugins() {
        return Collections.unmodifiableList(this.localPlugins);
    }

    private synchronized void loadLocalPlugins() {
        this.localPlugins = GrailsPlatform.Version.VERSION_1_1.compareTo(GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform().getVersion()) <= 0 ? this.getLocalPlugins11() : this.getLocalPlugins10();
    }

    private List<GrailsPlugin> getLocalPlugins10() {
        assert (Thread.holdsLock(this));
        return Collections.emptyList();
    }

    private List<GrailsPlugin> getLocalPlugins11() {
        assert (Thread.holdsLock(this));
        try {
            Method method;
            Object object;
            Method method2;
            Object object2;
            if (this.buildSettingsInstance != null && (object2 = (method2 = (object = (method = this.buildSettingsInstance.getClass().getMethod("getConfig", new Class[0])).invoke(this.buildSettingsInstance, new Object[0])).getClass().getMethod("toProperties", new Class[0])).invoke(object, new Object[0])) instanceof Properties) {
                Properties properties = (Properties)object2;
                ArrayList<GrailsPlugin> arrayList = new ArrayList<GrailsPlugin>();
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (!string.startsWith("grails.plugin.location.")) continue;
                    String string2 = properties.getProperty(string);
                    string = string.substring("grails.plugin.location.".length());
                    arrayList.add(new GrailsPlugin(string, null, null, string2));
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.log(Level.FINE, null, noSuchMethodException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.log(Level.FINE, null, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.log(Level.FINE, null, invocationTargetException);
        }
        return Collections.emptyList();
    }

    private Object loadBuildSettings() {
        assert (Thread.holdsLock(this));
        GrailsPlatform grailsPlatform = GrailsProjectConfig.forProject((Project)this.project).getGrailsPlatform();
        if (!grailsPlatform.isConfigured()) {
            return null;
        }
        ClassLoader classLoader = grailsPlatform.getClassPath().getClassLoader(true);
        URLClassLoader uRLClassLoader = classLoader instanceof URLClassLoader ? (URLClassLoader)classLoader : new URLClassLoader(new URL[0], classLoader);
        try {
            Class<?> clazz = uRLClassLoader.loadClass("grails.util.BuildSettings");
            Constructor<?> constructor = clazz.getConstructor(File.class, File.class);
            Object obj = constructor.newInstance(grailsPlatform.getGrailsHome(), this.projectRoot);
            Method method = clazz.getMethod("setRootLoader", URLClassLoader.class);
            method.invoke(obj, uRLClassLoader);
            Method method2 = clazz.getMethod("loadConfig", new Class[0]);
            method2.invoke(obj, new Object[0]);
            return obj;
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.log(Level.FINE, null, classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LOGGER.log(Level.FINE, null, noSuchMethodException);
        }
        catch (InstantiationException instantiationException) {
            LOGGER.log(Level.FINE, null, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LOGGER.log(Level.FINE, null, illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LOGGER.log(Level.FINE, null, invocationTargetException);
        }
        return null;
    }

    public File getProjectPluginsDirDefault(GrailsPlatform grailsPlatform) {
        if (GrailsPlatform.Version.VERSION_1_1.compareTo(grailsPlatform.getVersion()) <= 0) {
            File file;
            String string = System.getProperty("grails.project.plugins.dir");
            if (string == null) {
                File file2;
                String string2 = System.getProperty("grails.project.work.dir");
                if (string2 == null) {
                    File file3;
                    String string3 = System.getProperty("grails.work.dir");
                    if (string3 == null) {
                        string3 = System.getProperty("user.home");
                        string3 = string3 + File.separator + ".grails" + File.separator + grailsPlatform.getVersion();
                        file3 = new File(string3);
                    } else {
                        file3 = new File(string3);
                        if (!file3.isAbsolute()) {
                            file3 = new File(this.projectRoot, string3);
                        }
                    }
                    file2 = new File(file3, "projects" + File.separator + this.projectRoot.getName());
                } else {
                    file2 = new File(string2);
                    if (!file2.isAbsolute()) {
                        file2 = new File(this.projectRoot, string2);
                    }
                }
                file = new File(file2, "plugins");
            } else {
                file = new File(string);
                if (!file.isAbsolute()) {
                    file = new File(this.projectRoot, string);
                }
            }
            return file;
        }
        return new File(this.projectRoot, "plugins");
    }
}

