/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.util;

import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.prefs.Preferences;
import org.openide.util.Utilities;

public class DialogBoundsPreserver
implements WindowListener {
    private static final String DELIMITER = "#";
    private Preferences preferences;
    private String key;

    public DialogBoundsPreserver(Preferences preferences, String string) {
        this.preferences = preferences;
        this.key = string;
    }

    public void windowOpened(WindowEvent windowEvent) {
        Rectangle rectangle = this.getDialogBounds();
        if (rectangle != null && this.checkBounds(rectangle)) {
            windowEvent.getWindow().setBounds(rectangle);
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
        Rectangle rectangle = windowEvent.getWindow().getBounds();
        if (this.checkBounds(rectangle)) {
            this.setDialogBounds(rectangle);
        }
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    private boolean checkBounds(Rectangle rectangle) {
        Rectangle rectangle2 = Utilities.getUsableScreenBounds();
        return rectangle.getX() >= 0.0 && rectangle.getX() < rectangle2.getWidth() && rectangle.getY() >= 0.0 && rectangle.getY() < rectangle2.getHeight() && rectangle.getWidth() <= rectangle2.getWidth() - rectangle.getX() && rectangle.getHeight() <= rectangle2.getHeight() - rectangle.getY();
    }

    private void setDialogBounds(Rectangle rectangle) {
        this.preferences.put(this.key, rectangle.getX() + DELIMITER + rectangle.getY() + DELIMITER + rectangle.getWidth() + DELIMITER + rectangle.getHeight());
    }

    private Rectangle getDialogBounds() {
        String string = this.preferences.get(this.key, DELIMITER);
        if (string != null) {
            String[] stringArray = string.split(DELIMITER);
            if (stringArray.length != 4 || stringArray[0].trim().equals("") || stringArray[1].trim().equals("") || stringArray[2].trim().equals("") || stringArray[3].trim().equals("")) {
                return null;
            }
            Rectangle rectangle = new Rectangle();
            rectangle.setRect(Double.parseDouble(stringArray[0]), Double.parseDouble(stringArray[1]), Double.parseDouble(stringArray[2]), Double.parseDouble(stringArray[3]));
            return rectangle;
        }
        return null;
    }
}

