/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.editors;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyEditorSupport;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.modules.form.NamedPropertyEditor;
import org.openide.awt.Mnemonics;
import org.openide.explorer.propertysheet.editors.XMLPropertyEditor;
import org.openide.util.NbBundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class KeyStrokeEditor
extends PropertyEditorSupport
implements XMLPropertyEditor,
NamedPropertyEditor {
    private String TXT_CTRL;
    private String TXT_ALT;
    private String TXT_SHIFT;
    private String TXT_META;
    public static final String XML_KEYSTROKE = "KeyStroke";
    public static final String ATTR_KEY = "key";
    private static String[] _virtualKeys;

    public KeyStrokeEditor() {
        ResourceBundle resourceBundle = NbBundle.getBundle(KeyStrokeEditor.class);
        this.TXT_CTRL = resourceBundle.getString("CTL_CtrlAsText");
        this.TXT_SHIFT = resourceBundle.getString("CTL_ShiftAsText");
        this.TXT_ALT = resourceBundle.getString("CTL_AltAsText");
        this.TXT_META = resourceBundle.getString("CTL_MetaAsText");
    }

    public String getJavaInitializationString() {
        KeyStroke keyStroke = (KeyStroke)this.getValue();
        int n = keyStroke.getModifiers();
        StringBuffer stringBuffer = new StringBuffer();
        if (0 != (n & 0xF)) {
            if (0 != (n & 8)) {
                stringBuffer.append("java.awt.event.InputEvent.ALT_MASK");
            }
            if (0 != (n & 1)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" | ");
                }
                stringBuffer.append("java.awt.event.InputEvent.SHIFT_MASK");
            }
            if (0 != (n & 2)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" | ");
                }
                stringBuffer.append("java.awt.event.InputEvent.CTRL_MASK");
            }
            if (0 != (n & 4)) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(" | ");
                }
                stringBuffer.append("java.awt.event.InputEvent.META_MASK");
            }
        } else {
            stringBuffer.append("0");
        }
        return "javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent." + KeyStrokeEditor.getVirtualkeyName(keyStroke.getKeyCode()) + ", " + stringBuffer.toString() + ")";
    }

    public String getAsText() {
        KeyStroke keyStroke = (KeyStroke)this.getValue();
        return keyStroke != null ? this.keyStrokeAsString(keyStroke, true) : "null";
    }

    public void setAsText(String string) throws IllegalArgumentException {
        if (string == null || "".equals(string) || "null".equals(string)) {
            this.setValue(null);
            return;
        }
        KeyStroke keyStroke = this.keyStrokeFromString(string, true);
        if (keyStroke == null) {
            throw new IllegalArgumentException("Unrecognized key: " + string);
        }
        this.setValue(keyStroke);
    }

    private static String getVirtualkeyName(int n) {
        Field[] fieldArray = KeyEvent.class.getDeclaredFields();
        for (int i = 0; i < fieldArray.length; ++i) {
            Field field = fieldArray[i];
            int n2 = field.getModifiers();
            if (!Modifier.isPublic(n2) || !Modifier.isStatic(n2) || !Modifier.isFinal(n2) || field.getType() != Integer.TYPE || !field.getName().startsWith("VK_")) continue;
            try {
                if (field.getInt(KeyEvent.class) != n) continue;
                return field.getName();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return null;
    }

    private KeyStroke keyStrokeFromString(String string, boolean bl) {
        String string2;
        String string3;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "+");
        int n = 0;
        int n2 = 0;
        String string4 = bl ? this.TXT_ALT : "Alt";
        String string5 = bl ? this.TXT_SHIFT : "Shift";
        String string6 = bl ? this.TXT_CTRL : "Ctrl";
        String string7 = string3 = bl ? this.TXT_META : "Meta";
        while (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken()) != null) {
            if (string4.equalsIgnoreCase(string2)) {
                n |= 8;
                continue;
            }
            if (string5.equalsIgnoreCase(string2)) {
                n |= 1;
                continue;
            }
            if (string6.equalsIgnoreCase(string2)) {
                n |= 2;
                continue;
            }
            if (string3.equalsIgnoreCase(string2)) {
                n |= 4;
                continue;
            }
            String string8 = "VK_" + string2.toUpperCase();
            try {
                n2 = KeyEvent.class.getField(string8).getInt(KeyEvent.class);
            }
            catch (Exception exception) {}
        }
        if (n2 != 0) {
            return KeyStroke.getKeyStroke(n2, n);
        }
        return null;
    }

    private String keyStrokeAsString(KeyStroke keyStroke, boolean bl) {
        String string = bl ? this.TXT_ALT : "Alt";
        String string2 = bl ? this.TXT_SHIFT : "Shift";
        String string3 = bl ? this.TXT_CTRL : "Ctrl";
        String string4 = bl ? this.TXT_META : "Meta";
        StringBuffer stringBuffer = new StringBuffer();
        int n = keyStroke.getModifiers();
        int[] nArray = new int[]{1, 2, 8, 4};
        String[] stringArray = new String[]{string2, string3, string, string4};
        for (int i = 0; i < nArray.length; ++i) {
            if ((n & nArray[i]) == 0) continue;
            stringBuffer.append(stringArray[i]);
            stringBuffer.append("+");
        }
        String string5 = KeyStrokeEditor.getVirtualkeyName(keyStroke.getKeyCode());
        if (string5 != null) {
            stringBuffer.append(string5.substring(3));
        }
        return stringBuffer.toString();
    }

    public void readFromXML(Node node) throws IOException {
        if (!XML_KEYSTROKE.equals(node.getNodeName())) {
            throw new IOException();
        }
        NamedNodeMap namedNodeMap = node.getAttributes();
        try {
            String string = namedNodeMap.getNamedItem(ATTR_KEY).getNodeValue();
            KeyStroke keyStroke = this.keyStrokeFromString(string, false);
            if (keyStroke == null) {
                throw new IllegalArgumentException();
            }
            this.setValue(keyStroke);
        }
        catch (Exception exception) {
            throw new IOException();
        }
    }

    public Node storeToXML(Document document) {
        KeyStroke keyStroke = (KeyStroke)this.getValue();
        String string = keyStroke != null ? this.keyStrokeAsString(keyStroke, false) : "null";
        Element element = document.createElement(XML_KEYSTROKE);
        element.setAttribute(ATTR_KEY, string);
        return element;
    }

    public boolean supportsCustomEditor() {
        return true;
    }

    public Component getCustomEditor() {
        return new CustomEditor();
    }

    public String getDisplayName() {
        return NbBundle.getBundle(this.getClass()).getString("CTL_KeyStrokeEditor_DisplayName");
    }

    static /* synthetic */ String[] access$202(String[] stringArray) {
        _virtualKeys = stringArray;
        return stringArray;
    }

    private class CustomEditor
    extends JPanel {
        private KeyGrabberField _keyGrabber;
        private JCheckBox _ctrl;
        private JCheckBox _alt;
        private JCheckBox _shift;
        private JCheckBox _meta;
        private JComboBox _virtualKey;

        CustomEditor() {
            Object object;
            this.setLayout(new GridBagLayout());
            ResourceBundle resourceBundle = NbBundle.getBundle(KeyStrokeEditor.class);
            JLabel jLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel, (String)resourceBundle.getString("CTL_VirtualKey"));
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(12, 12, 5, 12);
            this.add((Component)jLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(12, 0, 5, 11);
            this._virtualKey = new JComboBox();
            this.add(this._virtualKey, gridBagConstraints);
            this._virtualKey.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_VirtualKey"));
            JPanel jPanel = new JPanel(new FlowLayout(0, 6, 0));
            this._ctrl = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this._ctrl, (String)resourceBundle.getString("CTL_Ctrl"));
            this._ctrl.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_CtrlKey"));
            jPanel.add(this._ctrl);
            this._alt = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this._alt, (String)resourceBundle.getString("CTL_Alt"));
            this._alt.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_AltKey"));
            jPanel.add(this._alt);
            this._shift = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this._shift, (String)resourceBundle.getString("CTL_Shift"));
            this._shift.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_ShiftKey"));
            jPanel.add(this._shift);
            this._meta = new JCheckBox();
            Mnemonics.setLocalizedText((AbstractButton)this._meta, (String)resourceBundle.getString("CTL_Meta"));
            this._meta.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_MetaKey"));
            jPanel.add(this._meta);
            jLabel.setLabelFor(this._virtualKey);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(12, 0, 5, 12);
            this.add((Component)jPanel, gridBagConstraints);
            JLabel jLabel2 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)jLabel2, (String)resourceBundle.getString("CTL_KeyStroke"));
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 12, 0, 12);
            this.add((Component)jLabel2, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 11);
            this._keyGrabber = new KeyGrabberField();
            this.add((Component)this._keyGrabber, gridBagConstraints);
            this._keyGrabber.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_KeyStroke"));
            jLabel2.setLabelFor(this._keyGrabber);
            this._keyGrabber.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    KeyStrokeEditor.this.setAsText(CustomEditor.this._keyGrabber.getText());
                }
            });
            this.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_KeyStrokeCustomEditor"));
            if (_virtualKeys == null) {
                int n;
                ArrayList<String> arrayList = new ArrayList<String>();
                object = KeyEvent.class.getDeclaredFields();
                for (n = 0; n < ((Field[])object).length; ++n) {
                    Field field = object[n];
                    int n2 = field.getModifiers();
                    if (!Modifier.isPublic(n2) || !Modifier.isStatic(n2) || !Modifier.isFinal(n2) || field.getType() != Integer.TYPE || !field.getName().startsWith("VK_")) continue;
                    arrayList.add(field.getName());
                }
                KeyStrokeEditor.access$202(new String[arrayList.size()]);
                for (n = 0; n < arrayList.size(); ++n) {
                    _virtualKeys[n] = (String)arrayList.get(n);
                }
            }
            this._virtualKey.addItem("");
            for (int i = 0; i < _virtualKeys.length; ++i) {
                this._virtualKey.addItem(_virtualKeys[i]);
            }
            KeyStroke keyStroke = (KeyStroke)KeyStrokeEditor.this.getValue();
            if (keyStroke != null) {
                this.setKeyStroke(keyStroke);
            }
            object = new ItemListener(){

                public void itemStateChanged(ItemEvent itemEvent) {
                    CustomEditor.this.virtualKeyChanged();
                }
            };
            this._virtualKey.addItemListener((ItemListener)object);
            this._ctrl.addItemListener((ItemListener)object);
            this._alt.addItemListener((ItemListener)object);
            this._shift.addItemListener((ItemListener)object);
            this._meta.addItemListener((ItemListener)object);
        }

        Component getKeyGrabber() {
            return this._keyGrabber;
        }

        private void setKeyStroke(KeyStroke keyStroke) {
            this._ctrl.setSelected(0 != (2 & keyStroke.getModifiers()));
            this._alt.setSelected(0 != (8 & keyStroke.getModifiers()));
            this._shift.setSelected(0 != (1 & keyStroke.getModifiers()));
            this._meta.setSelected(0 != (4 & keyStroke.getModifiers()));
            int n = keyStroke.getKeyCode();
            String string = KeyStrokeEditor.getVirtualkeyName(n);
            if (string != null) {
                this._virtualKey.setSelectedItem(string);
                this._keyGrabber.setText(KeyStrokeEditor.this.getAsText());
            }
        }

        private void virtualKeyChanged() {
            String string = (String)this._virtualKey.getSelectedItem();
            if ("".equals(string)) {
                this._keyGrabber.setText("");
                KeyStrokeEditor.this.setValue(null);
                return;
            }
            try {
                Field field = KeyEvent.class.getDeclaredField(string);
                int n = field.getInt(KeyEvent.class);
                int n2 = 0;
                if (this._ctrl.isSelected()) {
                    n2 |= 2;
                }
                if (this._shift.isSelected()) {
                    n2 |= 1;
                }
                if (this._alt.isSelected()) {
                    n2 |= 8;
                }
                if (this._meta.isSelected()) {
                    n2 |= 4;
                }
                KeyStrokeEditor.this.setValue(KeyStroke.getKeyStroke(n, n2));
                this._keyGrabber.setText(KeyStrokeEditor.this.getAsText());
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }

        private class KeyGrabberField
        extends JTextField {
            private KeyGrabberField() {
            }

            protected void processKeyEvent(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 9) {
                    super.processKeyEvent(keyEvent);
                } else if (keyEvent.getID() == 401) {
                    int n = keyEvent.getKeyCode();
                    if (n != 17 && n != 18 && n != 16 && n != 157) {
                        KeyStroke keyStroke = KeyStroke.getKeyStroke(n, keyEvent.getModifiers());
                        CustomEditor.this.setKeyStroke(keyStroke);
                    }
                    keyEvent.consume();
                }
            }
        }
    }
}

