/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign.support;

import java.awt.Dimension;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;
import org.netbeans.modules.form.layoutdesign.LayoutConstants;
import org.netbeans.modules.form.layoutdesign.LayoutInterval;
import org.netbeans.modules.form.layoutdesign.LayoutModel;
import org.netbeans.modules.form.layoutdesign.support.SwingLayoutUtils;

public class SwingLayoutCodeGenerator {
    private static final String LAYOUT_VAR_NAME = "layout";
    private LayoutModel layoutModel;
    private String layoutVarName;
    private boolean useLayoutLibrary;
    private Map<String, ComponentInfo> componentIDMap = new HashMap<String, ComponentInfo>();

    public SwingLayoutCodeGenerator(LayoutModel layoutModel) {
        this.layoutModel = layoutModel;
    }

    public void generateContainerLayout(Writer writer, LayoutComponent layoutComponent, String string, String string2, ComponentInfo[] componentInfoArray, boolean bl) throws IOException {
        int n;
        LayoutInterval[][] layoutIntervalArray;
        this.useLayoutLibrary = bl;
        this.layoutVarName = string2 == null ? LAYOUT_VAR_NAME : string2 + Character.toUpperCase(LAYOUT_VAR_NAME.charAt(0)) + LAYOUT_VAR_NAME.substring(1);
        this.fillMap(componentInfoArray);
        this.generateInstantiation(writer, string);
        int n2 = layoutComponent.getLayoutRootCount();
        if (n2 > 1) {
            layoutIntervalArray = new LayoutInterval[2][n2 - 1];
            for (n = 1; n < n2; ++n) {
                for (int i = 0; i < 2; ++i) {
                    layoutIntervalArray[i][n - 1] = layoutComponent.getLayoutRoot(n, i);
                    assert (layoutIntervalArray[i][n - 1].isParallel());
                }
            }
        } else {
            layoutIntervalArray = null;
        }
        for (n = 0; n < 2; ++n) {
            StringBuilder stringBuilder = new StringBuilder();
            this.composeGroup(stringBuilder, layoutComponent.getLayoutRoot(0, n), layoutIntervalArray != null ? layoutIntervalArray[n] : null, true, true);
            writer.write(this.layoutVarName + (n == 0 ? ".setHorizontalGroup(\n" : ".setVerticalGroup(\n") + stringBuilder.toString() + "\n);\n");
            stringBuilder = new StringBuilder();
            this.composeLinks(stringBuilder, layoutComponent, this.layoutVarName, n);
            writer.write(stringBuilder.toString());
        }
    }

    private void fillMap(ComponentInfo[] componentInfoArray) {
        for (int i = 0; i < componentInfoArray.length; ++i) {
            this.componentIDMap.put(componentInfoArray[i].id, componentInfoArray[i]);
        }
    }

    private void generateInstantiation(Writer writer, String string) throws IOException {
        writer.write(this.getLayoutName() + " " + this.layoutVarName + " ");
        writer.write("= new " + this.getLayoutName() + "(" + string + ");\n");
        writer.write(string + ".setLayout(" + this.layoutVarName + ");\n");
    }

    private void composeGroup(StringBuilder stringBuilder, LayoutInterval layoutInterval, LayoutInterval[] layoutIntervalArray, boolean bl, boolean bl2) throws IOException {
        int n = layoutInterval.getGroupAlignment();
        if (layoutInterval.isParallel()) {
            boolean bl3 = layoutInterval.getMaximumSize(false) == -2;
            String object = this.convertAlignment(n);
            stringBuilder.append(this.layoutVarName).append(".createParallelGroup(");
            stringBuilder.append(object);
            if (bl3) {
                stringBuilder.append(", false");
            }
            stringBuilder.append(")");
        } else {
            stringBuilder.append(this.layoutVarName).append(".createSequentialGroup()");
        }
        Iterator<LayoutInterval> iterator = layoutInterval.getSubIntervals();
        while (iterator.hasNext()) {
            stringBuilder.append("\n");
            LayoutInterval layoutInterval2 = iterator.next();
            this.fillGroup(stringBuilder, layoutInterval2, bl, bl2 && (!layoutInterval.isSequential() || !iterator.hasNext() && layoutIntervalArray == null), n);
            if (!bl || !layoutInterval.isSequential()) continue;
            bl = false;
        }
        if (layoutIntervalArray != null) {
            for (LayoutInterval layoutInterval3 : layoutIntervalArray) {
                stringBuilder.append("\n");
                this.fillGroup(stringBuilder, layoutInterval3, bl, bl2, n);
            }
        }
    }

    private void fillGroup(StringBuilder stringBuilder, LayoutInterval layoutInterval, boolean bl, boolean bl2, int n) throws IOException {
        if (layoutInterval.isGroup()) {
            stringBuilder.append(this.getAddGroupStr());
            int n2 = layoutInterval.getAlignment();
            if (n2 != -1 && layoutInterval.getParent().isParallel() && n2 != n && n2 != 3 && n != 3) {
                String string = this.convertAlignment(n2);
                stringBuilder.append(string).append(", ");
            }
            this.composeGroup(stringBuilder, layoutInterval, null, bl, bl2);
        } else {
            int n3 = layoutInterval.getMinimumSize(false);
            int n4 = layoutInterval.getPreferredSize(false);
            int n5 = layoutInterval.getMaximumSize(false);
            if (layoutInterval.isComponent()) {
                int n6;
                stringBuilder.append(this.getAddComponentStr());
                int n7 = layoutInterval.getAlignment();
                LayoutComponent layoutComponent = layoutInterval.getComponent();
                ComponentInfo componentInfo = this.componentIDMap.get(layoutComponent.getId());
                if (n3 == -1) {
                    int n8 = n6 = layoutComponent.getLayoutInterval(0) == layoutInterval ? 0 : 1;
                    if (n6 == 0 && componentInfo.clazz.getName().equals("javax.swing.JComboBox")) {
                        n3 = 0;
                    } else if (n4 >= 0) {
                        int n9;
                        int n10 = n9 = n6 == 0 ? componentInfo.minSize.width : componentInfo.minSize.height;
                        if (n9 > n4) {
                            n3 = -2;
                        }
                    }
                }
                assert (componentInfo.variableName != null);
                if (layoutInterval.getParent().isSequential() || n7 == -1 || n7 == n || n7 == 3 || n == 3) {
                    stringBuilder.append(componentInfo.variableName);
                } else {
                    String string = this.convertAlignment(n7);
                    if (this.useLayoutLibrary()) {
                        stringBuilder.append(string).append(", ").append(componentInfo.variableName);
                    } else {
                        stringBuilder.append(componentInfo.variableName).append(", ").append(string);
                    }
                }
                n6 = SwingLayoutUtils.getResizableStatus(componentInfo.clazz);
                if (n4 != -1 || n3 != -1 && (n3 != -2 || componentInfo.sizingChanged || n6 != 0) || n5 != -1 && (n5 != -2 || componentInfo.sizingChanged || n6 != 0) && (n5 != Short.MAX_VALUE || componentInfo.sizingChanged || n6 != 1)) {
                    stringBuilder.append(", ");
                    this.generateSizeParams(stringBuilder, n3, n4, n5);
                }
            } else if (layoutInterval.isEmptySpace()) {
                boolean bl3;
                LayoutConstants.PaddingType paddingType = layoutInterval.getPaddingType();
                if (layoutInterval.isDefaultPadding(false)) {
                    if (paddingType != null && paddingType == LayoutConstants.PaddingType.SEPARATE) {
                        bl3 = false;
                        if (n3 == -1) {
                            n3 = 18;
                        }
                        if (n4 == -1) {
                            n4 = 18;
                        }
                    } else {
                        bl3 = true;
                    }
                } else {
                    bl3 = false;
                }
                if (bl3) {
                    if (bl || bl2) {
                        stringBuilder.append(this.getAddContainerGapStr());
                    } else {
                        stringBuilder.append(this.getAddPreferredGapStr());
                        if (paddingType == LayoutConstants.PaddingType.INDENT) {
                            n5 = -1;
                            n4 = -1;
                        }
                        stringBuilder.append(this.getPaddingTypeStr(paddingType));
                    }
                    if (n4 != -1 || n5 != -1 && n5 != -2) {
                        if (!bl && !bl2) {
                            stringBuilder.append(',').append(' ');
                        }
                        stringBuilder.append(this.convertSize(n4)).append(", ");
                        stringBuilder.append(this.convertSize(n5));
                    }
                } else {
                    if (n3 == -2) {
                        n3 = n4;
                    }
                    if (n5 == -2) {
                        n5 = n4;
                    }
                    stringBuilder.append(this.getAddGapStr());
                    if (n3 < 0) {
                        n3 = n4;
                    }
                    n3 = Math.min(n4, n3);
                    n5 = Math.max(n4, n5);
                    this.generateSizeParams(stringBuilder, n3, n4, n5);
                }
            } else assert (false);
        }
        stringBuilder.append(")");
    }

    private void generateSizeParams(StringBuilder stringBuilder, int n, int n2, int n3) {
        stringBuilder.append(this.convertSize(n)).append(", ");
        stringBuilder.append(this.convertSize(n2)).append(", ");
        stringBuilder.append(this.convertSize(n3));
    }

    private String convertAlignment(int n) {
        String string = null;
        switch (n) {
            case 0: {
                string = "LEADING";
                break;
            }
            case 1: {
                string = "TRAILING";
                break;
            }
            case 2: {
                string = "CENTER";
                break;
            }
            case 3: {
                string = "BASELINE";
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        return this.useLayoutLibrary() ? this.getLayoutName() + "." + string : this.getLayoutName() + ".Alignment." + string;
    }

    private String convertSize(int n) {
        String string;
        switch (n) {
            case -1: {
                string = this.getLayoutName() + ".DEFAULT_SIZE";
                break;
            }
            case -2: {
                string = this.getLayoutName() + ".PREFERRED_SIZE";
                break;
            }
            case 32767: {
                string = "Short.MAX_VALUE";
                break;
            }
            default: {
                assert (n >= 0);
                string = Integer.toString(n);
            }
        }
        return string;
    }

    private void composeLinks(StringBuilder stringBuilder, LayoutComponent layoutComponent, String string, int n) throws IOException {
        Map<Integer, List<String>> map = SwingLayoutUtils.createLinkSizeGroups(layoutComponent, n);
        Collection<List<String>> collection = map.values();
        for (List<String> list : collection) {
            Collections.sort(list, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    ComponentInfo componentInfo = (ComponentInfo)SwingLayoutCodeGenerator.this.componentIDMap.get(string);
                    ComponentInfo componentInfo2 = (ComponentInfo)SwingLayoutCodeGenerator.this.componentIDMap.get(string2);
                    return componentInfo.variableName.compareTo(componentInfo2.variableName);
                }
            });
            if (list.size() <= 1) continue;
            stringBuilder.append("\n\n" + string + ".linkSize(");
            if (!this.useLayoutLibrary()) {
                stringBuilder.append("javax.swing.SwingConstants");
                stringBuilder.append(n == 0 ? ".HORIZONTAL, " : ".VERTICAL, ");
            }
            stringBuilder.append("new java.awt.Component[] {");
            Iterator<String> iterator = list.iterator();
            boolean bl = true;
            while (iterator.hasNext()) {
                String string2 = iterator.next();
                ComponentInfo componentInfo = this.componentIDMap.get(string2);
                if (bl) {
                    bl = false;
                    stringBuilder.append(componentInfo.variableName);
                    continue;
                }
                stringBuilder.append(", " + componentInfo.variableName);
            }
            stringBuilder.append("}");
            if (this.useLayoutLibrary()) {
                stringBuilder.append(", ");
                stringBuilder.append(this.getLayoutName());
                stringBuilder.append(n == 0 ? ".HORIZONTAL" : ".VERTICAL");
            }
            stringBuilder.append(");\n\n");
        }
    }

    boolean useLayoutLibrary() {
        return this.useLayoutLibrary;
    }

    private String getLayoutName() {
        return this.useLayoutLibrary() ? "org.jdesktop.layout.GroupLayout" : "javax.swing.GroupLayout";
    }

    private String getLayoutStyleName() {
        return this.useLayoutLibrary() ? "org.jdesktop.layout.LayoutStyle" : "javax.swing.LayoutStyle";
    }

    private String getAddComponentStr() {
        return this.useLayoutLibrary() ? ".add(" : ".addComponent(";
    }

    private String getAddGapStr() {
        return this.useLayoutLibrary() ? ".add(" : ".addGap(";
    }

    private String getAddPreferredGapStr() {
        return ".addPreferredGap(";
    }

    private String getAddContainerGapStr() {
        return ".addContainerGap(";
    }

    private String getAddGroupStr() {
        return this.useLayoutLibrary() ? ".add(" : ".addGroup(";
    }

    private String getPaddingTypeStr(LayoutConstants.PaddingType paddingType) {
        String string;
        if (paddingType == null || paddingType == LayoutConstants.PaddingType.RELATED) {
            string = ".RELATED";
        } else if (paddingType == LayoutConstants.PaddingType.UNRELATED) {
            string = ".UNRELATED";
        } else if (paddingType == LayoutConstants.PaddingType.INDENT) {
            string = ".INDENT";
        } else {
            return null;
        }
        return this.getLayoutStyleName() + (this.useLayoutLibrary ? "" : ".ComponentPlacement") + string;
    }

    public static class ComponentInfo {
        public String id;
        public String variableName;
        public Class clazz;
        public Dimension minSize;
        public boolean sizingChanged;
    }
}

