/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.layoutdesign.support;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.form.layoutdesign.LayoutComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingLayoutUtils {
    public static final int STATUS_UNKNOWN = -1;
    public static final int STATUS_NON_RESIZABLE = 0;
    public static final int STATUS_RESIZABLE = 1;
    private static Set<String> nonResizableComponents = new HashSet<String>();
    private static Set<String> resizableComponents;

    public static int getResizableStatus(Class clazz) {
        String string = clazz.getName();
        if (resizableComponents.contains(string)) {
            return 1;
        }
        if (nonResizableComponents.contains(string)) {
            return 0;
        }
        return -1;
    }

    public static Map<Integer, List<String>> createLinkSizeGroups(LayoutComponent layoutComponent, int n) {
        HashMap<Integer, List<String>> hashMap = new HashMap<Integer, List<String>>();
        if (layoutComponent.isLayoutContainer()) {
            for (LayoutComponent layoutComponent2 : layoutComponent.getSubcomponents()) {
                if (layoutComponent2 == null || !layoutComponent2.isLinkSized(n)) continue;
                String string = layoutComponent2.getId();
                Integer n2 = new Integer(layoutComponent2.getLinkSizeId(n));
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(n2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList.add(string);
                    hashMap.put(n2, arrayList);
                    continue;
                }
                arrayList.add(string);
            }
        }
        return hashMap;
    }

    static {
        nonResizableComponents.addAll(Arrays.asList("javax.swing.JLabel", "javax.swing.JButton", "javax.swing.JToggleButton", "javax.swing.JCheckBox", "javax.swing.JRadioButton", "javax.swing.JList"));
        resizableComponents = new HashSet<String>();
        resizableComponents.addAll(Arrays.asList("javax.swing.JComboBox", "javax.swing.JTextField", "javax.swing.JTextArea", "javax.swing.JTabbedPane", "javax.swing.JScrollPane", "javax.swing.JSplitPane", "javax.swing.JFormattedTextField", "javax.swing.JPasswordField", "javax.swing.JSpinner", "javax.swing.JSeparator", "javax.swing.JTextPane", "javax.swing.JEditorPane", "javax.swing.JInternalFrame", "javax.swing.JLayeredPane", "javax.swing.JDesktopPane"));
    }
}

