/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.lang.reflect.Field;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.plaf.basic.BasicComboBoxUI;

public class ScrollPopupMenu
extends JPopupMenu {
    JWindow popWin;
    JScrollPane scrollPane;
    int posX;
    int posY;
    int maxHeight;

    ScrollPopupMenu(int n) {
        this.maxHeight = n;
    }

    public void setVisible(boolean bl) {
        if (bl == this.isVisible()) {
            return;
        }
        if (bl) {
            MenuElement[] menuElementArray;
            if (this.getInvoker() != null && !(this.getInvoker() instanceof JMenu)) {
                if (this.getSubElements().length > 0) {
                    menuElementArray = new MenuElement[]{this, this.getSubElements()[0]};
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                } else {
                    menuElementArray = new MenuElement[]{this};
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                }
            }
            this.firePopupMenuWillBecomeVisible();
            menuElementArray = this.getInvoker();
            while (menuElementArray.getParent() != null) {
                menuElementArray = menuElementArray.getParent();
            }
            this.popWin = menuElementArray instanceof Window ? new JWindow((Window)menuElementArray) : new JWindow(new JFrame());
            this.popWin.setLocation(this.posX, this.posY);
            this.pack();
            this.popWin.setVisible(true);
        } else {
            this.getSelectionModel().clearSelection();
            if (this.popWin != null) {
                this.firePopupMenuWillBecomeInvisible();
                this.popWin.dispose();
                this.popWin = null;
                this.scrollPane = null;
            }
        }
    }

    public boolean isVisible() {
        return this.popWin != null ? this.popWin.isShowing() : false;
    }

    public void setLocation(int n, int n2) {
        if (this.popWin != null && this.popWin.isShowing()) {
            this.popWin.setLocation(n, n2);
        } else {
            this.posX = n;
            this.posY = n2;
        }
    }

    public void pack() {
        if (this.popWin == null) {
            return;
        }
        Dimension dimension = this.getPreferredSize();
        if (this.maxHeight == 0 || dimension.height <= this.maxHeight) {
            if (this.scrollPane != null) {
                this.popWin.getContentPane().remove(this.scrollPane);
                this.scrollPane = null;
            }
            this.popWin.getContentPane().setLayout(null);
            this.popWin.getContentPane().add(this);
            this.setBounds(0, 0, dimension.width, dimension.height);
            this.popWin.setSize(dimension.width, dimension.height);
        } else {
            if (this.scrollPane == null) {
                JPanel jPanel = new JPanel(new BorderLayout());
                jPanel.add((Component)this, "Center");
                this.scrollPane = new JScrollPane(jPanel);
                this.scrollPane.setHorizontalScrollBarPolicy(31);
                JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
                if (jScrollBar != null) {
                    Dimension dimension2 = jScrollBar.getPreferredSize();
                    dimension2.width = 12;
                    jScrollBar.setPreferredSize(dimension2);
                    jScrollBar.setUnitIncrement(21);
                    ScrollPopupMenu.doNotCancelPopupHack(jScrollBar);
                }
                this.popWin.getContentPane().add((Component)this.scrollPane, "Center");
            }
            this.popWin.pack();
            this.popWin.setSize(this.popWin.getSize().width + 12, this.maxHeight);
            this.requestFocus();
        }
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JScrollBar getScrollBar() {
        return this.scrollPane != null ? this.scrollPane.getVerticalScrollBar() : null;
    }

    public static void doNotCancelPopupHack(JComponent jComponent) {
        if (System.getProperty("java.version").startsWith("1.5")) {
            try {
                Class<BasicComboBoxUI> clazz = BasicComboBoxUI.class;
                Field field = clazz.getDeclaredField("HIDE_POPUP_KEY");
                field.setAccessible(true);
                jComponent.putClientProperty("doNotCancelPopup", field.get(null));
                for (int i = 0; i < jComponent.getComponentCount(); ++i) {
                    Component component = jComponent.getComponent(i);
                    if (!(component instanceof JComponent)) continue;
                    ScrollPopupMenu.doNotCancelPopupHack((JComponent)component);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

