/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.GapObjectArray;
import org.netbeans.spi.editor.fold.FoldHierarchyTransaction;
import org.netbeans.spi.editor.fold.FoldManager;
import org.netbeans.spi.editor.fold.FoldManagerFactory;
import org.netbeans.spi.editor.fold.FoldOperation;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CustomFoldManager
implements FoldManager,
Runnable {
    private static final Logger LOG = Logger.getLogger(CustomFoldManager.class.getName());
    public static final FoldType CUSTOM_FOLD_TYPE = new FoldType("custom-fold");
    private FoldOperation operation;
    private Document doc;
    private GapObjectArray markArray = new GapObjectArray();
    private int minUpdateMarkOffset = Integer.MAX_VALUE;
    private int maxUpdateMarkOffset = -1;
    private List removedFoldList;
    private HashMap customFoldId = new HashMap();
    private final RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)this);
    private static Pattern pattern = Pattern.compile("(<\\s*editor-fold(?:(?:\\s+id=\"(\\S*)\")?(?:\\s+defaultstate=\"(\\S*)\")?(?:\\s+desc=\"([\\S \\t]*)\")?)(?:(?:\\s+defaultstate=\"(\\S*)\")?(?:\\s+desc=\"([\\S \\t]*)\")?)(?:\\s+defaultstate=\"(\\S*)\")?\\s*>)|(?:</\\s*editor-fold\\s*>)");

    CustomFoldManager() {
    }

    public void init(FoldOperation foldOperation) {
        this.operation = foldOperation;
    }

    private FoldOperation getOperation() {
        return this.operation;
    }

    public void initFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        this.doc = this.getOperation().getHierarchy().getComponent().getDocument();
        this.task.schedule(300);
    }

    public void insertUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.processRemovedFolds(foldHierarchyTransaction);
        this.task.schedule(300);
    }

    public void removeUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        this.processRemovedFolds(foldHierarchyTransaction);
        this.removeAffectedMarks(documentEvent, foldHierarchyTransaction);
        this.task.schedule(300);
    }

    public void changedUpdate(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
    }

    public void removeEmptyNotify(Fold fold) {
        this.removeFoldNotify(fold);
    }

    public void removeDamagedNotify(Fold fold) {
        this.removeFoldNotify(fold);
    }

    public void expandNotify(Fold fold) {
    }

    public void release() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block9: {
            ((BaseDocument)this.doc).readLock();
            try {
                TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)this.doc);
                if (tokenHierarchy == null || !tokenHierarchy.isActive()) break block9;
                FoldHierarchy foldHierarchy = this.getOperation().getHierarchy();
                foldHierarchy.lock();
                try {
                    FoldHierarchyTransaction foldHierarchyTransaction = this.getOperation().openTransaction();
                    try {
                        this.updateFolds(tokenHierarchy.tokenSequence(), foldHierarchyTransaction);
                    }
                    finally {
                        foldHierarchyTransaction.commit();
                    }
                }
                finally {
                    foldHierarchy.unlock();
                }
            }
            finally {
                ((BaseDocument)this.doc).readUnlock();
            }
        }
    }

    private void removeFoldNotify(Fold fold) {
        if (this.removedFoldList == null) {
            this.removedFoldList = new ArrayList(3);
        }
        this.removedFoldList.add(fold);
    }

    private void removeAffectedMarks(DocumentEvent documentEvent, FoldHierarchyTransaction foldHierarchyTransaction) {
        int n = documentEvent.getOffset();
        int n2 = this.findMarkIndex(n);
        if (n2 < this.getMarkCount()) {
            FoldMarkInfo foldMarkInfo;
            while (n2 >= 0 && (foldMarkInfo = this.getMark(n2)).getOffset() == n) {
                foldMarkInfo.release(false, foldHierarchyTransaction);
                this.removeMark(n2);
                --n2;
            }
        }
    }

    private void processRemovedFolds(FoldHierarchyTransaction foldHierarchyTransaction) {
        if (this.removedFoldList != null) {
            for (int i = this.removedFoldList.size() - 1; i >= 0; --i) {
                Fold fold = (Fold)this.removedFoldList.get(i);
                FoldMarkInfo foldMarkInfo = (FoldMarkInfo)this.getOperation().getExtraInfo(fold);
                if (foldMarkInfo.getId() != null) {
                    this.customFoldId.put(foldMarkInfo.getId(), fold.isCollapsed());
                }
                FoldMarkInfo foldMarkInfo2 = foldMarkInfo.getPairMark();
                if (this.getOperation().isStartDamaged(fold)) {
                    foldMarkInfo.release(true, foldHierarchyTransaction);
                }
                if (!this.getOperation().isEndDamaged(fold)) continue;
                foldMarkInfo2.release(true, foldHierarchyTransaction);
            }
        }
        this.removedFoldList = null;
    }

    private void markUpdate(FoldMarkInfo foldMarkInfo) {
        this.markUpdate(foldMarkInfo.getOffset());
    }

    private void markUpdate(int n) {
        if (n < this.minUpdateMarkOffset) {
            this.minUpdateMarkOffset = n;
        }
        if (n > this.maxUpdateMarkOffset) {
            this.maxUpdateMarkOffset = n;
        }
    }

    private FoldMarkInfo getMark(int n) {
        return (FoldMarkInfo)this.markArray.getItem(n);
    }

    private int getMarkCount() {
        return this.markArray.getItemCount();
    }

    private void removeMark(int n) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Removing mark from ind=" + n + ": " + this.getMark(n));
        }
        this.markArray.remove(n, 1);
    }

    private void insertMark(int n, FoldMarkInfo foldMarkInfo) {
        this.markArray.insertItem(n, foldMarkInfo);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("Inserted mark at ind=" + n + ": " + foldMarkInfo);
        }
    }

    private int findMarkIndex(int n) {
        int n2 = this.getMarkCount();
        int n3 = 0;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = (n3 + n4) / 2;
            int n6 = this.getMark(n5).getOffset();
            if (n6 < n) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n) {
                n4 = n5 - 1;
                continue;
            }
            ++n5;
            while (n5 < n2 && this.getMark(n5).getOffset() == n) {
                ++n5;
            }
            return --n5;
        }
        return n3;
    }

    private List<FoldMarkInfo> getMarkList(TokenSequence tokenSequence) {
        ArrayList<FoldMarkInfo> arrayList = null;
        tokenSequence.moveStart();
        while (tokenSequence.moveNext()) {
            FoldMarkInfo foldMarkInfo;
            Token token = tokenSequence.token();
            try {
                foldMarkInfo = this.scanToken(token);
            }
            catch (BadLocationException badLocationException) {
                LOG.log(Level.WARNING, null, badLocationException);
                foldMarkInfo = null;
            }
            if (foldMarkInfo == null) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<FoldMarkInfo>();
            }
            arrayList.add(foldMarkInfo);
        }
        return arrayList;
    }

    private void processTokenList(TokenSequence tokenSequence, FoldHierarchyTransaction foldHierarchyTransaction) {
        int n;
        List<FoldMarkInfo> list = this.getMarkList(tokenSequence);
        if (list != null && (n = list.size()) > 0) {
            int n2;
            FoldMarkInfo foldMarkInfo;
            int n3 = list.get(0).getOffset();
            int n4 = this.findMarkIndex(n3);
            if (n4 < this.getMarkCount()) {
                foldMarkInfo = this.getMark(n4);
                n2 = foldMarkInfo.getOffset();
            } else {
                foldMarkInfo = null;
                n2 = Integer.MAX_VALUE;
            }
            for (int i = 0; i < n; ++i) {
                FoldMarkInfo foldMarkInfo2 = list.get(i);
                int n5 = foldMarkInfo2.getOffset();
                if (i == 0 || i == n - 1) {
                    this.markUpdate(n5);
                }
                while (n5 >= n2) {
                    if (n5 == n2) {
                        foldMarkInfo2.setCollapsed(foldMarkInfo.isCollapsed());
                    }
                    if (!foldMarkInfo.isReleased()) {
                        foldMarkInfo.release(false, foldHierarchyTransaction);
                    }
                    this.removeMark(n4);
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.fine("Removed dup mark from ind=" + n4 + ": " + foldMarkInfo);
                    }
                    if (n4 < this.getMarkCount()) {
                        foldMarkInfo = this.getMark(n4);
                        n2 = foldMarkInfo.getOffset();
                        continue;
                    }
                    foldMarkInfo = null;
                    n2 = Integer.MAX_VALUE;
                }
                this.insertMark(n4, foldMarkInfo2);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Inserted mark at ind=" + n4 + ": " + foldMarkInfo2);
                }
                ++n4;
            }
        }
    }

    private void updateFolds(TokenSequence tokenSequence, FoldHierarchyTransaction foldHierarchyTransaction) {
        FoldMarkInfo foldMarkInfo;
        FoldMarkInfo foldMarkInfo2;
        if (tokenSequence != null && !tokenSequence.isEmpty()) {
            this.processTokenList(tokenSequence, foldHierarchyTransaction);
        }
        if (this.maxUpdateMarkOffset == -1) {
            return;
        }
        int n = this.findMarkIndex(this.minUpdateMarkOffset);
        if (n == 0) {
            foldMarkInfo2 = null;
            foldMarkInfo = null;
        } else {
            foldMarkInfo2 = this.getMark(n - 1);
            foldMarkInfo = foldMarkInfo2.getParentMark();
        }
        int n2 = this.getMarkCount();
        while (n < n2) {
            FoldMarkInfo foldMarkInfo3 = this.getMark(n);
            if (foldMarkInfo3.isReleased()) {
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("Removing released mark at ind=" + n + ": " + foldMarkInfo3);
                }
                this.removeMark(n);
                --n2;
                continue;
            }
            if (foldMarkInfo3.isStartMark()) {
                if (foldMarkInfo2 == null || foldMarkInfo2.isStartMark()) {
                    foldMarkInfo3.setParentMark(foldMarkInfo2);
                    foldMarkInfo = foldMarkInfo2;
                }
            } else if (foldMarkInfo2 != null) {
                if (foldMarkInfo2.isStartMark()) {
                    foldMarkInfo2.setEndMark(foldMarkInfo3, false, foldHierarchyTransaction);
                } else if (foldMarkInfo != null) {
                    foldMarkInfo.setEndMark(foldMarkInfo3, false, foldHierarchyTransaction);
                    foldMarkInfo = foldMarkInfo.getParentMark();
                } else {
                    foldMarkInfo3.makeSolitaire(false, foldHierarchyTransaction);
                }
            } else {
                foldMarkInfo3.makeSolitaire(false, foldHierarchyTransaction);
            }
            foldMarkInfo3.setParentMark(foldMarkInfo);
            foldMarkInfo2 = foldMarkInfo3;
            ++n;
        }
        this.minUpdateMarkOffset = Integer.MAX_VALUE;
        this.maxUpdateMarkOffset = -1;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("MARKS DUMP:\n" + this);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getMarkCount();
        int n2 = Integer.toString(n).length();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("[");
            String string = Integer.toString(i);
            CustomFoldManager.appendSpaces(stringBuffer, n2 - string.length());
            stringBuffer.append(string);
            stringBuffer.append("]:");
            FoldMarkInfo foldMarkInfo = this.getMark(i);
            int n3 = 0;
            for (FoldMarkInfo foldMarkInfo2 = foldMarkInfo.getParentMark(); foldMarkInfo2 != null; foldMarkInfo2 = foldMarkInfo2.getParentMark()) {
                n3 += 4;
            }
            CustomFoldManager.appendSpaces(stringBuffer, n3);
            stringBuffer.append(foldMarkInfo);
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    private static void appendSpaces(StringBuffer stringBuffer, int n) {
        while (--n >= 0) {
            stringBuffer.append(' ');
        }
    }

    private FoldMarkInfo scanToken(Token token) throws BadLocationException {
        Matcher matcher;
        if (token.id().primaryCategory() != null && "comment".equals(token.id().primaryCategory()) && (matcher = pattern.matcher(token.text())).find()) {
            if (matcher.group(1) != null) {
                boolean bl = "collapsed".equals(matcher.group(3));
                if (matcher.group(2) != null) {
                    Boolean bl2 = (Boolean)this.customFoldId.get(matcher.group(2));
                    if (bl2 != null) {
                        bl = bl2;
                    } else {
                        this.customFoldId.put(matcher.group(2), bl);
                    }
                }
                return new FoldMarkInfo(true, token.offset(null), matcher.end(0), matcher.group(2), bl, matcher.group(4));
            }
            return new FoldMarkInfo(false, token.offset(null), matcher.end(0), null, false, null);
        }
        return null;
    }

    public static final class Factory
    implements FoldManagerFactory {
        public FoldManager createFoldManager() {
            return new CustomFoldManager();
        }
    }

    private final class FoldMarkInfo {
        private boolean startMark;
        private Position pos;
        private int length;
        private String id;
        private boolean collapsed;
        private String description;
        private FoldMarkInfo pairMark;
        private FoldMarkInfo parentMark;
        private Fold fold;
        private boolean released;

        private FoldMarkInfo(boolean bl, int n, int n2, String string, boolean bl2, String string2) throws BadLocationException {
            this.startMark = bl;
            this.pos = CustomFoldManager.this.doc.createPosition(n);
            this.length = n2;
            this.id = string;
            this.collapsed = bl2;
            this.description = string2;
        }

        public String getId() {
            return this.id;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isStartMark() {
            return this.startMark;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.pos.getOffset();
        }

        public int getEndOffset() {
            return this.getOffset() + this.getLength();
        }

        public boolean isCollapsed() {
            return this.fold != null ? this.fold.isCollapsed() : this.collapsed;
        }

        public boolean hasFold() {
            return this.fold != null;
        }

        public void setCollapsed(boolean bl) {
            this.collapsed = bl;
        }

        public boolean isSolitaire() {
            return this.pairMark == null;
        }

        public void makeSolitaire(boolean bl, FoldHierarchyTransaction foldHierarchyTransaction) {
            if (!this.isSolitaire()) {
                if (this.isStartMark()) {
                    this.setEndMark(null, bl, foldHierarchyTransaction);
                } else {
                    this.getPairMark().setEndMark(null, bl, foldHierarchyTransaction);
                }
            }
        }

        public boolean isReleased() {
            return this.released;
        }

        public void release(boolean bl, FoldHierarchyTransaction foldHierarchyTransaction) {
            if (!this.released) {
                this.makeSolitaire(bl, foldHierarchyTransaction);
                this.released = true;
                CustomFoldManager.this.markUpdate(this);
            }
        }

        public FoldMarkInfo getPairMark() {
            return this.pairMark;
        }

        private void setPairMark(FoldMarkInfo foldMarkInfo) {
            this.pairMark = foldMarkInfo;
        }

        public void setEndMark(FoldMarkInfo foldMarkInfo, boolean bl, FoldHierarchyTransaction foldHierarchyTransaction) {
            if (!this.isStartMark()) {
                throw new IllegalStateException("Not start mark");
            }
            if (this.pairMark == foldMarkInfo) {
                return;
            }
            if (this.pairMark != null) {
                this.releaseFold(bl, foldHierarchyTransaction);
                this.pairMark.setPairMark(null);
            }
            this.pairMark = foldMarkInfo;
            if (foldMarkInfo != null) {
                if (!foldMarkInfo.isSolitaire()) {
                    foldMarkInfo.makeSolitaire(false, foldHierarchyTransaction);
                }
                foldMarkInfo.setPairMark(this);
                foldMarkInfo.setParentMark(this.getParentMark());
                this.ensureFoldExists(foldHierarchyTransaction);
            }
        }

        public FoldMarkInfo getParentMark() {
            return this.parentMark;
        }

        public void setParentMark(FoldMarkInfo foldMarkInfo) {
            this.parentMark = foldMarkInfo;
        }

        private void releaseFold(boolean bl, FoldHierarchyTransaction foldHierarchyTransaction) {
            if (this.isSolitaire() || !this.isStartMark()) {
                throw new IllegalStateException();
            }
            if (this.fold != null) {
                this.setCollapsed(this.fold.isCollapsed());
                if (!bl) {
                    CustomFoldManager.this.getOperation().removeFromHierarchy(this.fold, foldHierarchyTransaction);
                }
                this.fold = null;
            }
        }

        public Fold getFold() {
            if (this.isSolitaire()) {
                return null;
            }
            if (!this.isStartMark()) {
                return this.pairMark.getFold();
            }
            return this.fold;
        }

        public void ensureFoldExists(FoldHierarchyTransaction foldHierarchyTransaction) {
            if (this.isSolitaire() || !this.isStartMark()) {
                throw new IllegalStateException();
            }
            if (this.fold == null) {
                try {
                    if (!this.startMark) {
                        throw new IllegalStateException("Not start mark: " + this);
                    }
                    if (this.pairMark == null) {
                        throw new IllegalStateException("No pairMark for mark:" + this);
                    }
                    int n = this.getOffset();
                    int n2 = this.getLength();
                    int n3 = this.pairMark.getLength();
                    int n4 = this.pairMark.getOffset() + n3;
                    this.fold = CustomFoldManager.this.getOperation().addToHierarchy(CUSTOM_FOLD_TYPE, this.getDescription(), this.collapsed, n, n4, n2, n3, (Object)this, foldHierarchyTransaction);
                }
                catch (BadLocationException badLocationException) {
                    LOG.log(Level.WARNING, null, badLocationException);
                }
            }
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.isStartMark() ? (char)'S' : 'E');
            if (this.hasFold() || !this.isSolitaire() && this.getPairMark().hasFold()) {
                stringBuffer.append("F");
                if (this.isStartMark() && (this.isSolitaire() || this.getOffset() != this.fold.getStartOffset() || this.getPairMark().getEndOffset() != this.fold.getEndOffset())) {
                    stringBuffer.append("!!<");
                    stringBuffer.append(this.fold.getStartOffset());
                    stringBuffer.append(",");
                    stringBuffer.append(this.fold.getEndOffset());
                    stringBuffer.append(">!!");
                }
            }
            stringBuffer.append(" (");
            stringBuffer.append("o=");
            stringBuffer.append(this.pos.getOffset());
            stringBuffer.append(", l=");
            stringBuffer.append(this.length);
            stringBuffer.append(", d='");
            stringBuffer.append(this.description);
            stringBuffer.append('\'');
            if (this.getPairMark() != null) {
                stringBuffer.append(", <->");
                stringBuffer.append(this.getPairMark().getOffset());
            }
            if (this.getParentMark() != null) {
                stringBuffer.append(", ^");
                stringBuffer.append(this.getParentMark().getOffset());
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
    }
}

