/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.Mark;
import org.netbeans.editor.Utilities;

public class MarkBlock {
    public static final int INVALID = 0;
    public static final int OVERLAP = 1;
    public static final int CONTINUE = 2;
    public static final int EMPTY = 4;
    public static final int THIS_EMPTY = 8;
    public static final int EXTEND = 17;
    public static final int INSIDE = 33;
    public static final int BEFORE = 64;
    public static final int AFTER = 128;
    public static final int CONTINUE_BEGIN = 66;
    public static final int CONTINUE_END = 130;
    public static final int OVERLAP_BEGIN = 257;
    public static final int OVERLAP_END = 513;
    public static final int EXTEND_BEGIN = 273;
    public static final int EXTEND_END = 529;
    public static final int INCLUDE = 785;
    public static final int INSIDE_BEGIN = 1057;
    public static final int INSIDE_END = 2081;
    public static final int INNER = 4129;
    public static final int SAME = 3105;
    public static final int IGNORE_EMPTY = -13;
    protected MarkBlock next;
    protected MarkBlock prev;
    public Mark startMark;
    public Mark endMark;
    protected BaseDocument doc;

    public MarkBlock(BaseDocument baseDocument, Mark mark, Mark mark2) {
        this.doc = baseDocument;
        this.startMark = mark;
        this.endMark = mark2;
    }

    public MarkBlock(BaseDocument baseDocument, int n, int n2) throws BadLocationException {
        this(baseDocument, new Mark(), new Mark(), n, n2);
    }

    public MarkBlock(BaseDocument baseDocument, Mark mark, Mark mark2, int n, int n2) throws BadLocationException {
        this(baseDocument, mark, mark2);
        try {
            mark.insert(baseDocument, n);
            try {
                mark2.insert(baseDocument, n2);
            }
            catch (BadLocationException badLocationException) {
                try {
                    mark.remove();
                }
                catch (InvalidMarkException invalidMarkException) {
                    Utilities.annotateLoggable(invalidMarkException);
                }
                throw badLocationException;
            }
            catch (InvalidMarkException invalidMarkException) {
                Utilities.annotateLoggable(invalidMarkException);
            }
        }
        catch (InvalidMarkException invalidMarkException) {
            Utilities.annotateLoggable(invalidMarkException);
        }
    }

    public MarkBlock insertChain(MarkBlock markBlock) {
        MarkBlock markBlock2;
        markBlock.prev = markBlock2 = this.prev;
        markBlock.next = this;
        if (markBlock2 != null) {
            markBlock2.next = markBlock;
        }
        this.prev = markBlock;
        return markBlock;
    }

    public MarkBlock addChain(MarkBlock markBlock) {
        if (this.next != null) {
            this.next.insertChain(markBlock);
        } else {
            this.setNextChain(markBlock);
        }
        return markBlock;
    }

    public MarkBlock removeChain() {
        MarkBlock markBlock = this.next;
        MarkBlock markBlock2 = this.prev;
        if (markBlock2 != null) {
            markBlock2.next = markBlock;
            this.prev = null;
        }
        if (markBlock != null) {
            markBlock.prev = markBlock2;
            this.next = null;
        }
        this.destroyMarks();
        return markBlock;
    }

    public int compare(int n, int n2) {
        try {
            int n3;
            int n4 = this.startMark.getOffset();
            int n5 = this.endMark.getOffset();
            if (n4 > n5) {
                n3 = n4;
                n4 = n5;
                n5 = n3;
            }
            n3 = 0;
            if (n == n2) {
                if (n4 == n5) {
                    if (n < n4) {
                        return 76;
                    }
                    if (n > n4) {
                        return 140;
                    }
                    return 3117;
                }
                if (n <= n4) {
                    return n < n4 ? 68 : 1061;
                }
                if (n >= n5) {
                    return n > n5 ? 132 : 2085;
                }
                return 4133;
            }
            if (n4 == n5) {
                if (n >= n4) {
                    return n > n4 ? 136 : 537;
                }
                if (n2 >= n4) {
                    return n2 > n4 ? 72 : 281;
                }
                return 793;
            }
            if (n2 <= n4) {
                return n2 < n4 ? 64 : 66;
            }
            if (n >= n5) {
                return n > n5 ? 128 : 130;
            }
            if (n2 < n5) {
                if (n > n4) {
                    return 4129;
                }
                if (n == n4) {
                    return 1057;
                }
                return 257;
            }
            if (n2 == n5) {
                if (n > n4) {
                    return 2081;
                }
                if (n == n4) {
                    return 3105;
                }
                return 273;
            }
            if (n > n4) {
                return 513;
            }
            if (n == n4) {
                return 529;
            }
            return 785;
        }
        catch (InvalidMarkException invalidMarkException) {
            return 0;
        }
    }

    public final MarkBlock getNext() {
        return this.next;
    }

    public final void setNext(MarkBlock markBlock) {
        this.next = markBlock;
    }

    public void setNextChain(MarkBlock markBlock) {
        this.next = markBlock;
        if (markBlock != null) {
            markBlock.prev = this;
        }
    }

    public final MarkBlock getPrev() {
        return this.prev;
    }

    public final void setPrev(MarkBlock markBlock) {
        this.prev = markBlock;
    }

    public void setPrevChain(MarkBlock markBlock) {
        this.prev = markBlock;
        if (markBlock != null) {
            markBlock.next = this;
        }
    }

    public boolean isReverse() {
        try {
            return this.startMark.getOffset() > this.endMark.getOffset();
        }
        catch (InvalidMarkException invalidMarkException) {
            return false;
        }
    }

    public void reverse() {
        Mark mark = this.startMark;
        this.startMark = this.endMark;
        this.endMark = mark;
    }

    public boolean checkReverse() {
        if (this.isReverse()) {
            this.reverse();
            return true;
        }
        return false;
    }

    public int extendStart(int n) throws BadLocationException {
        try {
            int n2 = this.startMark.getOffset();
            n = Math.min(n, n2);
            if (n != n2) {
                this.startMark.move(this.doc, n);
            }
            return n;
        }
        catch (InvalidMarkException invalidMarkException) {
            Utilities.annotateLoggable(invalidMarkException);
            return 0;
        }
    }

    public int extendEnd(int n) throws BadLocationException {
        try {
            int n2 = this.endMark.getOffset();
            n = Math.max(n, n2);
            if (n != n2) {
                this.endMark.move(this.doc, n);
            }
            return n;
        }
        catch (InvalidMarkException invalidMarkException) {
            Utilities.annotateLoggable(invalidMarkException);
            return 0;
        }
    }

    public boolean extend(int n, int n2, boolean bl) throws BadLocationException {
        try {
            boolean bl2 = false;
            int n3 = this.compare(n, n2);
            if ((n3 & 0x101) == 257 || (n3 & 0x42) == 66 && bl) {
                bl2 = true;
                this.startMark.move(this.doc, n);
            }
            if ((n3 & 0x201) == 513 || (n3 & 0x82) == 130 && bl) {
                bl2 = true;
                this.endMark.move(this.doc, n2);
            }
            return bl2;
        }
        catch (InvalidMarkException invalidMarkException) {
            Utilities.annotateLoggable(invalidMarkException);
            return false;
        }
    }

    public boolean extend(MarkBlock markBlock, boolean bl) {
        try {
            return this.extend(markBlock.startMark.getOffset(), markBlock.endMark.getOffset(), bl);
        }
        catch (BadLocationException badLocationException) {
            Utilities.annotateLoggable(badLocationException);
        }
        catch (InvalidMarkException invalidMarkException) {
            Utilities.annotateLoggable(invalidMarkException);
        }
        return false;
    }

    public int shrink(int n, int n2) throws BadLocationException {
        try {
            int n3 = this.compare(n, n2);
            switch (n3) {
                case 257: 
                case 1057: {
                    this.startMark.move(this.doc, n2);
                    break;
                }
                case 513: 
                case 2081: {
                    this.endMark.move(this.doc, n);
                }
            }
            return n3;
        }
        catch (InvalidMarkException invalidMarkException) {
            Utilities.annotateLoggable(invalidMarkException);
            return 0;
        }
    }

    public Document getDocument() {
        return this.doc;
    }

    public int getStartOffset() {
        try {
            return this.startMark.getOffset();
        }
        catch (InvalidMarkException invalidMarkException) {
            return 0;
        }
    }

    public int getEndOffset() {
        try {
            return this.endMark.getOffset();
        }
        catch (InvalidMarkException invalidMarkException) {
            return 0;
        }
    }

    void destroyMarks() {
        try {
            if (this.startMark != null) {
                this.startMark.remove();
                this.startMark = null;
            }
        }
        catch (InvalidMarkException invalidMarkException) {
            // empty catch block
        }
        try {
            if (this.endMark != null) {
                this.endMark.remove();
                this.endMark = null;
            }
        }
        catch (InvalidMarkException invalidMarkException) {
            // empty catch block
        }
    }

    protected void finalize() throws Throwable {
        this.destroyMarks();
        super.finalize();
    }

    public String toString() {
        try {
            return "startPos=" + (this.startMark != null ? String.valueOf(this.startMark.getOffset()) + '[' + Utilities.debugPosition(this.doc, this.startMark.getOffset()) + ']' : "null") + ", endPos=" + (this.endMark != null ? String.valueOf(this.endMark.getOffset()) + '[' + Utilities.debugPosition(this.doc, this.endMark.getOffset()) + ']' : "null") + ", " + (this.prev != null ? (this.next != null ? "chain member" : "last member") : (this.next != null ? "first member" : "standalone member"));
        }
        catch (InvalidMarkException invalidMarkException) {
            return "";
        }
    }

    public String toStringChain() {
        return this.toString() + (this.next != null ? "\n" + this.next.toStringChain() : "");
    }

    public static String debugRelation(int n) {
        String string = (n & 4) != 0 ? "EMPTY | " : "";
        string = string + ((n & 8) != 0 ? "THIS_EMPTY | " : "");
        switch (n &= 0xFFFFFFF3) {
            case 64: {
                return string + "BEFORE";
            }
            case 128: {
                return string + "AFTER";
            }
            case 66: {
                return string + "CONTINUE_BEGIN";
            }
            case 130: {
                return string + "CONTINUE_END";
            }
            case 257: {
                return string + "OVERLAP_BEGIN";
            }
            case 513: {
                return string + "OVERLAP_END";
            }
            case 273: {
                return string + "EXTEND_BEGIN";
            }
            case 529: {
                return string + "EXTEND_END";
            }
            case 785: {
                return string + "INCLUDE";
            }
            case 1057: {
                return string + "INSIDE_BEGIN";
            }
            case 2081: {
                return string + "INSIDE_END";
            }
            case 4129: {
                return string + "INNER";
            }
            case 3105: {
                return string + "SAME";
            }
            case 0: {
                return string + "INVALID";
            }
        }
        return string + "UNKNOWN_STATE " + n;
    }
}

