/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.view;

class GapObjectArray {
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Object[] array;
    private int gapStart;
    private int gapLength;

    public GapObjectArray() {
        this.array = EMPTY_ARRAY;
    }

    public GapObjectArray(Object[] objectArray, int n) {
        this.array = objectArray;
        this.gapStart = n;
        this.gapLength = objectArray.length - n;
    }

    public int getItemCount() {
        return this.array.length - this.gapLength;
    }

    public Object getItem(int n) {
        return this.array[n < this.gapStart ? n : n + this.gapLength];
    }

    public void copyItems(int n, int n2, Object[] objectArray, int n3) {
        this.rangeCheck(n, n2 - n);
        if (n2 < this.gapStart) {
            System.arraycopy(this.array, n, objectArray, n3, n2 - n);
        } else if (n >= this.gapStart) {
            System.arraycopy(this.array, n + this.gapLength, objectArray, n3, n2 - n);
        } else {
            int n4 = this.gapStart - n;
            System.arraycopy(this.array, n, objectArray, n3, n4);
            System.arraycopy(this.array, this.gapStart + this.gapLength, objectArray, n3 + n4, n2 - n - n4);
        }
    }

    public final int getGapStart() {
        return this.gapStart;
    }

    public void replace(int n, int n2, Object[] objectArray) {
        this.remove(n, n2);
        this.insertAll(n, objectArray);
    }

    public void insertItem(int n, Object object) {
        this.indexCheck(n);
        if (this.gapLength == 0) {
            this.enlargeGap(1);
        }
        if (n != this.gapStart) {
            this.moveGap(n);
        }
        this.array[this.gapStart++] = object;
        --this.gapLength;
    }

    public void insertAll(int n, Object[] objectArray) {
        this.insertAll(n, objectArray, 0, objectArray.length);
    }

    public void insertAll(int n, Object[] objectArray, int n2, int n3) {
        this.indexCheck(n);
        if (objectArray.length == 0) {
            return;
        }
        int n4 = n3 - this.gapLength;
        if (n4 > 0) {
            this.enlargeGap(n4);
        }
        if (n != this.gapStart) {
            this.moveGap(n);
        }
        System.arraycopy(objectArray, n2, this.array, this.gapStart, n3);
        this.gapStart += n3;
        this.gapLength -= n3;
    }

    public void ensureCapacity(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("minCapacity=" + n + " < 0");
        }
        int n2 = this.array.length;
        if (n2 == 0) {
            this.setCapacity(n);
        } else if (n > n2) {
            this.enlargeGap(n - n2);
        }
    }

    public void remove(int n, int n2) {
        this.remove(n, n2, null);
    }

    public void remove(int n, int n2, RemoveUpdater removeUpdater) {
        this.rangeCheck(n, n2);
        if (n2 == 0) {
            return;
        }
        if (n >= this.gapStart) {
            if (n > this.gapStart) {
                this.moveGap(n);
            }
            int n3 = (n += this.gapLength) + n2;
            while (n < n3) {
                if (removeUpdater != null) {
                    removeUpdater.removeUpdate(this.array[n]);
                }
                this.array[n] = null;
                ++n;
            }
        } else {
            int n4 = n + n2;
            if (n4 <= this.gapStart) {
                if (n4 < this.gapStart) {
                    this.moveGap(n4);
                }
                this.gapStart = n;
            } else {
                for (int i = n; i < this.gapStart; ++i) {
                    if (removeUpdater != null) {
                        removeUpdater.removeUpdate(this.array[i]);
                    }
                    this.array[i] = null;
                }
                n = this.gapStart + this.gapLength;
                this.gapStart = n4 - n2;
                n4 += this.gapLength;
            }
            while (n < n4) {
                if (removeUpdater != null) {
                    removeUpdater.removeUpdate(this.array[n]);
                }
                this.array[n++] = null;
            }
        }
        this.gapLength += n2;
    }

    protected void unoptimizedRemove(int n, int n2, RemoveUpdater removeUpdater) {
        this.rangeCheck(n, n2);
        int n3 = n + n2;
        if (this.gapStart != n3) {
            this.moveGap(n3);
        }
        for (int i = n3 - 1; i >= n; --i) {
            if (removeUpdater != null) {
                removeUpdater.removeUpdate(this.array[i]);
            }
            this.array[i] = null;
        }
        this.gapStart = n;
    }

    public void compact() {
        this.setCapacity(this.getItemCount());
    }

    protected void movedAboveGapUpdate(Object[] objectArray, int n, int n2) {
    }

    protected void movedBelowGapUpdate(Object[] objectArray, int n, int n2) {
    }

    private void moveGap(int n) {
        if (n <= this.gapStart) {
            int n2 = this.gapStart - n;
            System.arraycopy(this.array, n, this.array, this.gapStart + this.gapLength - n2, n2);
            this.clearEmpty(n, Math.min(n2, this.gapLength));
            this.gapStart = n;
            this.movedAboveGapUpdate(this.array, this.gapStart + this.gapLength, n2);
        } else {
            int n3 = this.gapStart + this.gapLength;
            int n4 = n - this.gapStart;
            System.arraycopy(this.array, n3, this.array, this.gapStart, n4);
            if (n < n3) {
                this.clearEmpty(n3, n4);
            } else {
                this.clearEmpty(n, this.gapLength);
            }
            this.movedBelowGapUpdate(this.array, this.gapStart, n4);
            this.gapStart += n4;
        }
    }

    private void clearEmpty(int n, int n2) {
        while (--n2 >= 0) {
            this.array[n++] = null;
        }
    }

    private void enlargeGap(int n) {
        int n2 = Math.max(4, Math.max(this.array.length * 2, this.array.length + n));
        this.setCapacity(n2);
    }

    private void setCapacity(int n) {
        int n2 = this.gapStart + this.gapLength;
        int n3 = this.array.length - n2;
        int n4 = n - n3;
        Object[] objectArray = new Object[n];
        if (n < this.gapStart + n3) {
            throw new IllegalArgumentException("newCapacity=" + n + " < itemCount=" + (this.gapStart + n3));
        }
        System.arraycopy(this.array, 0, objectArray, 0, this.gapStart);
        System.arraycopy(this.array, n2, objectArray, n4, n3);
        this.array = objectArray;
        this.gapLength = n4 - this.gapStart;
    }

    private void rangeCheck(int n, int n2) {
        if (n < 0 || n2 < 0 || n + n2 > this.getItemCount()) {
            throw new IndexOutOfBoundsException("index=" + n + ", count=" + n2 + ", getItemCount()=" + this.getItemCount());
        }
    }

    private void indexCheck(int n) {
        if (n > this.getItemCount()) {
            throw new IndexOutOfBoundsException("index=" + n + ", getItemCount()=" + this.getItemCount());
        }
    }

    void check() {
        if (this.gapStart < 0 || this.gapLength < 0 || this.gapStart + this.gapLength > this.array.length) {
            throw new IllegalStateException();
        }
        for (int i = this.gapStart + this.gapLength - 1; i >= this.gapStart; --i) {
            if (this.array[i] == null) continue;
            throw new IllegalStateException();
        }
    }

    public String toStringDetail() {
        return "gapStart=" + this.gapStart + ", gapLength=" + this.gapLength + ", array.length=" + this.array.length;
    }

    public static interface RemoveUpdater {
        public void removeUpdate(Object var1);
    }
}

