/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.cnd.api.execution.ExecutionListener;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.utils.IpeUtils;
import org.netbeans.modules.cnd.gizmo.GizmoConfigurationOptions;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionEvent;
import org.netbeans.modules.cnd.makeproject.api.ProjectActionHandler;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.RunProfile;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.execution.DLightToolkitManagement;
import org.netbeans.modules.dlight.api.support.NativeExecutableTarget;
import org.netbeans.modules.dlight.api.support.NativeExecutableTargetConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationManager;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ExternalTerminalProvider;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GizmoRunActionHandler
implements ProjectActionHandler,
DLightTargetListener {
    private static final String GNU_FAMILIY = "gc++filt";
    private static final String SS_FAMILIY = "dem";
    private ProjectActionEvent pae;
    private List<ExecutionListener> listeners = new CopyOnWriteArrayList<ExecutionListener>();
    private DLightToolkitManagement.DLightSessionHandler session;
    private InputOutput io;
    private long startTimeMillis;

    public void init(ProjectActionEvent projectActionEvent) {
        this.pae = projectActionEvent;
    }

    public void execute(InputOutput inputOutput) {
        String string;
        String string2;
        PathMap pathMap;
        MakeConfiguration makeConfiguration = this.pae.getConfiguration();
        ExecutionEnvironment executionEnvironment = makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        Map<String, String> map = this.createMap(this.pae.getProfile().getEnvironment().getenvAsPairs());
        NativeExecutableTargetConfiguration nativeExecutableTargetConfiguration = new NativeExecutableTargetConfiguration(this.pae.getExecutable(), this.pae.getProfile().getArgsArray(), map);
        String string3 = this.pae.getExecutable();
        String string4 = this.pae.getProfile().getRunDirectory();
        if (executionEnvironment.isRemote()) {
            pathMap = HostInfoProvider.getMapper((ExecutionEnvironment)executionEnvironment);
            string3 = pathMap.getLocalPath(string3);
            string4 = pathMap.getRemotePath(string4, true);
        }
        nativeExecutableTargetConfiguration.setExecutionEnvironment(executionEnvironment);
        if (executionEnvironment.isRemote() && !map.containsKey("DISPLAY")) {
            nativeExecutableTargetConfiguration.setX11Forwarding(true);
        }
        nativeExecutableTargetConfiguration.putInfo("service.storage.execution.env.key", ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)executionEnvironment));
        nativeExecutableTargetConfiguration.putInfo("gizmo.platform", this.pae.getConfiguration().getDevelopmentHost().getBuildPlatformDisplayName());
        nativeExecutableTargetConfiguration.putInfo("GizmoProjectFolder", FileUtil.toFile((FileObject)this.pae.getProject().getProjectDirectory()).getAbsolutePath());
        nativeExecutableTargetConfiguration.putInfo("GizmoProjectExecutable", string3);
        nativeExecutableTargetConfiguration.putInfo("sunstudio.datafilter.collectedobjects", System.getProperty("sunstudio.datafilter.collectedobjects", ""));
        nativeExecutableTargetConfiguration.putInfo("sunstudio.hotspotfunctionsfilter", System.getProperty("sunstudio.hotspotfunctionsfilter", ""));
        pathMap = makeConfiguration.getCompilerSet().getCompilerSet();
        String string5 = pathMap.getDirectory();
        String string6 = SS_FAMILIY;
        if (pathMap.isGnuCompiler()) {
            string6 = GNU_FAMILIY;
        }
        String string7 = string5 + "/" + string6;
        nativeExecutableTargetConfiguration.putInfo("GizmoDemangleUtility", string7);
        nativeExecutableTargetConfiguration.setWorkingDirectory(string4);
        int n = this.pae.getProfile().getConsoleType().getValue();
        if (n == 0) {
            n = RunProfile.getDefaultConsoleType();
        }
        if (n == 1 && (string2 = this.pae.getProfile().getTerminalPath()) != null) {
            string = IpeUtils.getBaseName((String)string2);
            if (ExternalTerminalProvider.getSupportedTerminalIDs().contains(string)) {
                nativeExecutableTargetConfiguration.useExternalTerminal(ExternalTerminalProvider.getTerminal((ExecutionEnvironment)executionEnvironment, (String)string));
            }
        }
        this.io = inputOutput;
        nativeExecutableTargetConfiguration.setIO(inputOutput);
        string2 = DLightConfigurationManager.getInstance().getConfigurationByName("Gizmo");
        string = string2.getConfigurationOptions(false);
        if (string instanceof GizmoConfigurationOptions) {
            ((GizmoConfigurationOptions)((Object)string)).configure(this.pae.getProject());
        }
        NativeExecutableTarget nativeExecutableTarget = new NativeExecutableTarget(nativeExecutableTargetConfiguration);
        nativeExecutableTarget.addTargetListener((DLightTargetListener)this);
        final Future future = DLightToolkitManagement.getInstance().createSession((DLightTarget)nativeExecutableTarget, (DLightConfiguration)string2, IpeUtils.getBaseName((String)this.pae.getExecutable()));
        DLightExecutorService.submit((Runnable)new Runnable(){

            public void run() {
                try {
                    GizmoRunActionHandler.this.session = (DLightToolkitManagement.DLightSessionHandler)future.get();
                    DLightToolkitManagement.getInstance().startSession(GizmoRunActionHandler.this.session);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
                catch (ExecutionException executionException) {
                    Exceptions.printStackTrace((Throwable)executionException);
                }
            }
        }, (String)("DLight Session for " + nativeExecutableTarget.toString()));
    }

    private Map<String, String> createMap(String[][] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i][0], stringArray[i][1]);
        }
        return hashMap;
    }

    public boolean canCancel() {
        return true;
    }

    public void cancel() {
        if (this.session != null) {
            DLightToolkitManagement.getInstance().stopSession(this.session);
            this.session = null;
        }
    }

    public void addExecutionListener(ExecutionListener executionListener) {
        if (!this.listeners.contains(executionListener)) {
            this.listeners.add(executionListener);
        }
    }

    public void removeExecutionListener(ExecutionListener executionListener) {
        this.listeners.remove(executionListener);
    }

    public void targetStateChanged(DLightTargetChangeEvent dLightTargetChangeEvent) {
        switch (dLightTargetChangeEvent.state) {
            case INIT: 
            case STARTING: {
                break;
            }
            case RUNNING: {
                this.targetStarted();
                break;
            }
            case FAILED: 
            case STOPPED: {
                this.targetFailed();
                break;
            }
            case TERMINATED: {
                this.targetFinished(dLightTargetChangeEvent.status);
                break;
            }
            case DONE: {
                this.targetFinished(dLightTargetChangeEvent.status);
            }
        }
    }

    private void targetStarted() {
        this.startTimeMillis = System.currentTimeMillis();
        for (ExecutionListener executionListener : this.listeners) {
            executionListener.executionStarted();
        }
    }

    private void targetFailed() {
        StatusDisplayer.getDefault().setStatusText(GizmoRunActionHandler.getMessage("Status.RunFailedToStart", new Object[0]));
        this.io.getErr().println(GizmoRunActionHandler.getMessage("Output.RunFailedToStart", new Object[0]));
        for (ExecutionListener executionListener : this.listeners) {
            executionListener.executionFinished(-1);
        }
    }

    private void targetFinished(Integer n) {
        int n2 = -1;
        this.io.getOut().println();
        if (n == null) {
            StatusDisplayer.getDefault().setStatusText(GizmoRunActionHandler.getMessage("Status.RunTerminated", new Object[0]));
            this.io.getErr().println(GizmoRunActionHandler.getMessage("Output.RunTerminated", new Object[0]));
        } else {
            n2 = n;
            boolean bl = n2 == 0;
            StatusDisplayer.getDefault().setStatusText(GizmoRunActionHandler.getMessage(bl ? "Status.RunSuccessful" : "Status.RunFailed", new Object[0]));
            String string = GizmoRunActionHandler.formatTime(System.currentTimeMillis() - this.startTimeMillis);
            if (bl) {
                this.io.getOut().println(GizmoRunActionHandler.getMessage("Output.RunSuccessful", string));
            } else {
                this.io.getErr().println(GizmoRunActionHandler.getMessage("Output.RunFailed", n2, string));
            }
        }
        for (ExecutionListener executionListener : this.listeners) {
            executionListener.executionFinished(n2);
        }
    }

    private static String formatTime(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        long l4 = l3 / 60L;
        if (l4 > 0L) {
            stringBuilder.append(' ').append(l4).append(GizmoRunActionHandler.getMessage("Time.Hour", new Object[0]));
        }
        if (l3 > 0L) {
            stringBuilder.append(' ').append(l3 % 60L).append(GizmoRunActionHandler.getMessage("Time.Minute", new Object[0]));
        }
        if (l2 > 0L) {
            stringBuilder.append(' ').append(l2 % 60L).append(GizmoRunActionHandler.getMessage("Time.Second", new Object[0]));
        }
        if (l4 == 0L && l3 == 0L && l2 == 0L) {
            stringBuilder.append(' ').append(l).append(GizmoRunActionHandler.getMessage("Time.Millisecond", new Object[0]));
        }
        return stringBuilder.toString();
    }

    private static String getMessage(String string, Object ... objectArray) {
        return NbBundle.getMessage(GizmoRunActionHandler.class, (String)string, (Object[])objectArray);
    }
}

