/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.addr2line;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.gizmo.addr2line.RangeMap;
import org.netbeans.modules.cnd.gizmo.addr2line.SectionFinder;

public class Dwarf2NameFinder {
    private static final Logger logger = Logger.getLogger(Dwarf2NameFinder.class.getName());
    private static final String DEBUG_LINE = ".debug_line";
    private String binaryFile;
    private String sourceFile = null;
    private int lineNumber = -1;
    private MappedByteBuffer dw2;
    private final RangeMap cache = new RangeMap();
    private static final int DW_LNS_extended_op = 0;
    private static final int DW_LNS_copy = 1;
    private static final int DW_LNS_advance_pc = 2;
    private static final int DW_LNS_advance_line = 3;
    private static final int DW_LNS_set_file = 4;
    private static final int DW_LNS_set_column = 5;
    private static final int DW_LNS_negate_stmt = 6;
    private static final int DW_LNS_set_basic_block = 7;
    private static final int DW_LNS_const_add_pc = 8;
    private static final int DW_LNS_fixed_advance_pc = 9;
    private static final int DW_LNE_end_sequence = 1;
    private static final int DW_LNE_set_address = 2;
    private static final int DW_LNE_define_file = 3;
    private static final debug DEBUG = new debug();

    public Dwarf2NameFinder(String string) {
        try {
            this.dw2 = SectionFinder.mapSection(string, DEBUG_LINE);
            this.binaryFile = string;
            this.scan();
        }
        catch (IOException iOException) {
            this.dw2 = null;
            this.binaryFile = null;
            return;
        }
    }

    public void lookup(long l) {
        this.lookup(l, false);
    }

    private void scan() {
        this.lookup(-1L, true);
    }

    private void lookup(long l, boolean bl) {
        this.lineNumber = -1;
        this.sourceFile = null;
        if (this.dw2 == null) {
            return;
        }
        CacheEntry cacheEntry = (CacheEntry)this.cache.get(l);
        if (cacheEntry != null && this.interpret(l, cacheEntry.section, cacheEntry.fileNames, cacheEntry.header, false)) {
            return;
        }
        this.dw2.position(0);
        this.dw2.limit(this.dw2.capacity());
        while (this.dw2.hasRemaining()) {
            Object object;
            String string;
            int n = this.dw2.position();
            dw2_debug_line dw2_debug_line2 = new dw2_debug_line();
            dw2_debug_line2.get(this.dw2);
            int n2 = (int)((long)n + dw2_debug_line2.total_length + 4L);
            int n3 = (int)((long)n + dw2_debug_line2.prologue_length + 9L);
            if (dw2_debug_line2.version != 2 || dw2_debug_line2.opcode_base != 10) {
                this.dw2.position(n2);
                continue;
            }
            this.dw2.limit(n3);
            ByteBuffer byteBuffer = this.dw2.slice();
            while ((string = Dwarf2NameFinder.getString(byteBuffer)).length() > 0) {
            }
            LinkedList<String> linkedList = new LinkedList<String>();
            while (byteBuffer.hasRemaining()) {
                object = Dwarf2NameFinder.getString(byteBuffer);
                linkedList.add((String)object);
                long l2 = Dwarf2NameFinder.getUleb128(byteBuffer);
                long l3 = Dwarf2NameFinder.getUleb128(byteBuffer);
                long l4 = Dwarf2NameFinder.getUleb128(byteBuffer);
            }
            byteBuffer = null;
            this.dw2.limit(n2);
            this.dw2.position(n3 + 1);
            object = this.dw2.slice();
            this.dw2.limit(this.dw2.capacity());
            this.dw2.position(n2);
            if (!this.interpret(l, (ByteBuffer)object, linkedList, dw2_debug_line2, bl)) continue;
            break;
        }
    }

    private boolean interpret(long l, ByteBuffer byteBuffer, LinkedList linkedList, dw2_debug_line dw2_debug_line2, boolean bl) {
        long l2 = 0L;
        long l3 = 0L;
        String string = null;
        int n = 0;
        int n2 = 1;
        int n3 = 0;
        int n4 = 1;
        int n5 = 245 / dw2_debug_line2.line_range;
        long l4 = -1L;
        long l5 = 0L;
        byteBuffer.position(0);
        byteBuffer.limit(byteBuffer.capacity());
        block17: while (byteBuffer.hasRemaining()) {
            int n6 = byteBuffer.get() & 0xFF;
            if (n6 < dw2_debug_line2.opcode_base) {
                switch (n6) {
                    case 0: {
                        long l6 = Dwarf2NameFinder.getUleb128(byteBuffer);
                        n6 = byteBuffer.get();
                        switch (n6) {
                            case 1: {
                                if (!bl && l3 <= l && l2 > l) {
                                    this.lineNumber = n4;
                                    this.sourceFile = n3 >= 0 && n3 < linkedList.size() ? linkedList.get(n3) : string;
                                    logger.log((Level)DEBUG, "found {0}:{1} for {2}", new Object[]{this.sourceFile, this.lineNumber, Long.toHexString(l)});
                                    this.cache.put(l3, l2, new CacheEntry(linkedList, byteBuffer, dw2_debug_line2));
                                    return true;
                                }
                                if (bl && l4 != -1L && l5 != 0L) {
                                    this.cache.put(l4, l5, new CacheEntry(linkedList, byteBuffer, dw2_debug_line2));
                                    l4 = -1L;
                                    l5 = 0L;
                                }
                                n2 = 1;
                                n4 = 1;
                                n = 0;
                                n3 = 0;
                                l2 = 0L;
                                l3 = 0L;
                                break;
                            }
                            case 2: {
                                l3 = byteBuffer.get() & 0xFF;
                                l3 |= ((long)byteBuffer.get() & 0xFFL) << 8;
                                l3 |= ((long)byteBuffer.get() & 0xFFL) << 16;
                                l2 = l3 |= ((long)byteBuffer.get() & 0xFFL) << 24;
                                if (bl || l2 <= l) break;
                                return false;
                            }
                            case 3: {
                                string = Dwarf2NameFinder.getString(byteBuffer);
                                Dwarf2NameFinder.getUleb128(byteBuffer);
                                Dwarf2NameFinder.getUleb128(byteBuffer);
                                Dwarf2NameFinder.getUleb128(byteBuffer);
                                break;
                            }
                            default: {
                                byteBuffer.position(byteBuffer.position() + (int)l6);
                            }
                        }
                    }
                    case 1: {
                        if (!bl && l3 <= l && l2 > l) {
                            this.lineNumber = n4;
                            this.sourceFile = n3 >= 0 && n3 < linkedList.size() ? linkedList.get(n3) : string;
                            logger.log((Level)DEBUG, "found {0}:{1} for {2}", new Object[]{this.sourceFile, this.lineNumber, Long.toHexString(l)});
                            this.cache.put(l3, l2, new CacheEntry(linkedList, byteBuffer, dw2_debug_line2));
                            return true;
                        }
                        n4 = n2;
                        n3 = n;
                        break;
                    }
                    case 2: {
                        long l7 = Dwarf2NameFinder.getUleb128(byteBuffer);
                        l2 += l7 * (long)dw2_debug_line2.minimum_instruction_length;
                        if (!bl) continue block17;
                        if (Dwarf2NameFinder.ucomp(l4, l2) > 0) {
                            l4 = l2;
                        }
                        if (Dwarf2NameFinder.ucomp(l5, l2) >= 0) continue block17;
                        l5 = l2;
                        break;
                    }
                    case 3: {
                        long l8 = Dwarf2NameFinder.getSleb128(byteBuffer);
                        n4 = n2;
                        n2 += (int)l8;
                        break;
                    }
                    case 4: {
                        n3 = n;
                        n = (int)Dwarf2NameFinder.getUleb128(byteBuffer) - 1;
                        break;
                    }
                    case 5: {
                        Dwarf2NameFinder.getUleb128(byteBuffer);
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 7: {
                        break;
                    }
                    case 8: {
                        l2 += (long)n5;
                        if (!bl) break;
                        if (Dwarf2NameFinder.ucomp(l4, l2) > 0) {
                            l4 = l2;
                        }
                        if (Dwarf2NameFinder.ucomp(l5, l2) >= 0) break;
                        l5 = l2;
                        break;
                    }
                    case 9: {
                        int n7 = byteBuffer.getShort() & 0xFFFF;
                        l2 += (long)n7;
                    }
                }
                continue;
            }
            int n8 = (n6 & 0xFF) - dw2_debug_line2.opcode_base;
            int n9 = n8 / dw2_debug_line2.line_range;
            int n10 = dw2_debug_line2.line_base + n8 % dw2_debug_line2.line_range;
            long l9 = l2 + (long)n9;
            int n11 = n2 + n10;
            if (!bl && l3 <= l && l9 >= l) {
                this.lineNumber = l9 == l ? n11 : n2;
                this.sourceFile = n >= 0 && n < linkedList.size() ? linkedList.get(n) : string;
                logger.log((Level)DEBUG, "found {0}:{1} for {2}", new Object[]{this.sourceFile, this.lineNumber, Long.toHexString(l)});
                this.cache.put(l3, l9, new CacheEntry(linkedList, byteBuffer, dw2_debug_line2));
                return true;
            }
            n4 = n2;
            n3 = n;
            n2 = n11;
            l2 = l9;
            if (!bl) continue;
            if (Dwarf2NameFinder.ucomp(l4, l2) > 0) {
                l4 = l2;
            }
            if (Dwarf2NameFinder.ucomp(l5, l2) >= 0) continue;
            l5 = l2;
        }
        if (bl && l4 != -1L && l5 != 0L) {
            this.cache.put(l4, l5, new CacheEntry(linkedList, byteBuffer, dw2_debug_line2));
        }
        return false;
    }

    public void close() {
        this.dw2 = null;
        this.binaryFile = null;
    }

    public String getSourceFile() {
        return this.sourceFile;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    private static String getString(ByteBuffer byteBuffer) {
        int n = byteBuffer.position();
        int n2 = 0;
        while (byteBuffer.get() != 0) {
            ++n2;
        }
        byte[] byArray = new byte[n2];
        byteBuffer.position(n);
        byteBuffer.get(byArray);
        byteBuffer.get();
        return new String(byArray);
    }

    private static long getUleb128(ByteBuffer byteBuffer) {
        long l = 0L;
        int n = 0;
        while (true) {
            byte by = byteBuffer.get();
            l |= (long)((by & 0x7F) << n);
            if ((by & 0x80) == 0) break;
            n += 7;
        }
        return l;
    }

    private static long getSleb128(ByteBuffer byteBuffer) {
        byte by;
        long l = 0L;
        int n = 0;
        int n2 = 64;
        do {
            by = byteBuffer.get();
            l |= (long)((by & 0x7F) << n);
            n += 7;
        } while ((by & 0x80) != 0);
        if (n < n2 && (by & 0x40) != 0) {
            l |= (long)(-(1 << n));
        }
        return l;
    }

    static int ucomp(long l, long l2) {
        if (l == l2) {
            return 0;
        }
        if (l < 0L) {
            if (l2 < 0L) {
                if (l < l2) {
                    return 1;
                }
                return -1;
            }
            return 1;
        }
        if (l2 >= 0L) {
            if (l < l2) {
                return -1;
            }
            return 1;
        }
        return -1;
    }

    private static class CacheEntry {
        final dw2_debug_line header;
        final LinkedList fileNames;
        final ByteBuffer section;

        CacheEntry(LinkedList linkedList, ByteBuffer byteBuffer, dw2_debug_line dw2_debug_line2) {
            this.fileNames = linkedList;
            this.section = byteBuffer;
            this.header = dw2_debug_line2;
        }
    }

    private static class dw2_debug_line {
        long total_length;
        int version;
        long prologue_length;
        int minimum_instruction_length;
        boolean default_is_stmt;
        byte line_base;
        int line_range;
        int opcode_base;
        final byte[] standard_opcode_lengths = new byte[9];

        private dw2_debug_line() {
        }

        private void get(ByteBuffer byteBuffer) {
            this.total_length = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            this.version = byteBuffer.getShort() & 0xFFFF;
            this.prologue_length = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
            this.minimum_instruction_length = byteBuffer.get() & 0xFF;
            this.default_is_stmt = byteBuffer.get() != 0;
            this.line_base = byteBuffer.get();
            this.line_range = byteBuffer.get() & 0xFF;
            this.opcode_base = byteBuffer.get() & 0xFF;
            byteBuffer.get(this.standard_opcode_lengths);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer(super.toString());
            stringBuffer.append(" [ total_length: ").append(this.total_length);
            stringBuffer.append("; version: ").append(this.version);
            stringBuffer.append("; prologue_length: ").append(this.prologue_length);
            stringBuffer.append("; minimum_instruction_length: ").append(this.minimum_instruction_length);
            stringBuffer.append("; default_is_stmt: ").append(this.default_is_stmt);
            stringBuffer.append("; line_base: ").append(this.line_base);
            stringBuffer.append("; line_range: ").append(this.line_range);
            stringBuffer.append("; opcode_base: ").append(this.opcode_base);
            stringBuffer.append("; standard_opcode_lengths: { ");
            stringBuffer.append(this.standard_opcode_lengths[0]).append(", ");
            stringBuffer.append(this.standard_opcode_lengths[1]).append(", ");
            stringBuffer.append(this.standard_opcode_lengths[2]).append(", ");
            stringBuffer.append(this.standard_opcode_lengths[3]).append(", ");
            stringBuffer.append(this.standard_opcode_lengths[4]).append(", ");
            stringBuffer.append(this.standard_opcode_lengths[5]).append(", ");
            stringBuffer.append(this.standard_opcode_lengths[6]).append(", ");
            stringBuffer.append(this.standard_opcode_lengths[7]).append(", ");
            stringBuffer.append(this.standard_opcode_lengths[8]).append(" } ]");
            return stringBuffer.toString();
        }
    }

    private static final class debug
    extends Level {
        private debug() {
            super("DWARF-2", Level.INFO.intValue());
        }
    }
}

