/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gizmo.ui;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.event.ActionEvent;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.FocusManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.gizmo.ui.GizmoIndicatorTopComponentRegsitry;
import org.netbeans.modules.cnd.gizmo.ui.GizmoIndicatorsTopComponentActionsProvider;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorComponentEmptyContentProvider;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GizmoIndicatorsTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static GizmoIndicatorsTopComponent instance;
    private DLightSession session;
    static final String ICON_PATH = "org/netbeans/modules/dlight/core/ui/resources/indicators_small.png";
    private static final String PREFERRED_ID = "GizmoIndicatorsTopComponent";
    private static final AtomicInteger index;
    private final CardLayout cardLayout = new CardLayout();
    private JPanel cardsLayoutPanel;
    private JPanel panel1;
    private JPanel panel2;
    private Vector<JComponent> indicatorPanels = null;
    private boolean showFirstPanel = true;
    private boolean dock;
    private final ExplorerManager manager = new ExplorerManager();
    private JComponent lastFocusedComponent = null;
    private final FocusTraversalPolicy focusPolicy = new FocusTraversalPolicyImpl();
    private GizmoIndicatorsTopComponentActionsProvider actionsProvider = null;
    private final PopupAction popupAction = new PopupAction("popupGizmoIndicatorTopComponentAction");

    private GizmoIndicatorsTopComponent(boolean bl) {
        this.initComponents();
        this.dock = bl;
        this.setSession(null);
        this.setName(GizmoIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent", new Object[0]));
        this.setToolTipText(GizmoIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent", new Object[0]));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        if (bl && (WindowManager.getDefault().findMode((TopComponent)this) == null || WindowManager.getDefault().findMode((TopComponent)this).getName().equals("navigator")) && WindowManager.getDefault().findMode("navigator") != null) {
            WindowManager.getDefault().findMode("navigator").dockInto((TopComponent)this);
        }
        this.setFocusTraversalPolicyProvider(true);
        this.setFocusTraversalPolicy(this.focusPolicy);
        ActionMap actionMap = new ActionMap();
        actionMap.put("org.openide.actions.PopupAction", this.popupAction);
        this.associateLookup(ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)actionMap));
        this.installActions();
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    void setActionsProvider(GizmoIndicatorsTopComponentActionsProvider gizmoIndicatorsTopComponentActionsProvider) {
        this.actionsProvider = gizmoIndicatorsTopComponentActionsProvider;
    }

    private Action getPopupAction() {
        return null;
    }

    private GizmoIndicatorsTopComponent() {
        this(false);
    }

    void initComponents() {
        this.cardsLayoutPanel = new JPanel(this.cardLayout);
        this.panel1 = new JPanel();
        this.panel2 = new JPanel();
        this.cardsLayoutPanel.add((Component)this.panel1, "#1");
        this.cardsLayoutPanel.add((Component)this.panel2, "#2");
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.cardsLayoutPanel);
    }

    void installActions() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0, true);
        this.getInputMap(2).put(keyStroke, "return");
        this.getActionMap().put("return", new ESCHandler());
    }

    void setActive() {
        this.cardLayout.show(this.cardsLayoutPanel, this.showFirstPanel ? "#1" : "#2");
        this.showFirstPanel = !this.showFirstPanel;
    }

    JPanel getNextPanel() {
        return this.showFirstPanel ? this.panel1 : this.panel2;
    }

    private JPanel getCurrentPanel() {
        return this.showFirstPanel ? this.panel2 : this.panel1;
    }

    public void setSession(DLightSession dLightSession) {
        if (this.session != null && this.session != dLightSession) {
            DLightManager.getDefault().closeSessionOnExit(this.session);
        }
        this.session = dLightSession;
        List list = null;
        if (dLightSession != null) {
            this.setDisplayName(GizmoIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent.withSession", dLightSession.getDisplayName()));
            this.setToolTipText(GizmoIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent.withSession", dLightSession.getDisplayName()));
            list = dLightSession.getIndicators();
        } else {
            this.setDisplayName(GizmoIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent", new Object[0]));
            this.setToolTipText(GizmoIndicatorsTopComponent.getMessage("CTL_DLightIndicatorsTopComponent", new Object[0]));
            IndicatorComponentEmptyContentProvider indicatorComponentEmptyContentProvider = (IndicatorComponentEmptyContentProvider)Lookup.getDefault().lookup(IndicatorComponentEmptyContentProvider.class);
            if (indicatorComponentEmptyContentProvider != null) {
                list = indicatorComponentEmptyContentProvider.getEmptyContent();
            }
        }
        Collections.sort(list, new Comparator<Indicator>(){

            @Override
            public int compare(Indicator indicator, Indicator indicator2) {
                if (indicator.getPosition() < indicator2.getPosition()) {
                    return -1;
                }
                if (indicator2.getPosition() < indicator.getPosition()) {
                    return 1;
                }
                return 0;
            }
        });
        this.setContent(list);
    }

    private void setContent(List<Indicator> list) {
        JComponent jComponent;
        JComponent jComponent2;
        if (list != null) {
            jComponent2 = new JScrollPane();
            jComponent2.setBorder(BorderFactory.createEmptyBorder());
            JSplitPane jSplitPane = null;
            this.indicatorPanels = new Vector(list.size());
            this.indicatorPanels.setSize(list.size());
            for (int i = 0; i < list.size(); ++i) {
                JComponent jComponent3 = list.get(i).getComponent();
                this.indicatorPanels.set(i, jComponent3);
                if (i + 1 < list.size()) {
                    JSplitPane jSplitPane2 = new JSplitPane(0);
                    jSplitPane2.setBorder(BorderFactory.createEmptyBorder());
                    jSplitPane2.setContinuousLayout(true);
                    jSplitPane2.setDividerSize(5);
                    jSplitPane2.setResizeWeight(1.0 / (double)(list.size() - i));
                    jSplitPane2.setTopComponent(jComponent3);
                    jComponent3 = jSplitPane2;
                }
                if (jSplitPane == null) {
                    ((JScrollPane)jComponent2).setViewportView(jComponent3);
                } else {
                    jSplitPane.setBottomComponent(jComponent3);
                }
                if (!(jComponent3 instanceof JSplitPane)) continue;
                jSplitPane = (JSplitPane)jComponent3;
            }
            jComponent = jComponent2;
        } else {
            this.indicatorPanels = null;
            jComponent2 = new JLabel(NbBundle.getMessage(GizmoIndicatorsTopComponent.class, (String)"IndicatorsTopCompinent.EmptyContent"));
            jComponent2.setAlignmentX(0.5f);
            jComponent = jComponent2;
        }
        jComponent2 = this.getNextPanel();
        jComponent2.removeAll();
        jComponent2.setLayout(new BoxLayout(jComponent2, 1));
        jComponent2.add(jComponent);
        this.setActive();
        this.repaint();
    }

    public static synchronized GizmoIndicatorsTopComponent getDefault() {
        if (instance == null) {
            instance = new GizmoIndicatorsTopComponent();
        }
        return instance;
    }

    public static synchronized GizmoIndicatorsTopComponent findInstance() {
        TopComponent topComponent = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (topComponent == null) {
            Logger.getLogger(GizmoIndicatorsTopComponent.class.getName()).warning("Cannot find GizmoIndicatorsTopComponent component. It will not be located properly in the window system.");
            return GizmoIndicatorsTopComponent.getDefault();
        }
        if (topComponent instanceof GizmoIndicatorsTopComponent) {
            return (GizmoIndicatorsTopComponent)topComponent;
        }
        Logger.getLogger(GizmoIndicatorsTopComponent.class.getName()).warning("There seem to be multiple components with the 'GizmoIndicatorsTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return GizmoIndicatorsTopComponent.getDefault();
    }

    public static synchronized GizmoIndicatorsTopComponent newInstance() {
        return new GizmoIndicatorsTopComponent(true);
    }

    public int getPersistenceType() {
        if (!this.dock) {
            return 0;
        }
        return 2;
    }

    public void componentOpened() {
    }

    protected void componentDeactivated() {
        super.componentDeactivated();
        this.lastFocusedComponent = null;
        if (this.indicatorPanels == null || this.indicatorPanels.size() == 0) {
            return;
        }
        for (JComponent jComponent : this.indicatorPanels) {
            if (!jComponent.hasFocus()) continue;
            this.lastFocusedComponent = jComponent;
            break;
        }
        if (this.lastFocusedComponent == null) {
            this.lastFocusedComponent = this.indicatorPanels.get(0);
        }
    }

    protected void componentActivated() {
        super.componentActivated();
        if (this.lastFocusedComponent != null) {
            this.lastFocusedComponent.requestFocus();
        } else {
            this.focusPolicy.getFirstComponent((Container)((Object)this)).requestFocus();
        }
    }

    public void componentClosed() {
        if (this.session != null) {
            DLightManager.getDefault().closeSessionOnExit(this.session);
        }
        super.componentClosed();
    }

    DLightSession getSession() {
        return this.session;
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        if (!this.dock) {
            return PREFERRED_ID;
        }
        return PREFERRED_ID + index.incrementAndGet();
    }

    private static String getMessage(String string, Object ... objectArray) {
        return NbBundle.getMessage(GizmoIndicatorsTopComponent.class, (String)string, (Object[])objectArray);
    }

    static {
        index = new AtomicInteger();
        GizmoIndicatorTopComponentRegsitry.getRegistry();
    }

    private class ESCHandler
    extends AbstractAction {
        private ESCHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Component component = FocusManager.getCurrentManager().getFocusOwner();
            if (GizmoIndicatorTopComponentRegsitry.getRegistry().getActivated() == null || component == null || !SwingUtilities.isDescendingFrom(component, (Component)((Object)GizmoIndicatorsTopComponent.this))) {
                return;
            }
            TopComponent topComponent = GizmoIndicatorTopComponentRegsitry.getRegistry().getActivatedNonIndicators();
            if (topComponent != null) {
                topComponent.requestActive();
            }
        }
    }

    private class PopupAction
    extends AbstractAction
    implements Runnable {
        private PopupAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SwingUtilities.invokeLater(this);
        }

        public void run() {
            if (GizmoIndicatorsTopComponent.this.actionsProvider == null) {
                return;
            }
            Action[] actionArray = GizmoIndicatorsTopComponent.this.actionsProvider.getActions(GizmoIndicatorsTopComponent.this);
            if (actionArray != null && actionArray.length > 0) {
                JPopupMenu jPopupMenu = Utilities.actionsToPopup((Action[])actionArray, (Component)((Object)GizmoIndicatorsTopComponent.this));
                jPopupMenu.show((Component)((Object)GizmoIndicatorsTopComponent.this), 0, 0);
            }
        }
    }

    private final class FocusTraversalPolicyImpl
    extends FocusTraversalPolicy {
        private FocusTraversalPolicyImpl() {
        }

        public Component getComponentAfter(Container container, Component component) {
            if (component == GizmoIndicatorsTopComponent.this.getCurrentPanel()) {
                return GizmoIndicatorsTopComponent.this.getCurrentPanel();
            }
            int n = GizmoIndicatorsTopComponent.this.indicatorPanels.indexOf(component);
            if (n == -1) {
                return GizmoIndicatorsTopComponent.this.getCurrentPanel();
            }
            if (n == GizmoIndicatorsTopComponent.this.indicatorPanels.size() - 1) {
                return (Component)GizmoIndicatorsTopComponent.this.indicatorPanels.get(0);
            }
            return (Component)GizmoIndicatorsTopComponent.this.indicatorPanels.get(n + 1);
        }

        public Component getComponentBefore(Container container, Component component) {
            if (component == GizmoIndicatorsTopComponent.this.getCurrentPanel()) {
                return GizmoIndicatorsTopComponent.this.getCurrentPanel();
            }
            int n = GizmoIndicatorsTopComponent.this.indicatorPanels.indexOf(component);
            if (n == -1) {
                return GizmoIndicatorsTopComponent.this.getCurrentPanel();
            }
            if (n == 0) {
                return (Component)GizmoIndicatorsTopComponent.this.indicatorPanels.get(GizmoIndicatorsTopComponent.this.indicatorPanels.size() - 1);
            }
            return (Component)GizmoIndicatorsTopComponent.this.indicatorPanels.get(n - 1);
        }

        public Component getFirstComponent(Container container) {
            if (GizmoIndicatorsTopComponent.this.indicatorPanels == null || GizmoIndicatorsTopComponent.this.indicatorPanels.size() == 0) {
                return GizmoIndicatorsTopComponent.this.getCurrentPanel();
            }
            return (Component)GizmoIndicatorsTopComponent.this.indicatorPanels.get(0);
        }

        public Component getLastComponent(Container container) {
            if (GizmoIndicatorsTopComponent.this.indicatorPanels == null || GizmoIndicatorsTopComponent.this.indicatorPanels.size() == 0) {
                return GizmoIndicatorsTopComponent.this.getCurrentPanel();
            }
            return (Component)GizmoIndicatorsTopComponent.this.indicatorPanels.get(GizmoIndicatorsTopComponent.this.indicatorPanels.size() - 1);
        }

        public Component getDefaultComponent(Container container) {
            if (GizmoIndicatorsTopComponent.this.indicatorPanels == null || GizmoIndicatorsTopComponent.this.indicatorPanels.size() == 0) {
                return GizmoIndicatorsTopComponent.this.getCurrentPanel();
            }
            return (Component)GizmoIndicatorsTopComponent.this.indicatorPanels.get(0);
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return GizmoIndicatorsTopComponent.getDefault();
        }
    }
}

