/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.InstanceRemovedException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.persistence.provider.Provider;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.spi.provider.PersistenceProviderSupplier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenPersistenceProviderSupplier
implements PersistenceProviderSupplier {
    private final Project project;

    public MavenPersistenceProviderSupplier(Project project) {
        this.project = project;
    }

    public List<Provider> getSupportedProviders() {
        Object object;
        J2eePlatform j2eePlatform = null;
        try {
            object = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
            j2eePlatform = Deployment.getDefault().getServerInstance(object.getServerInstanceID()).getJ2eePlatform();
            if (j2eePlatform == null) {
                return Collections.emptyList();
            }
        }
        catch (InstanceRemovedException instanceRemovedException) {
            return Collections.emptyList();
        }
        object = new ArrayList();
        this.addPersistenceProvider(ProviderUtil.HIBERNATE_PROVIDER, "hibernatePersistenceProviderIsDefault", j2eePlatform, (List<Provider>)object);
        this.addPersistenceProvider(ProviderUtil.TOPLINK_PROVIDER, "toplinkPersistenceProviderIsDefault", j2eePlatform, (List<Provider>)object);
        this.addPersistenceProvider(ProviderUtil.KODO_PROVIDER, "kodoPersistenceProviderIsDefault", j2eePlatform, (List<Provider>)object);
        this.addPersistenceProvider(ProviderUtil.OPENJPA_PROVIDER, "openJpaPersistenceProviderIsDefault", j2eePlatform, (List<Provider>)object);
        this.addPersistenceProvider(ProviderUtil.ECLIPSELINK_PROVIDER, "eclipseLinkPersistenceProviderIsDefault", j2eePlatform, (List<Provider>)object);
        return object;
    }

    private void addPersistenceProvider(Provider provider, String string, J2eePlatform j2eePlatform, List<Provider> list) {
        if (j2eePlatform.isToolSupported(provider.getProviderClass())) {
            if (j2eePlatform.isToolSupported(string)) {
                list.add(0, provider);
            } else {
                list.add(provider);
            }
        }
    }

    public boolean supportsDefaultProvider() {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)this.project.getLookup().lookup(J2eeModuleProvider.class);
        J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(j2eeModuleProvider.getServerInstanceID());
        if (j2eePlatform == null) {
            return false;
        }
        Set set = j2eePlatform.getSupportedSpecVersions(j2eeModuleProvider.getJ2eeModule().getModuleType());
        return set.contains("1.5") && j2eePlatform.isToolSupported("defaultPersistenceProviderJavaEE5");
    }
}

