/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.ear;

import hidden.org.codehaus.plexus.util.StringInputStream;
import hidden.org.codehaus.plexus.util.StringUtils;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Plugin;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.api.ejbjar.Car;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.ApplicationMetadata;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.deployment.common.api.EjbChangeDescriptor;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleChangeReporter;
import org.netbeans.modules.j2ee.deployment.devmodules.api.ModuleListener;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeApplicationImplementation;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleFactory;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleImplementation;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelFactory;
import org.netbeans.modules.j2ee.metadata.model.spi.MetadataModelImplementation;
import org.netbeans.modules.j2ee.spi.ejbjar.EarImplementation;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.embedder.NBPluginParameterExpressionEvaluator;
import org.netbeans.modules.maven.j2ee.ear.EarModuleProviderImpl;
import org.netbeans.modules.maven.j2ee.ear.NonProjectJ2eeModule;
import org.netbeans.modules.maven.j2ee.ear.model.ApplicationMetadataModelImpl;
import org.netbeans.modules.maven.spi.debug.AdditionalDebuggedProjects;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EarImpl
implements EarImplementation,
J2eeModuleImplementation,
J2eeApplicationImplementation,
ModuleChangeReporter,
AdditionalDebuggedProjects {
    private Project project;
    private EarModuleProviderImpl provider;
    private MetadataModel<ApplicationMetadata> metadataModel;
    private NbMavenProject mavenproject;

    EarImpl(Project project, EarModuleProviderImpl earModuleProviderImpl) {
        this.project = project;
        this.mavenproject = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        this.provider = earModuleProviderImpl;
    }

    public String getJ2eePlatformVersion() {
        String string = ((AuxiliaryProperties)this.project.getLookup().lookup(AuxiliaryProperties.class)).get("netbeans.hint.j2eeVersion", true);
        if (string != null) {
            return string;
        }
        if (this.isApplicationXmlGenerated()) {
            string = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"version", (String)"generate-application-xml");
            if (string != null) {
                if ("5".equals(string)) {
                    return "1.5";
                }
                return string.trim();
            }
        } else {
            DDProvider dDProvider = DDProvider.getDefault();
            FileObject fileObject = this.getDeploymentDescriptor();
            if (fileObject != null) {
                try {
                    Application application = dDProvider.getDDRoot(fileObject);
                    String string2 = application.getVersion().toString();
                    return string2;
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
            }
        }
        return "1.4";
    }

    public FileObject getMetaInf() {
        File file;
        URI uRI;
        FileObject fileObject;
        String string = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"earSourceDirectory", (String)"ear");
        if (string == null) {
            string = "src/main/application";
        }
        if ((fileObject = FileUtilities.convertURItoFileObject((URI)(uRI = FileUtilities.getDirURI((FileObject)this.project.getProjectDirectory(), (String)string)))) == null) {
            file = new File(uRI);
            file.mkdirs();
            this.project.getProjectDirectory().refresh();
            fileObject = FileUtil.toFileObject((File)file);
        }
        if (fileObject != null) {
            file = fileObject.getFileObject("META-INF");
            if (file == null) {
                try {
                    file = fileObject.createFolder("META-INF");
                }
                catch (IOException iOException) {
                    Exceptions.printStackTrace((Throwable)iOException);
                }
            }
            return file;
        }
        return null;
    }

    public FileObject getDeploymentDescriptor() {
        FileObject fileObject;
        String string;
        if (this.isApplicationXmlGenerated()) {
            string = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"generatedDescriptorLocation", (String)"generate-application-xml");
            if (string == null) {
                string = this.mavenproject.getMavenProject().getBuild().getDirectory();
            }
            if ((fileObject = FileUtilities.convertURItoFileObject((URI)FileUtilities.getDirURI((FileObject)this.project.getProjectDirectory(), (String)string))) != null) {
                return fileObject.getFileObject("application.xml");
            }
        }
        if ((string = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"applicationXml", (String)"ear")) != null && (fileObject = FileUtilities.convertURItoFileObject((URI)FileUtilities.getDirURI((FileObject)this.project.getProjectDirectory(), (String)string))) != null) {
            return fileObject;
        }
        return null;
    }

    public void addWebModule(WebModule webModule) {
        throw new IllegalStateException("Not implemented for maven based projects.");
    }

    public void addEjbJarModule(EjbJar ejbJar) {
        throw new IllegalStateException("Not implemented for maven based projects.");
    }

    private boolean isApplicationXmlGenerated() {
        String string = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"generateApplicationXml", (String)"generate-application-xml");
        return string == null || Boolean.valueOf(string) != false;
    }

    boolean isValid() {
        return true;
    }

    public Object getModuleType() {
        return J2eeModule.EAR;
    }

    public String getModuleVersion() {
        String string = this.getJ2eePlatformVersion();
        if ("1.4".equals(string)) {
            return "1.5";
        }
        return "1.4";
    }

    public String getUrl() {
        String string = "/" + this.mavenproject.getMavenProject().getBuild().getFinalName();
        return string;
    }

    public FileObject getArchive() throws IOException {
        MavenProject mavenProject = this.mavenproject.getMavenProject();
        String string = mavenProject.getBuild().getFinalName();
        String string2 = mavenProject.getBuild().getDirectory();
        File file = FileUtil.normalizeFile((File)new File(string2, string + ".ear"));
        return FileUtil.toFileObject((File)file);
    }

    public Iterator getArchiveContents() throws IOException {
        FileObject fileObject = this.getContentDirectory();
        if (fileObject != null) {
            return new ContentIterator(fileObject);
        }
        return null;
    }

    public FileObject getContentDirectory() throws IOException {
        MavenProject mavenProject = this.mavenproject.getMavenProject();
        String string = mavenProject.getBuild().getFinalName();
        String string2 = mavenProject.getBuild().getDirectory();
        File file = FileUtil.normalizeFile((File)new File(string2, string));
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            fileObject.refresh();
        }
        return FileUtil.toFileObject((File)file);
    }

    public RootInterface getDeploymentDescriptor(String string) {
        block8: {
            if ("application.xml".equals(string)) {
                string = "META-INF/application.xml";
            }
            if ("META-INF/application.xml".equals(string)) {
                try {
                    FileObject fileObject = this.getDeploymentDescriptor();
                    if (fileObject == null) {
                        StringInputStream stringInputStream = new StringInputStream("<application xmlns=\"http://java.sun.com/xml/ns/j2ee\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"http://java.sun.com/xml/ns/j2ee http://java.sun.com/xml/ns/j2ee/application_1_4.xsd\" version=\"1.4\"><description>description</description><display-name>" + this.mavenproject.getMavenProject().getArtifactId() + "</display-name></application>");
                        try {
                            return DDProvider.getDefault().getDDRoot(new InputSource((InputStream)stringInputStream));
                        }
                        catch (SAXException sAXException) {
                            sAXException.printStackTrace();
                            break block8;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                            break block8;
                        }
                    }
                    return DDProvider.getDefault().getDDRoot(fileObject);
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().log(iOException.getLocalizedMessage());
                }
            }
        }
        return null;
    }

    public J2eeModule[] getModules() {
        MavenProject mavenProject = this.mavenproject.getMavenProject();
        Set set = mavenProject.getArtifacts();
        List list = mavenProject.getRuntimeDependencies();
        String string = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"fileNameMapping", (String)"ear");
        if (string == null) {
            string = "standard";
        }
        String string2 = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)"org.apache.maven.plugins", (String)"maven-ear-plugin", (String)"defaultLibBundleDir", (String)"ear");
        ArrayList<J2eeModule> arrayList = new ArrayList<J2eeModule>();
        MavenModule[] mavenModuleArray = this.readPomModules();
        block0: for (Dependency dependency : list) {
            if (!"war".equals(dependency.getType()) && !"ejb".equals(dependency.getType())) continue;
            for (Artifact artifact : set) {
                J2eeModule j2eeModule;
                Object object;
                Project project;
                if (!artifact.getGroupId().equals(dependency.getGroupId()) || !artifact.getArtifactId().equals(dependency.getArtifactId()) || !StringUtils.equals((String)artifact.getClassifier(), (String)dependency.getClassifier())) continue;
                File file = artifact.getFile();
                FileObject fileObject = FileUtil.toFileObject((File)file);
                boolean bl = false;
                if (fileObject != null && (project = FileOwnerQuery.getOwner((FileObject)fileObject)) != null && (object = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) != null) {
                    j2eeModule = object.getJ2eeModule();
                    MavenModule mavenModule = this.findMavenModule(artifact, mavenModuleArray);
                    J2eeModule j2eeModule2 = J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation)new ProxyJ2eeModule(j2eeModule, mavenModule, string));
                    if (mavenModule.pomIndex > -1 && arrayList.size() > mavenModule.pomIndex) {
                        arrayList.add(mavenModule.pomIndex, j2eeModule2);
                    } else {
                        arrayList.add(j2eeModule2);
                    }
                    bl = true;
                }
                if (bl) continue block0;
                project = J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation)new NonProjectJ2eeModule(artifact, this.getJ2eePlatformVersion(), this.provider));
                object = this.findMavenModule(artifact, mavenModuleArray);
                j2eeModule = J2eeModuleFactory.createJ2eeModule((J2eeModuleImplementation)new ProxyJ2eeModule((J2eeModule)project, (MavenModule)object, string));
                if (object.pomIndex > -1 && arrayList.size() > object.pomIndex) {
                    arrayList.add(object.pomIndex, j2eeModule);
                    continue block0;
                }
                arrayList.add(j2eeModule);
                continue block0;
            }
        }
        return arrayList.toArray(new J2eeModule[arrayList.size()]);
    }

    public List<Project> getProjects() {
        Iterator iterator = this.mavenproject.getMavenProject().getArtifacts().iterator();
        ArrayList<Project> arrayList = new ArrayList<Project>();
        while (iterator.hasNext()) {
            J2eeModuleProvider j2eeModuleProvider;
            File file;
            Project project;
            Artifact artifact = (Artifact)iterator.next();
            if (!"war".equals(artifact.getType()) && !"ejb".equals(artifact.getType()) || (project = FileOwnerQuery.getOwner((URI)(file = artifact.getFile()).toURI())) == null || (j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class)) == null) continue;
            arrayList.add(project);
        }
        return arrayList;
    }

    File getDDFile(String string) {
        URI uRI = this.mavenproject.getEarAppDirectory();
        File file = new File(new File(uRI), string);
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        file = FileUtil.normalizeFile((File)file);
        return file;
    }

    public void addModuleListener(ModuleListener moduleListener) {
    }

    public void removeModuleListener(ModuleListener moduleListener) {
    }

    public EjbChangeDescriptor getEjbChanges(long l) {
        return new EjbChange();
    }

    public boolean isManifestChanged(long l) {
        return false;
    }

    public void addCarModule(Car car) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public File getResourceDirectory() {
        File file = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "src" + File.separator + "main" + File.separator + "setup");
        return file;
    }

    public File getDeploymentConfigurationFile(String string) {
        if (string == null) {
            return null;
        }
        String string2 = this.provider.getConfigSupport().getContentRelativePath(string);
        if (string2 == null) {
            string2 = string;
        }
        return this.getDDFile(string2);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
    }

    public synchronized MetadataModel<ApplicationMetadata> getMetadataModel() {
        if (this.metadataModel == null) {
            this.metadataModel = MetadataModelFactory.createMetadataModel((MetadataModelImplementation)new ApplicationMetadataModelImpl(this.project));
        }
        return this.metadataModel;
    }

    public <T> MetadataModel<T> getMetadataModel(Class<T> clazz) {
        if (clazz == ApplicationMetadata.class) {
            MetadataModel<ApplicationMetadata> metadataModel = this.getMetadataModel();
            return metadataModel;
        }
        return null;
    }

    private MavenModule findMavenModule(Artifact artifact, MavenModule[] mavenModuleArray) {
        MavenModule mavenModule = null;
        for (MavenModule mavenModule2 : mavenModuleArray) {
            if (!artifact.getGroupId().equals(mavenModule2.groupId) || !artifact.getArtifactId().equals(mavenModule2.artifactId)) continue;
            mavenModule2.artifact = artifact;
            mavenModule = mavenModule2;
            break;
        }
        if (mavenModule == null) {
            mavenModule = new MavenModule();
            mavenModule.artifact = artifact;
            mavenModule.groupId = artifact.getGroupId();
            mavenModule.artifactId = artifact.getArtifactId();
            mavenModule.classifier = artifact.getClassifier();
        }
        return mavenModule;
    }

    private MavenModule[] readPomModules() {
        Plugin plugin;
        MavenProject mavenProject = this.mavenproject.getMavenProject();
        MavenModule[] mavenModuleArray = new MavenModule[]{};
        if (mavenProject.getBuildPlugins() == null) {
            return mavenModuleArray;
        }
        for (Object e : mavenProject.getBuildPlugins()) {
            plugin = (Plugin)e;
            if (!"maven-ear-plugin".equals(plugin.getArtifactId()) || !"org.apache.maven.plugins".equals(plugin.getGroupId())) continue;
            mavenModuleArray = this.checkConfiguration(mavenProject, plugin.getConfiguration());
        }
        if (mavenModuleArray == null && mavenProject.getPluginManagement() != null) {
            for (Object e : mavenProject.getPluginManagement().getPlugins()) {
                plugin = (Plugin)e;
                if (!"maven-ear-plugin".equals(plugin.getArtifactId()) || !"org.apache.maven.plugins".equals(plugin.getGroupId())) continue;
                mavenModuleArray = this.checkConfiguration(mavenProject, plugin.getConfiguration());
                break;
            }
        }
        return mavenModuleArray;
    }

    private MavenModule[] checkConfiguration(MavenProject mavenProject, Object object) {
        ArrayList<MavenModule> arrayList = new ArrayList<MavenModule>();
        if (object != null && object instanceof Xpp3Dom) {
            NBPluginParameterExpressionEvaluator nBPluginParameterExpressionEvaluator = new NBPluginParameterExpressionEvaluator(mavenProject, EmbedderFactory.getProjectEmbedder().getSettings(), new Properties());
            Xpp3Dom xpp3Dom = (Xpp3Dom)object;
            Xpp3Dom xpp3Dom2 = xpp3Dom.getChild("modules");
            if (xpp3Dom2 != null) {
                int n = 0;
                for (Xpp3Dom xpp3Dom3 : xpp3Dom2.getChildren()) {
                    MavenModule mavenModule = new MavenModule();
                    mavenModule.type = xpp3Dom3.getName();
                    if (xpp3Dom3.getChildren() != null) {
                        for (Xpp3Dom xpp3Dom4 : xpp3Dom3.getChildren()) {
                            String string = xpp3Dom4.getValue();
                            if (string == null) continue;
                            try {
                                Object object2 = nBPluginParameterExpressionEvaluator.evaluate(string.trim());
                                string = object2 != null ? "" + object2 : string.trim();
                            }
                            catch (ExpressionEvaluationException expressionEvaluationException) {
                                // empty catch block
                            }
                            if ("groupId".equals(xpp3Dom4.getName())) {
                                mavenModule.groupId = string;
                                continue;
                            }
                            if ("artifactId".equals(xpp3Dom4.getName())) {
                                mavenModule.artifactId = string;
                                continue;
                            }
                            if ("artifactId".equals(xpp3Dom4.getName())) {
                                mavenModule.artifactId = string;
                                continue;
                            }
                            if ("classifier".equals(xpp3Dom4.getName())) {
                                mavenModule.classifier = string;
                                continue;
                            }
                            if ("uri".equals(xpp3Dom4.getName())) {
                                mavenModule.uri = string;
                                continue;
                            }
                            if ("bundleDir".equals(xpp3Dom4.getName())) {
                                mavenModule.bundleDir = string;
                                continue;
                            }
                            if ("bundleFileName".equals(xpp3Dom4.getName())) {
                                mavenModule.bundleFileName = string;
                                continue;
                            }
                            if (!"excluded".equals(xpp3Dom4.getName())) continue;
                            mavenModule.excluded = Boolean.valueOf(string);
                        }
                    }
                    mavenModule.pomIndex = n++;
                    arrayList.add(mavenModule);
                }
            }
        }
        return arrayList.toArray(new MavenModule[0]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ProxyJ2eeModule
    implements J2eeModuleImplementation {
        private J2eeModule module;
        private MavenModule mavenModule;
        private String fileNameMapping;

        ProxyJ2eeModule(J2eeModule j2eeModule, MavenModule mavenModule, String string) {
            this.mavenModule = mavenModule;
            this.module = j2eeModule;
            this.fileNameMapping = string;
        }

        public String getModuleVersion() {
            return this.module.getModuleVersion();
        }

        public Object getModuleType() {
            return this.module.getModuleType();
        }

        public String getUrl() {
            return this.mavenModule.resolveUri(this.fileNameMapping);
        }

        public FileObject getArchive() throws IOException {
            return this.module.getArchive();
        }

        public Iterator getArchiveContents() throws IOException {
            return this.module.getArchiveContents();
        }

        public FileObject getContentDirectory() throws IOException {
            return this.module.getContentDirectory();
        }

        public <T> MetadataModel<T> getMetadataModel(Class<T> clazz) {
            return this.module.getMetadataModel(clazz);
        }

        public File getResourceDirectory() {
            return this.module.getResourceDirectory();
        }

        public File getDeploymentConfigurationFile(String string) {
            return this.module.getDeploymentConfigurationFile(string);
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.module.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.module.removePropertyChangeListener(propertyChangeListener);
        }

        public boolean equals(Object object) {
            return this.module.equals(object);
        }

        public int hashCode() {
            return this.module.hashCode();
        }
    }

    private static class MavenModule {
        String uri;
        Artifact artifact;
        String groupId;
        String artifactId;
        String type;
        String classifier;
        String bundleDir;
        String bundleFileName;
        int pomIndex = -1;
        boolean excluded = false;

        private MavenModule() {
        }

        String resolveUri(String string) {
            if (this.uri != null) {
                return this.uri;
            }
            String string2 = this.resolveBundleDir();
            return string2 + this.resolveBundleName(string);
        }

        String resolveBundleDir() {
            String string = this.bundleDir;
            if (string != null) {
                if ((string = string.replace('\\', '/')).startsWith("/")) {
                    string = string.substring(1, string.length());
                }
                if (string.length() > 0 && !string.endsWith("/")) {
                    string = string + "/";
                }
                return string;
            }
            return "";
        }

        String resolveBundleName(String string) {
            if (this.bundleFileName != null) {
                return this.bundleFileName;
            }
            if ("standard".equals(string)) {
                return this.artifact.getFile().getName();
            }
            if ("full".equals(string)) {
                String string2 = this.groupId.replace('.', '-');
                return string2 + "-" + this.artifact.getFile().getName();
            }
            return this.artifact.getFile().getName();
        }
    }

    private class EjbChange
    implements EjbChangeDescriptor {
        private EjbChange() {
        }

        public boolean ejbsChanged() {
            return false;
        }

        public String[] getChangedEjbs() {
            return new String[0];
        }
    }

    private static final class FSRootRE
    implements J2eeModule.RootedEntry {
        private FileObject f;
        private FileObject root;

        FSRootRE(FileObject fileObject, FileObject fileObject2) {
            this.f = fileObject2;
            this.root = fileObject;
        }

        public FileObject getFileObject() {
            return this.f;
        }

        public String getRelativePath() {
            return FileUtil.getRelativePath((FileObject)this.root, (FileObject)this.f);
        }
    }

    private static final class ContentIterator
    implements Iterator {
        private ArrayList<FileObject> ch = new ArrayList();
        private FileObject root;

        private ContentIterator(FileObject fileObject) {
            this.ch.add(fileObject);
            this.root = fileObject;
        }

        public boolean hasNext() {
            return !this.ch.isEmpty();
        }

        public Object next() {
            FileObject fileObject = this.ch.get(0);
            this.ch.remove(0);
            if (fileObject.isFolder()) {
                fileObject.refresh();
                FileObject[] fileObjectArray = fileObject.getChildren();
                for (int i = 0; i < fileObjectArray.length; ++i) {
                    this.ch.add(fileObjectArray[i]);
                }
            }
            return new FSRootRE(this.root, fileObject);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

