/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.j2ee.web;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.maven.api.customizer.ModelHandle;
import org.netbeans.modules.maven.api.customizer.support.ComboBoxUpdater;
import org.netbeans.modules.maven.execute.model.ActionToGoalMapping;
import org.netbeans.modules.maven.execute.model.NetbeansActionMapping;
import org.netbeans.modules.maven.j2ee.POHImpl;
import org.netbeans.modules.maven.j2ee.SessionContent;
import org.netbeans.modules.maven.j2ee.Wrapper;
import org.netbeans.modules.maven.j2ee.web.WebModuleProviderImpl;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class WebRunCustomizerPanel
extends JPanel {
    private static final String PROP_CLIENT_URL_PART = "netbeans.deploy.clientUrlPart";
    public static final String PROP_SHOW_IN_BROWSER = "netbeans.deploy.showBrowser";
    private Project project;
    private ModelHandle handle;
    private WebModule module;
    private WebModuleProviderImpl moduleProvider;
    private NetbeansActionMapping run;
    private NetbeansActionMapping debug;
    private NetbeansActionMapping profile;
    private boolean isRunCompatible;
    private boolean isDebugCompatible;
    private boolean isProfileCompatible;
    private String oldUrl;
    private ComboBoxUpdater<Wrapper> listener;
    private JCheckBox cbBrowser;
    private JComboBox comServer;
    private JLabel lblContextPath;
    private JLabel lblHint1;
    private JLabel lblHint2;
    private JLabel lblJ2EEVersion;
    private JLabel lblRelativeUrl;
    private JLabel lblServer;
    private JTextField txtContextPath;
    private JTextField txtJ2EEVersion;
    private JTextField txtRelativeUrl;

    public WebRunCustomizerPanel(ModelHandle modelHandle, Project project) {
        this.initComponents();
        this.handle = modelHandle;
        this.project = project;
        this.module = WebModule.getWebModule((FileObject)project.getProjectDirectory());
        this.moduleProvider = (WebModuleProviderImpl)((Object)project.getLookup().lookup(WebModuleProviderImpl.class));
        assert (this.moduleProvider != null);
        assert (this.module != null);
        this.loadComboModel();
        if (this.module != null) {
            this.txtJ2EEVersion.setText(this.module.getJ2eePlatformVersion());
        }
        this.initValues();
        if (this.moduleProvider == null) {
            Logger.getLogger(WebRunCustomizerPanel.class.getName()).info("Module provider instance mising in properties panel. Please report in http://jira.codehaus.org/browse/MEVENIDE-604");
            this.txtContextPath.setText("");
        } else {
            this.txtContextPath.setText(this.moduleProvider.getWebModuleImplementation().getContextPath());
        }
    }

    private void initValues() {
        this.listener = Wrapper.createComboBoxUpdater(this.handle, this.comServer, this.lblServer);
        this.run = ModelHandle.getActiveMapping((String)"run", (Project)this.project);
        this.debug = ModelHandle.getActiveMapping((String)"debug", (Project)this.project);
        this.profile = ModelHandle.getActiveMapping((String)"profile", (Project)this.project);
        this.isRunCompatible = this.checkMapping(this.run);
        this.isDebugCompatible = this.checkMapping(this.debug);
        this.isProfileCompatible = this.checkMapping(this.profile);
        String string = this.oldUrl = this.isRunCompatible ? this.run.getProperties().getProperty(PROP_CLIENT_URL_PART) : this.debug.getProperties().getProperty(PROP_CLIENT_URL_PART);
        if (this.oldUrl != null) {
            this.txtRelativeUrl.setText(this.oldUrl);
        } else {
            this.oldUrl = "";
        }
        this.txtRelativeUrl.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                WebRunCustomizerPanel.this.applyRelUrl();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                WebRunCustomizerPanel.this.applyRelUrl();
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                WebRunCustomizerPanel.this.applyRelUrl();
            }
        });
        String string2 = (String)this.project.getProjectDirectory().getAttribute(PROP_SHOW_IN_BROWSER);
        boolean bl = string2 != null ? Boolean.parseBoolean(string2) : true;
        this.cbBrowser.setSelected(bl);
    }

    private void loadComboModel() {
        String[] stringArray = Deployment.getDefault().getServerInstanceIDs();
        ArrayList<Wrapper> arrayList = new ArrayList<Wrapper>();
        SessionContent sessionContent = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
        if (sessionContent != null && sessionContent.getServerInstanceId() != null) {
            arrayList.add(new Wrapper("DEV-NULL", sessionContent.getServerInstanceId()));
        } else {
            arrayList.add(new Wrapper("DEV-NULL"));
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Wrapper wrapper = new Wrapper(stringArray[i]);
            arrayList.add(wrapper);
        }
        this.comServer.setModel(new DefaultComboBoxModel<Object>(arrayList.toArray()));
    }

    private void initComponents() {
        this.lblServer = new JLabel();
        this.comServer = new JComboBox();
        this.lblJ2EEVersion = new JLabel();
        this.txtJ2EEVersion = new JTextField();
        this.lblContextPath = new JLabel();
        this.txtContextPath = new JTextField();
        this.cbBrowser = new JCheckBox();
        this.lblHint1 = new JLabel();
        this.lblRelativeUrl = new JLabel();
        this.txtRelativeUrl = new JTextField();
        this.lblHint2 = new JLabel();
        this.lblServer.setLabelFor(this.comServer);
        Mnemonics.setLocalizedText((JLabel)this.lblServer, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_Server"));
        this.lblJ2EEVersion.setLabelFor(this.txtJ2EEVersion);
        Mnemonics.setLocalizedText((JLabel)this.lblJ2EEVersion, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_J2EE_Version"));
        this.txtJ2EEVersion.setEditable(false);
        this.lblContextPath.setLabelFor(this.txtContextPath);
        Mnemonics.setLocalizedText((JLabel)this.lblContextPath, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_Context_Path"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbBrowser, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_Display_on_Run"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint1, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_Hint1"));
        this.lblRelativeUrl.setLabelFor(this.txtRelativeUrl);
        Mnemonics.setLocalizedText((JLabel)this.lblRelativeUrl, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_Relative_URL"));
        Mnemonics.setLocalizedText((JLabel)this.lblHint2, (String)NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"LBL_Hint2"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.cbBrowser).add((Component)this.lblHint1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblRelativeUrl).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(2).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblHint2).addPreferredGap(0, 222, Short.MAX_VALUE)).add((Component)this.txtRelativeUrl, -1, 329, Short.MAX_VALUE))).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblContextPath).add((Component)this.lblJ2EEVersion).add((Component)this.lblServer)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (Component)this.comServer, 0, 331, Short.MAX_VALUE).add(2, (Component)this.txtJ2EEVersion, -1, 331, Short.MAX_VALUE).add((Component)this.txtContextPath, -1, 331, Short.MAX_VALUE)))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblServer).add((Component)this.comServer, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblJ2EEVersion).add((Component)this.txtJ2EEVersion, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblContextPath).add((Component)this.txtContextPath, -2, -1, -2)).add(20, 20, 20).add((Component)this.cbBrowser).add(16, 16, 16).add((Component)this.lblHint1).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblRelativeUrl).add((Component)this.txtRelativeUrl, -2, -1, -2)).addPreferredGap(0).add((Component)this.lblHint2).addContainerGap(102, Short.MAX_VALUE)));
        this.txtJ2EEVersion.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"WebRunCustomizerPanel.txtJ2EEVersion.AccessibleContext.accessibleDescription"));
        this.txtContextPath.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"WebRunCustomizerPanel.txtContextPath.AccessibleContext.accessibleDescription"));
        this.cbBrowser.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"WebRunCustomizerPanel.cbBrowser.AccessibleContext.accessibleDescription"));
        this.txtRelativeUrl.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(WebRunCustomizerPanel.class, (String)"WebRunCustomizerPanel.txtRelativeUrl.AccessibleContext.accessibleDescription"));
    }

    private boolean checkMapping(NetbeansActionMapping netbeansActionMapping) {
        if (netbeansActionMapping == null) {
            return false;
        }
        for (String string : netbeansActionMapping.getGoals()) {
            if (string.indexOf("netbeans-deploy-plugin") <= -1) continue;
            return true;
        }
        return netbeansActionMapping.getProperties().containsKey("netbeans.deploy");
    }

    private void applyRelUrl() {
        String string = this.txtRelativeUrl.getText().trim();
        if (!string.equals(this.oldUrl)) {
            if (this.isRunCompatible) {
                this.run.getProperties().setProperty(PROP_CLIENT_URL_PART, string);
                ModelHandle.setUserActionMapping((NetbeansActionMapping)this.run, (ActionToGoalMapping)this.handle.getActionMappings());
                this.handle.markAsModified((Object)this.handle.getActionMappings());
            }
            if (this.isDebugCompatible) {
                this.debug.getProperties().setProperty(PROP_CLIENT_URL_PART, string);
                ModelHandle.setUserActionMapping((NetbeansActionMapping)this.debug, (ActionToGoalMapping)this.handle.getActionMappings());
                this.handle.markAsModified((Object)this.handle.getActionMappings());
            }
            if (this.isProfileCompatible) {
                this.profile.getProperties().setProperty(PROP_CLIENT_URL_PART, string);
                ModelHandle.setUserActionMapping((NetbeansActionMapping)this.profile, (ActionToGoalMapping)this.handle.getActionMappings());
                this.handle.markAsModified((Object)this.handle.getActionMappings());
            }
        }
    }

    void applyChanges() {
        SessionContent sessionContent = (SessionContent)this.project.getLookup().lookup(SessionContent.class);
        sessionContent.setServerInstanceId(null);
        POHImpl pOHImpl = (POHImpl)((Object)this.project.getLookup().lookup(POHImpl.class));
        pOHImpl.setContextPath(this.txtContextPath.getText().trim());
        pOHImpl.hackModuleServerChange();
        this.moduleProvider = (WebModuleProviderImpl)((Object)this.project.getLookup().lookup(WebModuleProviderImpl.class));
        boolean bl = this.cbBrowser.isSelected();
        try {
            this.project.getProjectDirectory().setAttribute(PROP_SHOW_IN_BROWSER, (Object)(bl ? null : Boolean.FALSE.toString()));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        Object object = this.comServer.getSelectedItem();
        if (object != null) {
            LogRecord logRecord = new LogRecord(Level.INFO, "USG_PROJECT_CONFIG_MAVEN_SERVER");
            logRecord.setLoggerName("org.netbeans.ui.metrics.maven");
            logRecord.setParameters(new Object[]{object.toString()});
            POHImpl.USG_LOGGER.log(logRecord);
        }
    }
}

