/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.javascript;

import java.awt.Color;
import java.io.CharConversionException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.mozilla.nb.javascript.Node;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.javascript.editing.AstUtilities;
import org.netbeans.modules.javascript.editing.JsParseResult;
import org.netbeans.modules.javascript.editing.JsUtils;
import org.netbeans.modules.javascript.editing.lexer.JsTokenId;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.xml.XMLUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetoucheUtils {
    private RetoucheUtils() {
    }

    public static boolean isJsFile(FileObject fileObject) {
        return JsUtils.isJsFile((FileObject)fileObject) || fileObject.getMIMEType().equals("application/x-httpd-eruby") || fileObject.getMIMEType().equals("text/html") || fileObject.getMIMEType().equals("text/x-jsp") || fileObject.getMIMEType().equals("text/x-tag") || fileObject.getMIMEType().equals("text/x-php5");
    }

    public static BaseDocument getDocument(Parser.Result result) {
        BaseDocument baseDocument = null;
        if (result != null) {
            baseDocument = (BaseDocument)result.getSnapshot().getSource().getDocument(true);
        }
        return baseDocument;
    }

    public static String[] getNodeNames(Node node) {
        String string = null;
        String string2 = null;
        int n = node.getType();
        if (n == 38 || n == 30) {
            string = AstUtilities.getCallName((Node)node, (boolean)true);
            string2 = AstUtilities.getCallName((Node)node, (boolean)false);
        } else if (node instanceof Node.StringNode) {
            string = node.getString();
        } else if (node.getType() == 108) {
            string = AstUtilities.getFunctionFqn((Node)node, null);
            if (string != null && string.indexOf(46) != -1) {
                string = string.substring(string.indexOf(46) + 1);
            }
        } else {
            return new String[]{null, null};
        }
        if (string2 == null) {
            string2 = string;
        }
        return new String[]{string, string2};
    }

    public static CloneableEditorSupport findCloneableEditorSupport(JsParseResult jsParseResult) {
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)jsParseResult.getSnapshot().getSource().getFileObject());
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        return RetoucheUtils.findCloneableEditorSupport(dataObject);
    }

    public static CloneableEditorSupport findCloneableEditorSupport(DataObject dataObject) {
        Node.Cookie cookie = dataObject.getCookie(OpenCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        cookie = dataObject.getCookie(EditorCookie.class);
        if (cookie instanceof CloneableEditorSupport) {
            return (CloneableEditorSupport)cookie;
        }
        return null;
    }

    public static String htmlize(String string) {
        try {
            return XMLUtil.toElementContent((String)string);
        }
        catch (CharConversionException charConversionException) {
            Exceptions.printStackTrace((Throwable)charConversionException);
            return string;
        }
    }

    public static String getHtml(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        TokenHierarchy tokenHierarchy = TokenHierarchy.create((CharSequence)string, (Language)JsTokenId.language());
        Lookup lookup = MimeLookup.getLookup((MimePath)MimePath.get((String)"text/javascript"));
        FontColorSettings fontColorSettings = (FontColorSettings)lookup.lookup(FontColorSettings.class);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            String string2 = token.id().name();
            AttributeSet attributeSet = fontColorSettings.getTokenFontColors(string2);
            if (attributeSet == null) {
                string2 = token.id().primaryCategory();
                if (string2 == null) {
                    string2 = "whitespace";
                }
                attributeSet = fontColorSettings.getTokenFontColors(string2);
            }
            String string3 = RetoucheUtils.htmlize(((Object)token.text()).toString());
            stringBuffer.append(RetoucheUtils.color(string3, attributeSet));
        }
        return stringBuffer.toString();
    }

    private static String color(String string, AttributeSet attributeSet) {
        if (attributeSet == null) {
            return string;
        }
        if (string.trim().length() == 0) {
            return Utilities.replaceString((String)Utilities.replaceString((String)string, (String)" ", (String)"&nbsp;"), (String)"\n", (String)"<br>");
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        if (StyleConstants.isBold(attributeSet)) {
            stringBuffer.insert(0, "<b>");
            stringBuffer.append("</b>");
        }
        if (StyleConstants.isItalic(attributeSet)) {
            stringBuffer.insert(0, "<i>");
            stringBuffer.append("</i>");
        }
        if (StyleConstants.isStrikeThrough(attributeSet)) {
            stringBuffer.insert(0, "<s>");
            stringBuffer.append("</s>");
        }
        stringBuffer.insert(0, "<font color=" + RetoucheUtils.getHTMLColor(StyleConstants.getForeground(attributeSet)) + ">");
        stringBuffer.append("</font>");
        return stringBuffer.toString();
    }

    private static String getHTMLColor(Color color) {
        String string = "0" + Integer.toHexString(color.getRed());
        string = string.substring(string.length() - 2);
        String string2 = "0" + Integer.toHexString(color.getGreen());
        string2 = string2.substring(string2.length() - 2);
        String string3 = "0" + Integer.toHexString(color.getBlue());
        string3 = string3.substring(string3.length() - 2);
        String string4 = "#" + string + string2 + string3;
        return string4;
    }

    public static boolean isFileInOpenProject(FileObject fileObject) {
        assert (fileObject != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return OpenProjects.getDefault().isProjectOpen(project);
    }

    public static boolean isOnSourceClasspath(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (!project.equals(projectArray[i]) && !projectArray[i].equals(project)) continue;
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("generic");
            for (int j = 0; j < sourceGroupArray.length; ++j) {
                if (fileObject == sourceGroupArray[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroupArray[j].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isRefactorable(FileObject fileObject) {
        return RetoucheUtils.isJsFile(fileObject) && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject);
    }

    public static String getPackageName(FileObject fileObject) {
        assert (fileObject.isFolder()) : "argument must be folder";
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            for (SourceGroup sourceGroup : sources.getSourceGroups("generic")) {
                String string = FileUtil.getRelativePath((FileObject)sourceGroup.getRootFolder(), (FileObject)fileObject);
                if (string == null) continue;
                return string.replace('/', '.');
            }
        }
        return "";
    }

    public static Set<FileObject> getJsFilesInProject(FileObject fileObject) {
        return RetoucheUtils.getJsFilesInProject(fileObject, false);
    }

    public static Set<FileObject> getJsFilesInProject(FileObject fileObject, boolean bl) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>(100);
        Collection collection = QuerySupport.findRoots((FileObject)fileObject, null, Collections.singleton("JavascriptBootClassPath"), Collections.emptySet());
        for (FileObject fileObject2 : collection) {
            String string;
            if (bl && !fileObject2.canWrite() || (string = fileObject2.getName()).equals("vendor") || string.equals("script")) continue;
            RetoucheUtils.addJsFiles(hashSet, fileObject2);
        }
        return hashSet;
    }

    private static void addJsFiles(Set<FileObject> set, FileObject fileObject) {
        if (fileObject.isFolder()) {
            for (FileObject fileObject2 : fileObject.getChildren()) {
                RetoucheUtils.addJsFiles(set, fileObject2);
            }
        } else if (RetoucheUtils.isJsFile(fileObject)) {
            set.add(fileObject);
        }
    }
}

