/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.hyperlinks;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.Document;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.lib.editor.hyperlink.spi.HyperlinkProvider;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.openide.awt.HtmlBrowser;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class HyperlinkProviderImpl
implements HyperlinkProvider {
    public boolean isHyperlinkPoint(Document document, int n) {
        if (!this.isPomFile(document)) {
            return false;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(XMLTokenId.language());
        tokenSequence.move(n);
        tokenSequence.moveNext();
        Token token = tokenSequence.token();
        if (token == null) {
            return false;
        }
        if (token.id() == XMLTokenId.TEXT) {
            String string;
            FileObject fileObject = this.getProjectDir(document);
            if (this.getPath(fileObject, string = ((Object)token.text()).toString()) != null) {
                return true;
            }
            if (string != null && (string.startsWith("http://") || string.startsWith("https://"))) {
                return true;
            }
        }
        return false;
    }

    public int[] getHyperlinkSpan(Document document, int n) {
        if (!this.isPomFile(document)) {
            return null;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(XMLTokenId.language());
        tokenSequence.move(n);
        tokenSequence.moveNext();
        Token token = tokenSequence.token();
        if (token == null) {
            return null;
        }
        if (token.id() == XMLTokenId.TEXT) {
            String string;
            FileObject fileObject = this.getProjectDir(document);
            if (this.getPath(fileObject, string = ((Object)token.text()).toString()) != null) {
                return new int[]{tokenSequence.offset(), tokenSequence.offset() + string.length()};
            }
            if (string != null && (string.startsWith("http://") || string.startsWith("https://"))) {
                return new int[]{tokenSequence.offset(), tokenSequence.offset() + string.length()};
            }
        }
        return null;
    }

    public void performClickAction(Document document, int n) {
        if (!this.isPomFile(document)) {
            return;
        }
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence(XMLTokenId.language());
        tokenSequence.move(n);
        tokenSequence.moveNext();
        Token token = tokenSequence.token();
        if (token == null) {
            return;
        }
        if (token.id() == XMLTokenId.TEXT) {
            URL uRL;
            String string;
            FileObject fileObject = this.getProjectDir(document);
            if (this.getPath(fileObject, string = ((Object)token.text()).toString()) != null) {
                tokenSequence.movePrevious();
                token = tokenSequence.token();
                if (token != null && token.id() == XMLTokenId.TAG && token.text().equals(">")) {
                    tokenSequence.movePrevious();
                    token = tokenSequence.token();
                    if (token != null && token.id() == XMLTokenId.TAG && token.text().equals("<module")) {
                        string = string + "/pom.xml";
                    }
                }
                if (this.getPath(fileObject, string) != null) {
                    uRL = this.getPath(fileObject, string);
                    try {
                        DataObject dataObject = DataObject.find((FileObject)uRL);
                        EditCookie editCookie = (EditCookie)dataObject.getCookie(EditCookie.class);
                        if (editCookie != null) {
                            editCookie.edit();
                        }
                    }
                    catch (DataObjectNotFoundException dataObjectNotFoundException) {
                        dataObjectNotFoundException.printStackTrace();
                    }
                }
            }
            if (string != null && (string.startsWith("http://") || string.startsWith("https://"))) {
                try {
                    uRL = new URL(string);
                    HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    malformedURLException.printStackTrace();
                }
            }
        }
    }

    private FileObject getProjectDir(Document document) {
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)document);
        return dataObject.getPrimaryFile().getParent();
    }

    private FileObject getPath(FileObject fileObject, String string) {
        if (string.startsWith("${basedir}/")) {
            string = string.substring("${basedir}/".length());
        }
        while (string.startsWith("../") && fileObject.getParent() != null) {
            string = string.substring("../".length());
            fileObject = fileObject.getParent();
        }
        return fileObject.getFileObject(string);
    }

    private boolean isPomFile(Document document) {
        DataObject dataObject;
        String string = (String)document.getProperty("mimeType");
        if (string != null) {
            if ("text/x-maven-pom+xml".equals(string)) {
                return true;
            }
            if (!"text/xml".equals(string)) {
                return false;
            }
        }
        if ((dataObject = NbEditorUtilities.getDataObject((Document)document)) != null && "pom.xml".equalsIgnoreCase(dataObject.getPrimaryFile().getNameExt())) {
            return true;
        }
        return dataObject != null && "settings.xml".equals(dataObject.getPrimaryFile().getNameExt()) && ".m2".equals(dataObject.getPrimaryFile().getParent().getNameExt());
    }
}

