/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ProcessInputStream
extends FilterInputStream {
    private static final Logger LOGGER = Logger.getLogger(ProcessInputStream.class.getName());
    private final Process process;
    private byte[] buffer;
    private int position;
    private boolean closed;
    private boolean exhausted;

    public ProcessInputStream(Process process, InputStream inputStream) {
        super(inputStream);
        this.process = process;
    }

    public synchronized int available() throws IOException {
        if (this.buffer != null && this.position < this.buffer.length) {
            return this.buffer.length - this.position;
        }
        if (this.closed) {
            if (!this.exhausted) {
                this.exhausted = true;
                return 0;
            }
            throw new IOException("Already closed stream");
        }
        return super.available();
    }

    public synchronized void close() throws IOException {
        if (!this.closed) {
            this.close(false);
        }
    }

    public void mark(int n) {
    }

    public boolean markSupported() {
        return false;
    }

    public synchronized int read() throws IOException {
        if (this.buffer != null && this.position < this.buffer.length) {
            return this.buffer[this.position++];
        }
        if (this.closed) {
            if (!this.exhausted) {
                this.exhausted = true;
                return -1;
            }
            throw new IOException("Already closed stream");
        }
        return super.read();
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer != null) {
            int n3 = this.buffer.length - this.position;
            int n4 = Math.min(n2, n3);
            System.arraycopy(this.buffer, this.position, byArray, n, n4);
            this.position += n4;
            return n4;
        }
        if (this.closed) {
            if (!this.exhausted) {
                this.exhausted = true;
                return -1;
            }
            throw new IOException("Already closed stream");
        }
        return super.read(byArray, n, n2);
    }

    public void reset() throws IOException {
    }

    public long skip(long l) throws IOException {
        return 0L;
    }

    public synchronized void close(boolean bl) throws IOException {
        this.closed = true;
        if (bl) {
            LOGGER.log(Level.FINE, "Draining process stream");
            boolean bl2 = false;
            try {
                this.process.exitValue();
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                bl2 = true;
            }
            if (bl2) {
                LOGGER.log(Level.FINE, "Process is still running");
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                if (bl2) {
                    while (super.available() > 0) {
                        byteArrayOutputStream.write(super.read());
                    }
                } else {
                    int n;
                    while ((n = super.read()) >= 0) {
                        byteArrayOutputStream.write(n);
                    }
                }
            }
            catch (IOException iOException) {
                LOGGER.log(Level.FINE, null, iOException);
            }
            this.buffer = byteArrayOutputStream.toByteArray();
            LOGGER.log(Level.FINE, "Read {0} bytes from stream", this.buffer.length);
        }
        super.close();
    }
}

