/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grails.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.groovy.grails.KillableProcess;
import org.netbeans.modules.groovy.grails.RuntimeHelper;
import org.netbeans.modules.groovy.grails.api.GrailsEnvironment;
import org.netbeans.modules.groovy.grails.api.GrailsProjectConfig;
import org.netbeans.modules.groovy.grails.server.GrailsInstanceProvider;
import org.netbeans.modules.groovy.grails.settings.GrailsSettings;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GrailsPlatform {
    public static final String IDE_RUN_COMMAND = "run-app";
    private static final Logger LOGGER = Logger.getLogger(GrailsPlatform.class.getName());
    private static final AtomicLong UNIQUE_MARK = new AtomicLong();
    private static final ClassPath EMPTY_CLASSPATH = ClassPathSupport.createClassPath((URL[])new URL[0]);
    private static final Set<String> GUARDED_COMMANDS = new HashSet<String>();
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private static GrailsPlatform instance;
    private Version version;
    private ClassPath classpath;

    private GrailsPlatform() {
    }

    public static synchronized GrailsPlatform getDefault() {
        if (instance == null) {
            instance = new GrailsPlatform();
            GrailsSettings.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("grailsBase".equals(propertyChangeEvent.getPropertyName())) {
                        instance.reload();
                        GrailsInstanceProvider.getInstance().runtimeChanged();
                    }
                }
            });
            instance.reload();
        }
        return instance;
    }

    public Callable<Process> createCommand(CommandDescriptor commandDescriptor) {
        Parameters.notNull((CharSequence)"descriptor", (Object)commandDescriptor);
        if (!this.isConfigured()) {
            throw new IllegalStateException("Grails not configured");
        }
        return new GrailsCallable(commandDescriptor);
    }

    public boolean isConfigured() {
        String string = GrailsSettings.getInstance().getGrailsBase();
        if (string == null) {
            return false;
        }
        return RuntimeHelper.isValidRuntime(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath getClassPath() {
        GrailsPlatform grailsPlatform = this;
        synchronized (grailsPlatform) {
            File file;
            if (this.classpath != null) {
                return this.classpath;
            }
            if (!this.isConfigured()) {
                this.classpath = EMPTY_CLASSPATH;
                return this.classpath;
            }
            File file2 = this.getGrailsHome();
            if (!file2.exists()) {
                this.classpath = EMPTY_CLASSPATH;
                return this.classpath;
            }
            ArrayList<File> arrayList = new ArrayList<File>();
            File file3 = new File(file2, "dist");
            File[] fileArray = file3.listFiles();
            if (fileArray != null) {
                arrayList.addAll(Arrays.asList(fileArray));
            }
            if ((fileArray = (file = new File(file2, "lib")).listFiles()) != null) {
                arrayList.addAll(Arrays.asList(fileArray));
            }
            ArrayList<URL> arrayList2 = new ArrayList<URL>(arrayList.size());
            for (File file4 : arrayList) {
                try {
                    URL uRL;
                    if (!file4.isFile() || !FileUtil.isArchiveFile((URL)(uRL = file4.toURI().toURL()))) continue;
                    uRL = FileUtil.getArchiveRoot((URL)uRL);
                    arrayList2.add(uRL);
                }
                catch (MalformedURLException malformedURLException) {
                    assert (false) : malformedURLException;
                }
            }
            this.classpath = ClassPathSupport.createClassPath((URL[])arrayList2.toArray(new URL[arrayList2.size()]));
            return this.classpath;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version getVersion() {
        GrailsPlatform grailsPlatform = this;
        synchronized (grailsPlatform) {
            if (this.version != null) {
                return this.version;
            }
            String string = GrailsSettings.getInstance().getGrailsBase();
            try {
                String string2;
                this.version = string != null ? ((string2 = RuntimeHelper.getRuntimeVersion(new File(string))) != null ? Version.valueOf(string2) : Version.VERSION_DEFAULT) : Version.VERSION_DEFAULT;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.version = Version.VERSION_DEFAULT;
            }
            return this.version;
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reload() {
        GrailsPlatform grailsPlatform = this;
        synchronized (grailsPlatform) {
            this.version = null;
            this.classpath = null;
        }
        this.changeSupport.fireChange();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GrailsPlatform grailsPlatform = GrailsPlatform.this;
                synchronized (grailsPlatform) {
                    if (GrailsPlatform.this.version != null) {
                        return;
                    }
                    String string = GrailsSettings.getInstance().getGrailsBase();
                    try {
                        if (string != null) {
                            String string2 = RuntimeHelper.getRuntimeVersion(new File(string));
                            if (string2 != null) {
                                GrailsPlatform.this.version = Version.valueOf(string2);
                            } else {
                                GrailsPlatform.this.version = Version.VERSION_DEFAULT;
                            }
                        } else {
                            GrailsPlatform.this.version = Version.VERSION_DEFAULT;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        GrailsPlatform.this.version = Version.VERSION_DEFAULT;
                    }
                }
            }
        });
    }

    public File getGrailsHome() {
        String string = GrailsSettings.getInstance().getGrailsBase();
        if (string == null || !RuntimeHelper.isValidRuntime(new File(string))) {
            throw new IllegalStateException("Grails not configured");
        }
        return new File(string);
    }

    private static String createJvmArguments(Properties properties) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement().toString();
            String string2 = properties.getProperty(string);
            if (string2 == null) continue;
            if (n > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append("-D").append(string);
            stringBuilder.append("=");
            stringBuilder.append(string2);
            ++n;
        }
        return stringBuilder.toString();
    }

    private static String createCommandArguments(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(stringArray[i]);
        }
        return stringBuilder.toString();
    }

    private static void checkForServer(CommandDescriptor commandDescriptor, Process process) {
        Project project;
        if (IDE_RUN_COMMAND.equals(commandDescriptor.getName()) && (project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)commandDescriptor.getDirectory()))) != null) {
            GrailsInstanceProvider.getInstance().serverStarted(project, process);
        }
    }

    static {
        Collections.addAll(GUARDED_COMMANDS, IDE_RUN_COMMAND, "run-app-https", "run-war", "shell");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GrailsCallable
    implements Callable<Process> {
        private static final String USE_PROXY_AUTHENTICATION = "useProxyAuthentication";
        private static final String PROXY_AUTHENTICATION_USERNAME = "proxyAuthenticationUsername";
        private static final String PROXY_AUTHENTICATION_PASSWORD = "proxyAuthenticationPassword";
        private final CommandDescriptor descriptor;

        public GrailsCallable(CommandDescriptor commandDescriptor) {
            this.descriptor = commandDescriptor;
        }

        @Override
        public Process call() throws Exception {
            String[] stringArray;
            String string;
            GrailsEnvironment grailsEnvironment;
            String string2 = Utilities.isWindows() ? "\\bin\\grails.bat" : "/bin/grails";
            File file = null;
            file = RuntimeHelper.isDebian(new File(GrailsSettings.getInstance().getGrailsBase())) ? new File("/usr/bin/grails") : new File(GrailsSettings.getInstance().getGrailsBase(), string2);
            if (!file.exists()) {
                LOGGER.log(Level.WARNING, "Executable doesn't exist: " + file.getAbsolutePath());
                return null;
            }
            LOGGER.log(Level.FINEST, "About to run: {0}", this.descriptor.getName());
            Properties properties = new Properties(this.descriptor.getProps());
            GrailsEnvironment grailsEnvironment2 = grailsEnvironment = this.descriptor.getProjectConfig() != null ? this.descriptor.getProjectConfig().getEnvironment() : null;
            if (grailsEnvironment != null && grailsEnvironment.isCustom()) {
                properties.setProperty("grails.env", grailsEnvironment.toString());
            }
            if (this.descriptor.getProjectConfig() != null && GrailsPlatform.IDE_RUN_COMMAND.equals(this.descriptor.getName()) && (string = this.descriptor.getProjectConfig().getPort()) != null) {
                properties.setProperty("server.port", string);
            }
            properties.setProperty("jline.WindowsTerminal.directConsole", "false");
            string = GrailsCallable.getNetBeansHttpProxy(properties);
            StringBuilder stringBuilder = new StringBuilder();
            if (grailsEnvironment != null && !grailsEnvironment.isCustom()) {
                stringBuilder.append(" ").append(grailsEnvironment.toString());
            }
            stringBuilder.append(" ").append(this.descriptor.getName());
            stringBuilder.append(" ").append(GrailsPlatform.createCommandArguments(this.descriptor.getArguments()));
            String string3 = "";
            if (Utilities.isWindows() && GUARDED_COMMANDS.contains(this.descriptor.getName())) {
                string3 = UNIQUE_MARK.getAndIncrement() + this.descriptor.getDirectory().getAbsolutePath();
                stringBuilder.append(" ").append("REM NB:" + string3);
            }
            LOGGER.log(Level.FINEST, "Command is: {0}", stringBuilder.toString());
            NbProcessDescriptor nbProcessDescriptor = new NbProcessDescriptor(file.getAbsolutePath(), stringBuilder.toString());
            String string4 = null;
            JavaPlatform javaPlatform = this.descriptor.getProjectConfig() != null ? this.descriptor.getProjectConfig().getJavaPlatform() : JavaPlatformManager.getDefault().getDefaultPlatform();
            Collection collection = javaPlatform.getInstallFolders();
            if (collection.size() == 1 && (stringArray = FileUtil.toFile((FileObject)((FileObject)collection.iterator().next()))) != null) {
                string4 = stringArray.getAbsolutePath();
            }
            stringArray = new String[]{"GRAILS_HOME=" + GrailsSettings.getInstance().getGrailsBase(), "JAVA_HOME=" + string4, "http_proxy=" + string, "HTTP_PROXY=" + string, "JAVA_OPTS=" + GrailsPlatform.createJvmArguments(properties)};
            KillableProcess killableProcess = null;
            try {
                killableProcess = new KillableProcess(nbProcessDescriptor.exec(null, stringArray, true, this.descriptor.getDirectory()), this.descriptor.getName(), string3);
            }
            catch (IOException iOException) {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(GrailsPlatform.class, (String)"MSG_StartFailedIOE", (Object)file.getAbsolutePath()), 0);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)message);
                throw iOException;
            }
            GrailsPlatform.checkForServer(this.descriptor, killableProcess);
            return killableProcess;
        }

        private static String getNetBeansHttpProxy(Properties properties) {
            int n;
            String string = System.getProperty("http.proxyHost");
            if (string == null) {
                return null;
            }
            String string2 = System.getProperty("http.proxyPort");
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                n = 8080;
            }
            Preferences preferences = NbPreferences.root().node("org/netbeans/core");
            boolean bl = preferences.getBoolean(USE_PROXY_AUTHENTICATION, false);
            String string3 = "";
            if (bl) {
                String string4 = preferences.get(PROXY_AUTHENTICATION_USERNAME, "");
                String string5 = preferences.get(PROXY_AUTHENTICATION_PASSWORD, "");
                string3 = string4 + ":" + string5 + '@';
                if (!properties.contains("http.proxyUser")) {
                    properties.setProperty("http.proxyUser", preferences.get(PROXY_AUTHENTICATION_USERNAME, ""));
                }
                if (!properties.contains("http.proxyPassword")) {
                    properties.setProperty("http.proxyPassword", preferences.get(PROXY_AUTHENTICATION_PASSWORD, ""));
                }
            }
            if (!properties.contains("http.proxyHost")) {
                properties.setProperty("http.proxyHost", string);
            }
            if (!properties.contains("http.proxyPort")) {
                properties.setProperty("http.proxyPort", Integer.toString(n));
            }
            if (string.indexOf(58) == -1) {
                string = "http://" + string3 + string;
            }
            return string + ":" + n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Version
    implements Comparable<Version> {
        public static final Version VERSION_DEFAULT = new Version(1, null, null, null, null);
        public static final Version VERSION_1_1 = new Version(1, 1, null, null, null);
        private final int major;
        private final Integer minor;
        private final Integer micro;
        private final Integer update;
        private final String qualifier;
        private String asString;

        protected Version(int n, Integer n2, Integer n3, Integer n4, String string) {
            this.major = n;
            this.minor = n2;
            this.micro = n3;
            this.update = n4;
            this.qualifier = string;
        }

        public static Version valueOf(String string) {
            String[] stringArray;
            String[] stringArray2 = string.split("-");
            String string2 = null;
            if (stringArray2.length > 2) {
                throw new IllegalArgumentException(string);
            }
            if (stringArray2.length == 2) {
                string2 = stringArray2[1];
            }
            if ((stringArray = stringArray2[0].split("\\.")).length < 1 || stringArray.length > 4) {
                throw new IllegalArgumentException(string);
            }
            try {
                Integer[] integerArray = new Integer[4];
                for (int i = 0; i < stringArray.length; ++i) {
                    integerArray[i] = Integer.valueOf(stringArray[i]);
                }
                return new Version(integerArray[0], integerArray[1], integerArray[2], integerArray[3], string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException(string, numberFormatException);
            }
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor == null ? 0 : this.minor;
        }

        public int getMicro() {
            return this.micro == null ? 0 : this.micro;
        }

        public int getUpdate() {
            return this.update == null ? 0 : this.update;
        }

        public String getQualifier() {
            return this.qualifier == null ? "" : this.qualifier;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Version version = (Version)object;
            if (this.getMajor() != version.getMajor()) {
                return false;
            }
            if (this.getMinor() != version.getMinor()) {
                return false;
            }
            if (this.getMicro() != version.getMicro()) {
                return false;
            }
            if (this.getUpdate() != version.getUpdate()) {
                return false;
            }
            return this.getQualifier().equals(version.getQualifier());
        }

        public int hashCode() {
            int n = 7;
            n = 71 * n + this.getMajor();
            n = 71 * n + this.getMinor();
            n = 71 * n + this.getMicro();
            n = 71 * n + this.getUpdate();
            n = 71 * n + this.getQualifier().hashCode();
            return n;
        }

        @Override
        public int compareTo(Version version) {
            if (this == version) {
                return 0;
            }
            int n = this.getMajor() - version.getMajor();
            if (n != 0) {
                return n;
            }
            n = this.getMinor() - version.getMinor();
            if (n != 0) {
                return n;
            }
            n = this.getMicro() - version.getMicro();
            if (n != 0) {
                return n;
            }
            n = this.getUpdate() - version.getUpdate();
            if (n != 0) {
                return n;
            }
            return this.getQualifier().compareTo(version.getQualifier());
        }

        public String toString() {
            if (this.asString == null) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.major);
                if (this.minor != null || this.micro != null || this.update != null) {
                    this.appendSeparator(stringBuilder);
                    stringBuilder.append(this.minor == null ? 0 : this.minor);
                }
                if (this.micro != null || this.update != null) {
                    this.appendSeparator(stringBuilder);
                    stringBuilder.append(this.micro == null ? 0 : this.micro);
                }
                if (this.update != null) {
                    this.appendSeparator(stringBuilder);
                    stringBuilder.append(this.update == null ? 0 : this.update);
                }
                if (this.qualifier != null) {
                    stringBuilder.append('-');
                    stringBuilder.append(this.qualifier);
                }
                this.asString = stringBuilder.toString();
            }
            return this.asString;
        }

        private void appendSeparator(StringBuilder stringBuilder) {
            if (stringBuilder.length() > 0 && stringBuilder.charAt(stringBuilder.length() - 1) != '.') {
                stringBuilder.append('.');
            }
        }
    }

    public static final class CommandDescriptor {
        private final String name;
        private final File directory;
        private final GrailsProjectConfig config;
        private final String[] arguments;
        private final Properties props;

        public static CommandDescriptor forProject(String string, File file, GrailsProjectConfig grailsProjectConfig, String[] stringArray, Properties properties) {
            return new CommandDescriptor(string, file, grailsProjectConfig, stringArray, properties);
        }

        private CommandDescriptor(String string, File file, GrailsProjectConfig grailsProjectConfig, String[] stringArray, Properties properties) {
            this.name = string;
            this.directory = file;
            this.config = grailsProjectConfig;
            this.arguments = (String[])stringArray.clone();
            this.props = properties != null ? new Properties(properties) : new Properties();
        }

        public String getName() {
            return this.name;
        }

        public File getDirectory() {
            return this.directory;
        }

        public GrailsProjectConfig getProjectConfig() {
            return this.config;
        }

        public String[] getArguments() {
            return (String[])this.arguments.clone();
        }

        public Properties getProps() {
            return new Properties(this.props);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            CommandDescriptor commandDescriptor = (CommandDescriptor)object;
            return !(this.name == null ? commandDescriptor.name != null : !this.name.equals(commandDescriptor.name));
        }

        public int hashCode() {
            int n = 7;
            n = 41 * n + (this.name != null ? this.name.hashCode() : 0);
            return n;
        }
    }
}

