/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project;

import java.io.IOException;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.php.project.UpdateImplementation;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.w3c.dom.Element;

public final class UpdateHelper {
    private final UpdateImplementation updateProject;
    private final AntProjectHelper helper;

    public UpdateHelper(UpdateImplementation updateImplementation, AntProjectHelper antProjectHelper) {
        assert (updateImplementation != null);
        assert (antProjectHelper != null);
        this.updateProject = updateImplementation;
        this.helper = antProjectHelper;
    }

    public EditableProperties getProperties(final String string) {
        return (EditableProperties)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<EditableProperties>(){

            public EditableProperties run() {
                if (!UpdateHelper.this.isCurrent() && "nbproject/project.properties".equals(string)) {
                    return UpdateHelper.this.updateProject.getUpdatedProjectProperties();
                }
                return UpdateHelper.this.helper.getProperties(string);
            }
        });
    }

    public void putProperties(final String string, final EditableProperties editableProperties) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (UpdateHelper.this.isCurrent() || !"nbproject/project.properties".equals(string)) {
                    UpdateHelper.this.helper.putProperties(string, editableProperties);
                } else if (UpdateHelper.this.updateProject.canUpdate()) {
                    try {
                        UpdateHelper.this.updateProject.saveUpdate(editableProperties);
                        UpdateHelper.this.helper.putProperties(string, editableProperties);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        });
    }

    public Element getPrimaryConfigurationData(final boolean bl) {
        return (Element)ProjectManager.mutex().readAccess((Mutex.Action)new Mutex.Action<Element>(){

            public Element run() {
                if (!bl || UpdateHelper.this.isCurrent()) {
                    return UpdateHelper.this.helper.getPrimaryConfigurationData(bl);
                }
                return UpdateHelper.this.updateProject.getUpdatedSharedConfigurationData();
            }
        });
    }

    public void putPrimaryConfigurationData(final Element element, final boolean bl) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            public void run() {
                if (!bl || UpdateHelper.this.isCurrent()) {
                    UpdateHelper.this.helper.putPrimaryConfigurationData(element, bl);
                } else if (UpdateHelper.this.updateProject.canUpdate()) {
                    try {
                        UpdateHelper.this.updateProject.saveUpdate(null);
                        UpdateHelper.this.helper.putPrimaryConfigurationData(element, bl);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                }
            }
        });
    }

    public boolean requestUpdate() throws IOException {
        try {
            return (Boolean)ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Boolean>(){

                public Boolean run() throws IOException {
                    if (UpdateHelper.this.isCurrent()) {
                        return true;
                    }
                    if (!UpdateHelper.this.updateProject.canUpdate()) {
                        return false;
                    }
                    UpdateHelper.this.updateProject.saveUpdate(null);
                    return true;
                }
            });
        }
        catch (MutexException mutexException) {
            Exception exception = mutexException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw (RuntimeException)exception;
        }
    }

    public boolean isCurrent() {
        return this.updateProject.isCurrent();
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }
}

