/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.common;

import org.openide.util.NbBundle;

public final class RemoteValidator {
    public static final int MINIMUM_PORT = 0;
    public static final int MAXIMUM_PORT = 65535;

    private RemoteValidator() {
    }

    public static String validateRememberPassword(char[] cArray) {
        assert (cArray != null);
        if (cArray.length > 0) {
            return NbBundle.getMessage(RemoteValidator.class, (String)"MSG_PasswordRememberDangerous");
        }
        return null;
    }

    public static String validateHost(String string) {
        assert (string != null);
        if (string.trim().length() == 0) {
            return NbBundle.getMessage(RemoteValidator.class, (String)"MSG_NoHostName");
        }
        return null;
    }

    public static String validateUser(String string) {
        if (string.trim().length() == 0) {
            return NbBundle.getMessage(RemoteValidator.class, (String)"MSG_NoUserName");
        }
        return null;
    }

    public static String validatePort(String string) {
        String string2 = null;
        try {
            int n = Integer.parseInt(string);
            if (n < 0 || n > 65535) {
                string2 = NbBundle.getMessage(RemoteValidator.class, (String)"MSG_PortInvalid", (Object)String.valueOf(0), (Object)String.valueOf(65535));
            }
        }
        catch (NumberFormatException numberFormatException) {
            string2 = NbBundle.getMessage(RemoteValidator.class, (String)"MSG_PortNotNumeric");
        }
        return string2;
    }

    public static String validateTimeout(String string) {
        String string2 = null;
        try {
            int n = Integer.parseInt(string);
            if (n < 0) {
                string2 = NbBundle.getMessage(RemoteValidator.class, (String)"MSG_TimeoutNotPositive");
            }
        }
        catch (NumberFormatException numberFormatException) {
            string2 = NbBundle.getMessage(RemoteValidator.class, (String)"MSG_TimeoutNotNumeric");
        }
        return string2;
    }
}

